/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiMember;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

public class CipherGetInstanceDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("GetInstance", "Cipher.getInstance with ECB", "`Cipher#getInstance` should not be called with ECB as the cipher mode or without setting the cipher mode because the default mode on android is ECB, which is insecure.", Category.SECURITY, 9, Severity.WARNING, new Implementation(CipherGetInstanceDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String CIPHER = "javax.crypto.Cipher";
    private static final String GET_INSTANCE = "getInstance";
    private static final Set<String> ALGORITHM_ONLY = Sets.newHashSet((Object[])new String[]{"AES", "DES", "DESede"});
    private static final String ECB = "ECB";

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(GET_INSTANCE);
    }

    @Override
    public void visitMethod(JavaContext context, UastVisitor visitor, UCallExpression node, UMethod method) {
        UExpression expression2;
        Object value2;
        if (!context.getEvaluator().isMemberInSubClassOf((PsiMember)method, CIPHER, false)) {
            return;
        }
        List arguments = node.getValueArguments();
        if (arguments.size() == 1 && (value2 = ConstantEvaluator.evaluate(context, (UElement)(expression2 = (UExpression)arguments.get(0)))) instanceof String) {
            CipherGetInstanceDetector.checkParameter(context, node, (UElement)expression2, (String)value2, !(expression2 instanceof ULiteralExpression));
        }
    }

    private static void checkParameter(JavaContext context, UCallExpression call, UElement node, String value2, boolean includeValue) {
        if (ALGORITHM_ONLY.contains(value2)) {
            String message = "`Cipher.getInstance` should not be called without setting the encryption mode and padding";
            context.report(ISSUE, (UElement)call, context.getUastLocation(node), message);
        } else if (value2.contains(ECB)) {
            String message = "ECB encryption mode should not be used";
            if (includeValue) {
                message = message + " (was \"" + value2 + "\")";
            }
            context.report(ISSUE, (UElement)call, context.getUastLocation(node), message);
        }
    }
}

