/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.checks.StringFormatDetector;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

public class LocaleDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LocaleDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue STRING_LOCALE = Issue.create("DefaultLocale", "Implied default locale in case conversion", "Calling `String#toLowerCase()` or `#toUpperCase()` *without specifying an explicit locale* is a common source of bugs. The reason for that is that those methods will use the current locale on the user's device, and even though the code appears to work correctly when you are developing the app, it will fail in some locales. For example, in the Turkish locale, the uppercase replacement for `i` is *not* `I`.\n\nIf you want the methods to just perform ASCII replacement, for example to convert an enum name, call `String#toUpperCase(Locale.US)` instead. If you really want to use the current locale, call `String#toUpperCase(Locale.getDefault())` instead.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/reference/java/util/Locale.html#default_locale");

    @Override
    public List<String> getApplicableMethodNames() {
        if (LintClient.isStudio()) {
            return Collections.singletonList("format");
        }
        return Arrays.asList("toLowerCase", "toUpperCase", "format");
    }

    @Override
    public void visitMethod(JavaContext context, UastVisitor visitor, UCallExpression call, UMethod method) {
        if (JavaEvaluator.isMemberInClass((PsiMember)method, "java.lang.String")) {
            String name = method.getName();
            if (name.equals("format")) {
                LocaleDetector.checkFormat(context, (PsiMethod)method, call);
            } else if (method.getParameterList().getParametersCount() == 0) {
                Location location = context.getUastNameLocation((UElement)call);
                String message = String.format("Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead", name);
                context.report(STRING_LOCALE, (UElement)call, location, message);
            }
        }
    }

    private static boolean isLoggingParameter(UCallExpression node) {
        String name;
        UCallExpression parentCall = (UCallExpression)UastUtils.getParentOfType((UElement)node, UCallExpression.class, (boolean)true);
        if (parentCall != null && (name = parentCall.getMethodName()) != null && name.length() == 1) {
            PsiMethod method = parentCall.resolve();
            return JavaEvaluator.isMemberInClass((PsiMember)method, "android.util.Log");
        }
        return false;
    }

    private static void checkFormat(JavaContext context, PsiMethod method, UCallExpression call) {
        if (method.getParameterList().getParametersCount() == 0 || !context.getEvaluator().parameterHasType(method, 0, "java.lang.String")) {
            return;
        }
        List expressions2 = call.getValueArguments();
        if (expressions2.isEmpty()) {
            return;
        }
        UExpression first = (UExpression)expressions2.get(0);
        Object value2 = ConstantEvaluator.evaluate(context, (UElement)first);
        if (!(value2 instanceof String)) {
            return;
        }
        String format = (String)value2;
        if (StringFormatDetector.isLocaleSpecific(format)) {
            if (LocaleDetector.isLoggingParameter(call)) {
                return;
            }
            Location location = context.getUastLocation((UElement)call);
            String message = "Implicitly using the default locale is a common source of bugs: Use `String.format(Locale, ...)` instead";
            context.report(STRING_LOCALE, (UElement)call, location, message);
        }
    }
}

