/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeStyle;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroovyCodeStyleGenerationConfigurable
implements CodeStyleConfigurable {
    private final CodeStyleSettings mySettings;
    private final MembersOrderList myMembersOrderList;

    public GroovyCodeStyleGenerationConfigurable(CodeStyleSettings settings) {
        this.mySettings = settings;
        this.myMembersOrderList = new MembersOrderList();
    }

    @Nullable
    public JComponent createComponent() {
        JPanel panel = ToolbarDecorator.createDecorator((JList)((Object)this.myMembersOrderList)).disableAddAction().disableRemoveAction().createPanel();
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.order.of.members", (Object[])new Object[0]), (boolean)true, (Insets)new JBInsets(0, 10, 10, 10)));
        JPanel wholePanel = new JPanel(new BorderLayout());
        wholePanel.add((Component)panel, "North");
        return wholePanel;
    }

    public boolean isModified() {
        return this.myMembersOrderList.isModified(this.mySettings);
    }

    public void apply() throws ConfigurationException {
        this.apply(this.mySettings);
    }

    public void reset() {
        this.reset(this.mySettings);
    }

    @Nls
    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.code.generation", (Object[])new Object[0]);
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/groovy/codeStyle/GroovyCodeStyleGenerationConfigurable", "reset"));
        }
        this.myMembersOrderList.reset(settings);
    }

    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/groovy/codeStyle/GroovyCodeStyleGenerationConfigurable", "apply"));
        }
        this.myMembersOrderList.apply(settings);
    }

    public static class MembersOrderList
    extends JBList {
        private static final Map<String, PropertyManager> PROPERTIES = new HashMap<String, PropertyManager>();
        private final DefaultListModel myModel = new DefaultListModel();

        public MembersOrderList() {
            this.setModel(this.myModel);
            this.setVisibleRowCount(PROPERTIES.size());
        }

        public void reset(CodeStyleSettings settings) {
            this.myModel.removeAllElements();
            for (String string : MembersOrderList.getPropertyNames(settings)) {
                this.myModel.addElement(string);
            }
            this.setSelectedIndex(0);
        }

        private static void init() {
            PropertyManager staticFieldManager = new PropertyManager("listbox.members.order.static.fields"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.STATIC_FIELDS_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.STATIC_FIELDS_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(staticFieldManager.myName, staticFieldManager);
            PropertyManager instanceFieldManager = new PropertyManager("listbox.members.order.fields"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.FIELDS_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.FIELDS_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(instanceFieldManager.myName, instanceFieldManager);
            PropertyManager constructorManager = new PropertyManager("listbox.members.order.constructors"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.CONSTRUCTORS_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.CONSTRUCTORS_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(constructorManager.myName, constructorManager);
            PropertyManager staticMethodManager = new PropertyManager("listbox.members.order.static.methods"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.STATIC_METHODS_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.STATIC_METHODS_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(staticMethodManager.myName, staticMethodManager);
            PropertyManager instanceMethodManager = new PropertyManager("listbox.members.order.methods"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.METHODS_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.METHODS_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(instanceMethodManager.myName, instanceMethodManager);
            PropertyManager staticInnerClassManager = new PropertyManager("listbox.members.order.inner.static.classes"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.STATIC_INNER_CLASSES_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.STATIC_INNER_CLASSES_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(staticInnerClassManager.myName, staticInnerClassManager);
            PropertyManager innerClassManager = new PropertyManager("listbox.members.order.inner.classes"){

                @Override
                void apply(CodeStyleSettings settings, int value) {
                    settings.INNER_CLASSES_ORDER_WEIGHT = value;
                }

                @Override
                int getValue(CodeStyleSettings settings) {
                    return settings.INNER_CLASSES_ORDER_WEIGHT;
                }
            };
            PROPERTIES.put(innerClassManager.myName, innerClassManager);
        }

        private static Iterable<String> getPropertyNames(final CodeStyleSettings settings) {
            ArrayList<String> result = new ArrayList<String>(PROPERTIES.keySet());
            Collections.sort(result, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int weight1 = this.getWeight(o1);
                    int weight2 = this.getWeight(o2);
                    return weight1 - weight2;
                }

                private int getWeight(String o) {
                    PropertyManager propertyManager = (PropertyManager)PROPERTIES.get(o);
                    if (propertyManager == null) {
                        throw new IllegalArgumentException("unexpected " + o);
                    }
                    return propertyManager.getValue(settings);
                }
            });
            return result;
        }

        public void apply(CodeStyleSettings settings) {
            for (int i = 0; i < this.myModel.size(); ++i) {
                Object o = this.myModel.getElementAt(i);
                if (o == null) {
                    throw new IllegalArgumentException("unexpected " + o);
                }
                PropertyManager propertyManager = PROPERTIES.get(o.toString());
                if (propertyManager == null) {
                    throw new IllegalArgumentException("unexpected " + o);
                }
                propertyManager.apply(settings, i + 1);
            }
        }

        public boolean isModified(CodeStyleSettings settings) {
            Iterable<String> oldProperties = MembersOrderList.getPropertyNames(settings);
            int i = 0;
            for (String property : oldProperties) {
                if (i >= this.myModel.size() || !property.equals(this.myModel.getElementAt(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        static {
            MembersOrderList.init();
        }

        private static abstract class PropertyManager {
            public final String myName;

            protected PropertyManager(String nameKey) {
                this.myName = ApplicationBundle.message((String)nameKey, (Object[])new Object[0]);
            }

            abstract void apply(CodeStyleSettings var1, int var2);

            abstract int getValue(CodeStyleSettings var1);
        }
    }
}

