/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.MissingMethodAndPropertyUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        GrParameter parameter;
        PsiElement scope;
        if (element instanceof GrMethod) {
            GrMethod method = (GrMethod)element;
            if (PsiUtil.OPERATOR_METHOD_NAMES.contains(method.getName())) {
                return true;
            }
            if (MissingMethodAndPropertyUtil.isPropertyMissing(method)) {
                return true;
            }
            if (MissingMethodAndPropertyUtil.isMethodMissing(method)) {
                return true;
            }
            if (GrImplicitUsageProvider.isDelegateAnnotated(method)) {
                return true;
            }
        } else if (element instanceof GrParameter && (scope = (parameter = (GrParameter)element).getDeclarationScope()) instanceof GrMethod && (MissingMethodAndPropertyUtil.isMethodMissing((GrMethod)scope) || MissingMethodAndPropertyUtil.isPropertyMissing((GrMethod)scope))) {
            return true;
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return element instanceof GrField && GrImplicitUsageProvider.isDelegateAnnotated((PsiModifierListOwner)((GrField)element));
    }

    public boolean isImplicitWrite(PsiElement element) {
        return false;
    }

    private static boolean isDelegateAnnotated(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/plugins/groovy/findUsages/GrImplicitUsageProvider", "isDelegateAnnotated"));
        }
        return PsiImplUtil.getAnnotation(owner, "groovy.lang.Delegate") != null;
    }
}

