/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyPresentationUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ConvertClosureToMethodIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.intentions.conversions.ConvertClosureToMethodIntention");

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MyPredicate myPredicate = new MyPredicate();
        if (myPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertClosureToMethodIntention", "getElementPredicate"));
        }
        return myPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        String fieldName;
        GrAccessorMethod[] getters;
        GrField field;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertClosureToMethodIntention", "processIntention"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertClosureToMethodIntention", "processIntention"));
        }
        if (element.getParent() instanceof GrField) {
            field = (GrField)element.getParent();
        } else {
            PsiReference ref = element.getReference();
            LOG.assertTrue(ref != null);
            PsiElement resolved = ref.resolve();
            if (resolved instanceof GrAccessorMethod) {
                resolved = ((GrAccessorMethod)resolved).getProperty();
            }
            LOG.assertTrue(resolved instanceof GrField);
            field = (GrField)resolved;
        }
        HashSet usages = new HashSet();
        usages.addAll(ReferencesSearch.search((PsiElement)field).findAll());
        for (GrAccessorMethod getter : getters = field.getGetters()) {
            usages.addAll(MethodReferencesSearch.search((PsiMethod)getter).findAll());
        }
        GrAccessorMethod setter = field.getSetter();
        if (setter != null) {
            usages.addAll(MethodReferencesSearch.search((PsiMethod)setter).findAll());
        }
        LOG.assertTrue((fieldName = field.getName()) != null);
        HashSet fieldUsages = new HashSet();
        MultiMap conflicts = new MultiMap();
        for (PsiReference usage : usages) {
            PsiElement psiElement = usage.getElement();
            if (PsiUtil.isMethodUsage(psiElement)) continue;
            if (!((Object)((Object)GroovyLanguage.INSTANCE)).equals(psiElement.getLanguage())) {
                conflicts.putValue((Object)psiElement, (Object)GroovyIntentionsBundle.message("closure.is.accessed.outside.of.groovy", fieldName));
                continue;
            }
            if (psiElement instanceof GrReferenceExpression) {
                fieldUsages.add(psiElement);
                if (!PsiUtil.isAccessedForWriting((GrExpression)psiElement)) continue;
                conflicts.putValue((Object)psiElement, (Object)GroovyIntentionsBundle.message("write.access.to.closure.variable", fieldName));
                continue;
            }
            if (!(psiElement instanceof GrArgumentLabel)) continue;
            conflicts.putValue((Object)psiElement, (Object)GroovyIntentionsBundle.message("field.is.used.in.argument.label", fieldName));
        }
        PsiClass containingClass = field.getContainingClass();
        GrExpression initializer = field.getInitializerGroovy();
        LOG.assertTrue(initializer != null);
        PsiType type = initializer.getType();
        LOG.assertTrue(type instanceof GrClosureType);
        GrSignature signature = ((GrClosureType)type).getSignature();
        List<MethodSignature> signatures = GrClosureSignatureUtil.generateAllMethodSignaturesBySignature(fieldName, signature);
        for (MethodSignature s : signatures) {
            PsiMethod method = MethodSignatureUtil.findMethodBySignature((PsiClass)containingClass, (MethodSignature)s, (boolean)true);
            if (method == null) continue;
            conflicts.putValue((Object)method, (Object)GroovyIntentionsBundle.message("method.with.signature.already.exists", GroovyPresentationUtil.getSignaturePresentation(s)));
        }
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts, () -> ConvertClosureToMethodIntention.lambda$processIntention$0(field, (Collection)fieldUsages));
            conflictsDialog.show();
            if (conflictsDialog.getExitCode() != 0) {
                return;
            }
        }
        ConvertClosureToMethodIntention.execute(field, (Collection<PsiElement>)fieldUsages);
    }

    private static void execute(GrField field, Collection<PsiElement> fieldUsages) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(field.getProject());
        StringBuilder builder = new StringBuilder(field.getTextLength());
        GrClosableBlock block = (GrClosableBlock)field.getInitializerGroovy();
        GrModifierList modifierList = field.getModifierList();
        if (modifierList.getModifiers().length > 0 || modifierList.getAnnotations().length > 0) {
            builder.append(modifierList.getText());
        } else {
            builder.append("def");
        }
        builder.append(' ').append(field.getName());
        builder.append('(');
        if (block.hasParametersSection()) {
            builder.append(block.getParameterList().getText());
        } else {
            builder.append("def it = null");
        }
        builder.append(") {");
        ApplicationManager.getApplication().runWriteAction(() -> {
            block.getParameterList().delete();
            block.getLBrace().delete();
            PsiElement psiElement = PsiUtil.skipWhitespacesAndComments(block.getFirstChild(), true);
            if (psiElement != null && "->".equals(psiElement.getText())) {
                psiElement.delete();
            }
            builder.append(block.getText());
            GrMethod method = GroovyPsiElementFactory.getInstance(field.getProject()).createMethodFromText(builder.toString());
            field.getParent().replace((PsiElement)method);
            for (PsiElement usage : fieldUsages) {
                if (!(usage instanceof GrReferenceExpression)) continue;
                PsiElement parent = usage.getParent();
                StringBuilder newRefText = new StringBuilder();
                if (parent instanceof GrReferenceExpression && usage == ((GrReferenceExpression)parent).getQualifier() && "call".equals(((GrReferenceExpression)parent).getReferenceName())) {
                    newRefText.append(usage.getText());
                    usage = parent;
                } else {
                    PsiElement qualifier = ((GrReferenceExpression)usage).getQualifier();
                    if (qualifier == null && parent instanceof GrReferenceExpression && ((GrReferenceExpression)parent).getQualifier() != null && usage != ((GrReferenceExpression)parent).getQualifier()) {
                        qualifier = ((GrReferenceExpression)parent).getQualifier();
                        usage = parent;
                    }
                    if (qualifier != null) {
                        newRefText.append(qualifier.getText()).append('.');
                        ((GrReferenceExpression)usage).setQualifier(null);
                    } else {
                        newRefText.append("this.");
                    }
                    newRefText.append('&').append(usage.getText());
                }
                usage.replace((PsiElement)factory.createReferenceExpressionFromText(newRefText.toString()));
            }
        });
    }

    private static /* synthetic */ void lambda$processIntention$0(GrField field, Collection fieldUsages) {
        ConvertClosureToMethodIntention.execute(field, fieldUsages);
    }

    private static class MyPredicate
    implements PsiElementPredicate {
        private MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            GrField field;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/ConvertClosureToMethodIntention$MyPredicate", "satisfiedBy"));
            }
            if (element.getLanguage() != GroovyLanguage.INSTANCE) {
                return false;
            }
            PsiReference ref = element.getReference();
            if (ref != null) {
                PsiElement resolved = ref.resolve();
                if (resolved instanceof GrAccessorMethod) {
                    resolved = ((GrAccessorMethod)resolved).getProperty();
                }
                if (!(resolved instanceof GrField)) {
                    return false;
                }
                field = (GrField)resolved;
            } else {
                PsiElement parent = element.getParent();
                if (!(parent instanceof GrField)) {
                    return false;
                }
                field = (GrField)parent;
                if (field.getNameIdentifierGroovy() != element) {
                    return false;
                }
            }
            PsiElement varDeclaration = field.getParent();
            if (!(varDeclaration instanceof GrVariableDeclaration)) {
                return false;
            }
            if (((GrVariableDeclaration)varDeclaration).getVariables().length != 1) {
                return false;
            }
            GrExpression expression = field.getInitializerGroovy();
            return expression instanceof GrClosableBlock;
        }
    }
}

