/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.ProcessingContext;
import com.intellij.util.VisibilityUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.handlers.GroovyMethodOverrideHandler;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.util.GroovyOverrideImplementExploreUtil;

class GrMethodOverrideCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final ElementPattern<PsiElement> PLACE = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(GrTypeDefinitionBody.class)).with((PatternCondition)new PatternCondition<PsiElement>("Not in extends/implements clause of inner class"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/completion/GrMethodOverrideCompletionProvider$1", "accepts"));
            }
            GrTypeDefinition innerDefinition = (GrTypeDefinition)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, GrTypeDefinition.class);
            return innerDefinition == null || innerDefinition.getContainingClass() == null || innerDefinition.getBody() != null;
        }
    })).andNot((ElementPattern)PlatformPatterns.psiComment());

    GrMethodOverrideCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/groovy/lang/completion/GrMethodOverrideCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/lang/completion/GrMethodOverrideCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        GrTypeDefinition currentClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)position, GrTypeDefinition.class);
        if (currentClass != null) {
            GrMethodOverrideCompletionProvider.addSuperMethods(currentClass, result, false);
            GrMethodOverrideCompletionProvider.addSuperMethods(currentClass, result, true);
        }
    }

    public static void register(CompletionContributor contributor) {
        contributor.extend(CompletionType.BASIC, PLACE, (CompletionProvider)new GrMethodOverrideCompletionProvider());
    }

    private static void addSuperMethods(GrTypeDefinition psiClass, CompletionResultSet completionResultSet, boolean toImplement) {
        Collection<CandidateInfo> candidates = GroovyOverrideImplementExploreUtil.getMethodsToOverrideImplement(psiClass, toImplement);
        for (CandidateInfo candidateInfo : candidates) {
            PsiMethod method = (PsiMethod)candidateInfo.getElement();
            if (method.isConstructor()) continue;
            RowIcon icon = new RowIcon(2);
            icon.setIcon(method.getIcon(0), 0);
            icon.setIcon(toImplement ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod, 1);
            PsiSubstitutor substitutor = candidateInfo.getSubstitutor();
            String parameters = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)substitutor, (int)256, (int)1);
            String visibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
            String modifiers = visibility == "packageLocal" ? "" : visibility + " ";
            PsiType type = substitutor.substitute(method.getReturnType());
            String parentClassName = psiClass == null ? "" : psiClass.getName();
            String signature = modifiers + (type == null ? "" : type.getPresentableText() + " ") + method.getName();
            LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)method, (String)signature).appendTailText(parameters, false).appendTailText("{...}", true).withTypeText(parentClassName).withIcon((Icon)icon).withInsertHandler((InsertHandler)new GroovyMethodOverrideHandler(psiClass));
            completionResultSet.addElement((LookupElement)lookupElement);
        }
    }
}

