/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.VisibilityUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class InheritConstructorContributor
implements AstTransformationSupport {
    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/resolve/ast/InheritConstructorContributor", "applyTransformation"));
        }
        GrTypeDefinition psiClass = context.getCodeClass();
        if (psiClass.isAnonymous() || psiClass.isInterface() || psiClass.isEnum()) {
            return;
        }
        if (!InheritConstructorContributor.hasInheritConstructorsAnnotation(psiClass)) {
            return;
        }
        PsiClass superClass = context.getSuperClass();
        if (superClass == null) {
            return;
        }
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        for (PsiMethod constructor : superClass.getConstructors()) {
            if (constructor.hasModifierProperty("private")) continue;
            GrLightMethodBuilder inheritedConstructor = new GrLightMethodBuilder(context.getManager(), context.getClassName());
            inheritedConstructor.setConstructor(true);
            inheritedConstructor.setNavigationElement(psiClass);
            inheritedConstructor.addModifier(VisibilityUtil.getVisibilityModifier((PsiModifierList)constructor.getModifierList()));
            inheritedConstructor.setOriginInfo("created by @InheritConstructors");
            for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
                String name = StringUtil.notNullize((String)parameter.getName());
                PsiType type = superClassSubstitutor.substitute(parameter.getType());
                inheritedConstructor.addParameter(name, type, false);
            }
            context.addMethod(inheritedConstructor);
        }
    }

    public static boolean hasInheritConstructorsAnnotation(PsiClass psiClass) {
        PsiModifierList modifierList = psiClass.getModifierList();
        return modifierList != null && modifierList.findAnnotation("groovy.transform.InheritConstructors") != null;
    }
}

