/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

@State(name="mvcRunTargetHistory", storages={@Storage(value="other.xml")})
public class MvcRunTargetHistoryService
implements PersistentStateComponent<String[]> {
    private static final int MAX_HISTORY_LENGTH = 20;
    private final LinkedList<String> myHistory = new LinkedList();
    private String myVmOptions = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getState() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            if (this.myHistory.isEmpty() && StringUtil.isEmpty((String)this.myVmOptions)) {
                return ArrayUtilRt.EMPTY_STRING_ARRAY;
            }
            String[] res = new String[this.myHistory.size() + 1];
            res[0] = '#' + this.myVmOptions;
            int i = 1;
            for (String s : this.myHistory) {
                res[i++] = s;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String getVmOptions() {
        LinkedList<String> linkedList = this.myHistory;
        // MONITORENTER : linkedList
        String string = this.myVmOptions;
        // MONITOREXIT : linkedList
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/mvc/MvcRunTargetHistoryService", "getVmOptions"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(String[] state) {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            this.myHistory.clear();
            int start = 0;
            if (state.length > 0 && state[0].charAt(0) == '#') {
                this.myVmOptions = state[0].substring(1);
                start = 1;
            } else {
                this.myVmOptions = "";
            }
            for (int i = start; i < state.length; ++i) {
                this.myHistory.add(state[i].trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHistory() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            return ArrayUtil.toStringArray(this.myHistory);
        }
    }

    public static MvcRunTargetHistoryService getInstance() {
        return (MvcRunTargetHistoryService)ServiceManager.getService(MvcRunTargetHistoryService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(@NotNull String command, @NotNull String vmOptions) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/mvc/MvcRunTargetHistoryService", "addCommand"));
        }
        if (vmOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmOptions", "org/jetbrains/plugins/groovy/mvc/MvcRunTargetHistoryService", "addCommand"));
        }
        command = command.trim();
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            this.myVmOptions = vmOptions;
            this.myHistory.remove(command);
            this.myHistory.addFirst(command);
            if (this.myHistory.size() > 20) {
                this.myHistory.removeLast();
            }
        }
    }
}

