/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import icons.GithubIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubOpenInBrowserAction
extends DumbAwareAction {
    public static final String CANNOT_OPEN_IN_BROWSER = "Can't open in browser";

    public GithubOpenInBrowserAction() {
        super("Open on GitHub", "Open corresponding link in browser", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        CommitData data = this.getData(e);
        e.getPresentation().setEnabled(data != null && (data.revisionHash != null || data.virtualFile != null));
        e.getPresentation().setVisible(data != null);
    }

    public void actionPerformed(AnActionEvent e) {
        CommitData data = this.getData(e);
        assert (data != null);
        assert (data.revisionHash != null || data.virtualFile != null);
        if (data.revisionHash != null) {
            GithubOpenInBrowserAction.openCommitInBrowser(data.project, data.repository, data.revisionHash);
        } else {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            GithubOpenInBrowserAction.openFileInBrowser(data.project, data.repository, data.virtualFile, editor);
        }
    }

    @Nullable
    protected CommitData getData(AnActionEvent e) {
        CommitData data = GithubOpenInBrowserAction.getDataFromHistory(e);
        if (data == null) {
            data = GithubOpenInBrowserAction.getDataFromLog(e);
        }
        if (data == null) {
            data = GithubOpenInBrowserAction.getDataFromVirtualFile(e);
        }
        return data;
    }

    protected static void openCommitInBrowser(@NotNull Project project, @NotNull GitRepository repository, @NotNull String revisionHash) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubOpenInBrowserAction", "openCommitInBrowser"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/GithubOpenInBrowserAction", "openCommitInBrowser"));
        }
        if (revisionHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionHash", "org/jetbrains/plugins/github/GithubOpenInBrowserAction", "openCommitInBrowser"));
        }
        String url = GithubUtil.findGithubRemoteUrl(repository);
        if (url == null) {
            GithubUtil.LOG.info(String.format("Repository is not under GitHub. Root: %s, Remotes: %s", repository.getRoot(), GitUtil.getPrintableRemotes((Collection)repository.getRemotes())));
            return;
        }
        GithubFullPath userAndRepository = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url);
        if (userAndRepository == null) {
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "Can't extract info about repository: " + url);
            return;
        }
        String githubUrl = GithubUrlUtil.getGithubHost() + '/' + userAndRepository.getUser() + '/' + userAndRepository.getRepository() + "/commit/" + revisionHash;
        BrowserUtil.browse((String)githubUrl);
    }

    private static void openFileInBrowser(@NotNull Project project, @NotNull GitRepository repository, @NotNull VirtualFile virtualFile, @Nullable Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubOpenInBrowserAction", "openFileInBrowser"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/GithubOpenInBrowserAction", "openFileInBrowser"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/plugins/github/GithubOpenInBrowserAction", "openFileInBrowser"));
        }
        String githubRemoteUrl = GithubUtil.findGithubRemoteUrl(repository);
        if (githubRemoteUrl == null) {
            GithubUtil.LOG.info(String.format("Repository is not under GitHub. Root: %s, Remotes: %s", repository.getRoot(), GitUtil.getPrintableRemotes((Collection)repository.getRemotes())));
            return;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)repository.getRoot());
        if (relativePath == null) {
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "File is not under repository root", "Root: " + repository.getRoot().getPresentableUrl() + ", file: " + virtualFile.getPresentableUrl());
            return;
        }
        String hash = GithubOpenInBrowserAction.getCurrentFileRevisionHash(project, virtualFile);
        if (hash == null) {
            GithubNotifications.showError(project, CANNOT_OPEN_IN_BROWSER, "Can't get last revision.");
            return;
        }
        String githubUrl = GithubOpenInBrowserAction.makeUrlToOpen(editor, relativePath, hash, githubRemoteUrl);
        if (githubUrl != null) {
            BrowserUtil.browse((String)githubUrl);
        }
    }

    @Nullable
    private static CommitData getDataFromHistory(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        VcsFileRevision fileRevision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (project == null || filePath == null || fileRevision == null) {
            return null;
        }
        if (!(fileRevision instanceof GitFileRevision)) {
            return null;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(filePath);
        if (repository == null || !GithubUtil.isRepositoryOnGitHub(repository)) {
            return null;
        }
        return new CommitData(project, repository, fileRevision.getRevisionNumber().asString());
    }

    @Nullable
    private static CommitData getDataFromLog(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log == null) {
            return null;
        }
        List selectedCommits = log.getSelectedCommits();
        if (selectedCommits.size() != 1) {
            return null;
        }
        CommitId commit = (CommitId)ContainerUtil.getFirstItem((List)selectedCommits);
        if (commit == null) {
            return null;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(commit.getRoot());
        if (repository == null || !GithubUtil.isRepositoryOnGitHub(repository)) {
            return null;
        }
        return new CommitData(project, repository, commit.getHash().asString());
    }

    @Nullable
    private static CommitData getDataFromVirtualFile(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || virtualFile == null) {
            return null;
        }
        GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(virtualFile);
        if (gitRepository == null || !GithubUtil.isRepositoryOnGitHub(gitRepository)) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isUnversioned(virtualFile)) {
            return new CommitData(project, gitRepository);
        }
        Change change = changeListManager.getChange(virtualFile);
        if (change != null && change.getType() == Change.Type.NEW) {
            return new CommitData(project, gitRepository);
        }
        return new CommitData(project, gitRepository, virtualFile);
    }

    @Nullable
    private static String getCurrentFileRevisionHash(final @NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubOpenInBrowserAction", "getCurrentFileRevisionHash"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/github/GithubOpenInBrowserAction", "getCurrentFileRevisionHash"));
        }
        final Ref ref = new Ref();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, "Getting Last Revision", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubOpenInBrowserAction$1", "run"));
                }
                try {
                    ref.set((Object)((GitRevisionNumber)GitHistoryUtils.getCurrentRevision((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file), (String)"HEAD")));
                }
                catch (VcsException e) {
                    GithubUtil.LOG.warn((Throwable)e);
                }
            }

            public void onCancel() {
                throw new ProcessCanceledException();
            }
        });
        if (ref.isNull()) {
            return null;
        }
        return ((GitRevisionNumber)ref.get()).getRev();
    }

    @Nullable
    private static String makeUrlToOpen(@Nullable Editor editor, @NotNull String relativePath, @NotNull String branch, @NotNull String githubRemoteUrl) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/plugins/github/GithubOpenInBrowserAction", "makeUrlToOpen"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/plugins/github/GithubOpenInBrowserAction", "makeUrlToOpen"));
        }
        if (githubRemoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "githubRemoteUrl", "org/jetbrains/plugins/github/GithubOpenInBrowserAction", "makeUrlToOpen"));
        }
        StringBuilder builder = new StringBuilder();
        String githubRepoUrl = GithubUrlUtil.makeGithubRepoUrlFromRemoteUrl(githubRemoteUrl);
        if (githubRepoUrl == null) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)relativePath)) {
            builder.append(githubRepoUrl).append("/tree/").append(branch);
        } else {
            builder.append(githubRepoUrl).append("/blob/").append(branch).append('/').append(relativePath);
        }
        if (editor != null && editor.getDocument().getLineCount() >= 1) {
            SelectionModel selectionModel = editor.getSelectionModel();
            int begin = editor.getDocument().getLineNumber(selectionModel.getSelectionStart()) + 1;
            int selectionEnd = selectionModel.getSelectionEnd();
            int end = editor.getDocument().getLineNumber(selectionEnd) + 1;
            if (editor.getDocument().getLineStartOffset(end - 1) == selectionEnd) {
                --end;
            }
            builder.append("#L").append(begin);
            if (begin != end) {
                builder.append("-L").append(end);
            }
        }
        return builder.toString();
    }

    protected static class CommitData {
        @NotNull
        private final Project project;
        @NotNull
        private final GitRepository repository;
        @Nullable
        private final String revisionHash;
        @Nullable
        private final VirtualFile virtualFile;

        public CommitData(@NotNull Project project, @NotNull GitRepository repository) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubOpenInBrowserAction$CommitData", "<init>"));
            }
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/GithubOpenInBrowserAction$CommitData", "<init>"));
            }
            this.project = project;
            this.repository = repository;
            this.revisionHash = null;
            this.virtualFile = null;
        }

        public CommitData(@NotNull Project project, @NotNull GitRepository repository, @Nullable String revisionHash) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubOpenInBrowserAction$CommitData", "<init>"));
            }
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/GithubOpenInBrowserAction$CommitData", "<init>"));
            }
            this.project = project;
            this.repository = repository;
            this.revisionHash = revisionHash;
            this.virtualFile = null;
        }

        public CommitData(@NotNull Project project, @NotNull GitRepository repository, @Nullable VirtualFile virtualFile) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubOpenInBrowserAction$CommitData", "<init>"));
            }
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/GithubOpenInBrowserAction$CommitData", "<init>"));
            }
            this.project = project;
            this.repository = repository;
            this.revisionHash = null;
            this.virtualFile = virtualFile;
        }
    }
}

