/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.mandatory.Mandatory;
import org.jetbrains.io.mandatory.RestModel;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.data.GithubUser;

@RestModel
public class GithubRepo {
    private Long id;
    @Mandatory
    private String name;
    private String fullName;
    private String description;
    @SerializedName(value="private")
    @Mandatory
    private Boolean isPrivate;
    @SerializedName(value="fork")
    @Mandatory
    private Boolean isFork;
    private String url;
    @Mandatory
    private String htmlUrl;
    @Mandatory
    private String cloneUrl;
    private String gitUrl;
    private String sshUrl;
    private String svnUrl;
    private String mirrorUrl;
    private String homepage;
    private String language;
    private Integer size;
    private Integer forks;
    private Integer forksCount;
    private Integer watchers;
    private Integer watchersCount;
    private Integer openIssues;
    private Integer openIssuesCount;
    private String masterBranch;
    private String defaultBranch;
    private Boolean hasIssues;
    private Boolean hasWiki;
    private Boolean hasDownloads;
    @Mandatory
    private GithubUser owner;
    private GithubUser organization;
    private Date pushedAt;
    private Date createdAt;
    private Date updatedAt;

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubRepo", "getName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = StringUtil.notNullize((String)this.description);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubRepo", "getDescription"));
        }
        return string;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isFork() {
        return this.isFork;
    }

    @NotNull
    public String getHtmlUrl() {
        String string = this.htmlUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubRepo", "getHtmlUrl"));
        }
        return string;
    }

    @NotNull
    public String getCloneUrl() {
        String string = this.cloneUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubRepo", "getCloneUrl"));
        }
        return string;
    }

    @Nullable
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @NotNull
    public GithubUser getOwner() {
        GithubUser githubUser = this.owner;
        if (githubUser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubRepo", "getOwner"));
        }
        return githubUser;
    }

    @NotNull
    public String getUserName() {
        String string = this.getOwner().getLogin();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubRepo", "getUserName"));
        }
        return string;
    }

    @NotNull
    public String getFullName() {
        String string = this.getUserName() + "/" + this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubRepo", "getFullName"));
        }
        return string;
    }

    @NotNull
    public GithubFullPath getFullPath() {
        GithubFullPath githubFullPath = new GithubFullPath(this.getUserName(), this.getName());
        if (githubFullPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/data/GithubRepo", "getFullPath"));
        }
        return githubFullPath;
    }
}

