/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.util.AuthLevel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCredentialsPanel
extends JPanel {
    private static final Logger LOG = GithubUtil.LOG;
    private JTextField myHostTextField;
    private JTextField myLoginTextField;
    private JPasswordField myPasswordField;
    private JPasswordField myTokenField;
    private ComboBox<Layout> myAuthTypeComboBox;
    private JButton myCreateTokenButton;
    private JButton myTestButton;
    private JBLabel myAuthTypeLabel;
    private JTextPane mySignupTextField;
    private JPanel myPane;
    private JPanel myCardPanel;

    public GithubCredentialsPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "<init>"));
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.add((Component)this.myPane, "Center");
        this.mySignupTextField.setText("<html>Do not have an account at github.com? <a href=\"https://github.com\">Sign up</a></html>");
        this.mySignupTextField.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.mySignupTextField.setCursor(new Cursor(12));
        this.mySignupTextField.setMargin((Insets)JBUI.insetsTop((int)5));
        this.mySignupTextField.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
        this.myAuthTypeLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        this.myAuthTypeComboBox.addItem((Object)Layout.TOKEN);
        this.myAuthTypeComboBox.addItem((Object)Layout.PASSWORD);
        this.myTestButton.addActionListener(e -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "lambda$new$0"));
            }
            this.testAuthData(project);
        });
        this.myCreateTokenButton.addActionListener(e -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "lambda$new$1"));
            }
            this.generateToken(project);
        });
        this.myAuthTypeComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Layout item = (Layout)((Object)((Object)e.getItem()));
                CardLayout cardLayout = (CardLayout)this.myCardPanel.getLayout();
                cardLayout.show(this.myCardPanel, item.getCard());
            }
        });
    }

    @NotNull
    public String getHost() {
        String string = this.myHostTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "getHost"));
        }
        return string;
    }

    @NotNull
    public String getLogin() {
        String string = this.myLoginTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "getLogin"));
        }
        return string;
    }

    @NotNull
    private String getPassword() {
        String string = String.valueOf(this.myPasswordField.getPassword());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "getPassword"));
        }
        return string;
    }

    @NotNull
    private String getToken() {
        String string = String.valueOf(this.myTokenField.getPassword());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "getToken"));
        }
        return string;
    }

    @NotNull
    public GithubAuthData.AuthType getAuthType() {
        Layout selected = (Layout)((Object)this.myAuthTypeComboBox.getSelectedItem());
        if (selected == Layout.PASSWORD) {
            GithubAuthData.AuthType authType = GithubAuthData.AuthType.BASIC;
            if (authType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "getAuthType"));
            }
            return authType;
        }
        if (selected == Layout.TOKEN) {
            GithubAuthData.AuthType authType = GithubAuthData.AuthType.TOKEN;
            if (authType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "getAuthType"));
            }
            return authType;
        }
        LOG.error("GithubSettingsPanel: illegal selection - " + (Object)((Object)selected));
        GithubAuthData.AuthType authType = GithubAuthData.AuthType.TOKEN;
        if (authType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "getAuthType"));
        }
        return authType;
    }

    @NotNull
    public GithubAuthData getAuthData() {
        GithubAuthData.AuthType type = this.getAuthType();
        switch (type) {
            case BASIC: {
                GithubAuthData githubAuthData = GithubAuthData.createBasicAuth(this.getHost(), this.getLogin(), this.getPassword());
                if (githubAuthData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "getAuthData"));
                }
                return githubAuthData;
            }
            case TOKEN: {
                GithubAuthData githubAuthData = GithubAuthData.createTokenAuth(this.getHost(), StringUtil.trim((String)this.getToken()));
                if (githubAuthData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "getAuthData"));
                }
                return githubAuthData;
            }
        }
        throw new IllegalStateException();
    }

    public void setHost(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "setHost"));
        }
        this.myHostTextField.setText(host);
    }

    public void setLogin(@Nullable String login) {
        this.myLoginTextField.setText(login);
    }

    public void setPassword(@NotNull String password) {
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "setPassword"));
        }
        this.myPasswordField.setText(password);
    }

    public void setToken(@NotNull String token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "setToken"));
        }
        this.myTokenField.setText(token);
    }

    public void setAuthType(@NotNull GithubAuthData.AuthType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "setAuthType"));
        }
        if (type == GithubAuthData.AuthType.BASIC) {
            this.myAuthTypeComboBox.setSelectedItem((Object)Layout.PASSWORD);
        } else {
            this.myAuthTypeComboBox.setSelectedItem((Object)Layout.TOKEN);
        }
    }

    public void setAuthData(@NotNull GithubAuthData authData) {
        if (authData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authData", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "setAuthData"));
        }
        GithubAuthData.AuthType type = authData.getAuthType();
        this.setAuthType(type);
        this.setHost(authData.getHost());
        if (type == GithubAuthData.AuthType.BASIC) {
            GithubAuthData.BasicAuth basicAuth = authData.getBasicAuth();
            assert (basicAuth != null);
            this.setLogin(basicAuth.getLogin());
            this.setPassword(basicAuth.getPassword());
        }
        if (type == GithubAuthData.AuthType.TOKEN) {
            GithubAuthData.TokenAuth tokenAuth = authData.getTokenAuth();
            assert (tokenAuth != null);
            this.setToken(tokenAuth.getToken());
        }
    }

    public void lockAuthType(@NotNull GithubAuthData.AuthType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "lockAuthType"));
        }
        this.setAuthType(type);
        this.myAuthTypeComboBox.setEnabled(false);
    }

    public void lockHost(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "lockHost"));
        }
        this.setHost(host);
        this.myHostTextField.setEnabled(false);
    }

    public void setTestButtonVisible(boolean visible) {
        this.myTestButton.setVisible(visible);
    }

    private void testAuthData(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "testAuthData"));
        }
        try {
            GithubAuthData auth = this.getAuthData();
            GithubUser user = (GithubUser)GithubUtil.computeValueInModalIO(project, "Access to GitHub", indicator -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "lambda$testAuthData$3"));
                }
                return GithubUtil.checkAuthData(project, new GithubAuthDataHolder(auth), indicator);
            });
            if (GithubAuthData.AuthType.TOKEN.equals((Object)auth.getAuthType())) {
                GithubNotifications.showInfoDialog(this.myPane, "Success", "Connection successful for user " + user.getLogin());
            } else {
                GithubNotifications.showInfoDialog(this.myPane, "Success", "Connection successful");
            }
        }
        catch (GithubAuthenticationException ex) {
            GithubNotifications.showErrorDialog(this.myPane, "Login Failure", "Can't login using given credentials: ", ex);
        }
        catch (IOException ex) {
            GithubNotifications.showErrorDialog(this.myPane, "Login Failure", "Can't login: ", ex);
        }
    }

    private void generateToken(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "generateToken"));
        }
        try {
            String newToken = (String)GithubUtil.computeValueInModalIO(project, "Access to GitHub", indicator -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel", "lambda$generateToken$5"));
                }
                return (String)GithubUtil.runTask(project, GithubAuthDataHolder.createFromSettings(), indicator, AuthLevel.basicOnetime(this.getHost()), connection -> GithubApiUtil.getMasterToken(connection, "IntelliJ plugin"));
            });
            this.myTokenField.setText(newToken);
        }
        catch (IOException ex) {
            GithubNotifications.showErrorDialog(this.myPane, "Can't Create API Token", (Exception)ex);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextPane jTextPane;
        JButton jButton2;
        JPasswordField jPasswordField;
        JPasswordField jPasswordField2;
        JTextField jTextField;
        JPanel jPanel;
        ComboBox comboBox;
        JBLabel jBLabel;
        JTextField jTextField2;
        JPanel jPanel2;
        this.myPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("html.disable", Boolean.FALSE);
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Host:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAuthTypeLabel = jBLabel = new JBLabel();
        jBLabel.setText("Auth Type:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAuthTypeComboBox = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(0, 3, 1, 2, 0, 1, 0, 0, null, new Dimension(120, -1), null));
        this.myCardPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, "Password");
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Login:");
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLoginTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Password:");
        jPanel3.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel3.add((Component)jPasswordField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, "Token");
        ((CardLayout)jPanel.getLayout()).show(jPanel, "Token");
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Token:");
        jPanel4.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTokenField = jPasswordField = new JPasswordField();
        jPanel4.add((Component)jPasswordField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCreateTokenButton = jButton2 = new JButton();
        jButton2.setText("Create API Token");
        jPanel4.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.mySignupTextField = jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        ((Component)jTextPane).setEnabled(true);
        jTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel2.add((Component)jTextPane, new GridConstraints(2, 0, 1, 4, 0, 1, 2, 0, null, new Dimension(150, 10), null));
        this.myTestButton = jButton = new JButton();
        jButton.setText("Test");
        jPanel2.add((Component)jButton, new GridConstraints(2, 4, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel2.setAnchor((JComponent)jBLabel4);
        jBLabel2.setLabelFor(jTextField2);
        jBLabel.setLabelFor((Component)comboBox);
        jBLabel3.setAnchor((JComponent)jBLabel4);
        jBLabel3.setLabelFor(jTextField);
        jBLabel4.setLabelFor(jPasswordField2);
        jBLabel5.setAnchor((JComponent)jBLabel4);
        jBLabel5.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPane;
    }

    private static enum Layout {
        PASSWORD("Password"),
        TOKEN("Token");

        @NotNull
        private final String myCard;

        private Layout(String card) {
            if (card == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "card", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel$Layout", "<init>"));
            }
            this.myCard = card;
        }

        @NotNull
        public String getCard() {
            String string = this.myCard;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubCredentialsPanel$Layout", "getCard"));
            }
            return string;
        }

        public String toString() {
            return this.myCard;
        }
    }
}

