/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogStandardColors;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SimpleRefGroup;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.impl.VcsLogUtil;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class HgRefManager
implements VcsLogRefManager {
    private static final Color CLOSED_BRANCH_COLOR = new JBColor(new Color(8532281), new Color(0xFF5F6F));
    private static final Color LOCAL_TAG_COLOR = new JBColor(new Color(37008), new Color(62451));
    private static final Color MQ_TAG_COLOR = new JBColor(new Color(12176), new Color(22015));
    public static final VcsRefType TIP = new SimpleRefType("TIP", true, VcsLogStandardColors.Refs.TIP);
    public static final VcsRefType HEAD = new SimpleRefType("HEAD", true, VcsLogStandardColors.Refs.LEAF);
    public static final VcsRefType BRANCH = new SimpleRefType("BRANCH", true, VcsLogStandardColors.Refs.BRANCH);
    public static final VcsRefType CLOSED_BRANCH = new SimpleRefType("CLOSED_BRANCH", false, CLOSED_BRANCH_COLOR);
    public static final VcsRefType BOOKMARK = new SimpleRefType("BOOKMARK", true, VcsLogStandardColors.Refs.BRANCH_REF);
    public static final VcsRefType TAG = new SimpleRefType("TAG", false, VcsLogStandardColors.Refs.TAG);
    public static final VcsRefType LOCAL_TAG = new SimpleRefType("LOCAL_TAG", false, LOCAL_TAG_COLOR);
    public static final VcsRefType MQ_APPLIED_TAG = new SimpleRefType("MQ_TAG", false, MQ_TAG_COLOR);
    private static final List<VcsRefType> REF_TYPE_PRIORITIES = Arrays.asList(TIP, HEAD, BRANCH, BOOKMARK, TAG);
    private static final List<VcsRefType> REF_TYPE_INDEX = Arrays.asList(TIP, HEAD, BRANCH, CLOSED_BRANCH, BOOKMARK, TAG, LOCAL_TAG, MQ_APPLIED_TAG);
    public static final Comparator<VcsRefType> REF_TYPE_COMPARATOR = (type1, type2) -> {
        int p1 = REF_TYPE_PRIORITIES.indexOf(type1);
        int p2 = REF_TYPE_PRIORITIES.indexOf(type2);
        return p1 - p2;
    };
    public static final String DEFAULT = "default";
    private final Comparator<VcsRef> REF_COMPARATOR = (ref1, ref2) -> {
        VcsRefType type2;
        VcsRefType type1 = ref1.getType();
        int typeComparison = REF_TYPE_COMPARATOR.compare(type1, type2 = ref2.getType());
        if (typeComparison != 0) {
            return typeComparison;
        }
        int nameComparison = ref1.getName().compareTo(ref2.getName());
        if (nameComparison != 0) {
            if (type1 == BRANCH) {
                if (ref1.getName().equals(DEFAULT)) {
                    return -1;
                }
                if (ref2.getName().equals(DEFAULT)) {
                    return 1;
                }
            }
            return nameComparison;
        }
        return VcsLogUtil.compareRoots((VirtualFile)ref1.getRoot(), (VirtualFile)ref2.getRoot());
    };

    @NotNull
    public Comparator<VcsRef> getLabelsOrderComparator() {
        Comparator<VcsRef> comparator = this.REF_COMPARATOR;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgRefManager", "getLabelsOrderComparator"));
        }
        return comparator;
    }

    @NotNull
    public List<RefGroup> groupForBranchFilter(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "org/zmlx/hg4idea/log/HgRefManager", "groupForBranchFilter"));
        }
        List list = ContainerUtil.map(this.sort(refs), ref -> new SingletonRefGroup(ref));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgRefManager", "groupForBranchFilter"));
        }
        return list;
    }

    @NotNull
    public List<RefGroup> groupForTable(@NotNull Collection<VcsRef> references, boolean compact, boolean showTagNames) {
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "org/zmlx/hg4idea/log/HgRefManager", "groupForTable"));
        }
        List<VcsRef> sortedReferences = this.sort(references);
        ArrayList headAndTip = ContainerUtil.newArrayList();
        MultiMap groupedRefs = MultiMap.createLinked();
        for (VcsRef ref : sortedReferences) {
            if (ref.getType().equals(HEAD) || ref.getType().equals(TIP)) {
                headAndTip.add(ref);
                continue;
            }
            groupedRefs.putValue((Object)ref.getType(), (Object)ref);
        }
        ArrayList result = ContainerUtil.newArrayList();
        SimpleRefGroup.buildGroups((MultiMap)groupedRefs, (boolean)compact, (boolean)showTagNames, (List)result);
        RefGroup firstGroup = (RefGroup)ContainerUtil.getFirstItem((List)result);
        if (firstGroup != null) {
            firstGroup.getRefs().addAll(0, headAndTip);
        } else {
            result.add(new SimpleRefGroup("", (List)headAndTip));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgRefManager", "groupForTable"));
        }
        return arrayList;
    }

    public void serialize(@NotNull DataOutput out, @NotNull VcsRefType type) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/zmlx/hg4idea/log/HgRefManager", "serialize"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/zmlx/hg4idea/log/HgRefManager", "serialize"));
        }
        out.writeInt(REF_TYPE_INDEX.indexOf(type));
    }

    @NotNull
    public VcsRefType deserialize(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/zmlx/hg4idea/log/HgRefManager", "deserialize"));
        }
        int id = in.readInt();
        if (id < 0 || id > REF_TYPE_INDEX.size() - 1) {
            throw new IOException("Reference type by id " + id + " does not exist");
        }
        VcsRefType vcsRefType = REF_TYPE_INDEX.get(id);
        if (vcsRefType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgRefManager", "deserialize"));
        }
        return vcsRefType;
    }

    @NotNull
    public Comparator<VcsRef> getBranchLayoutComparator() {
        Comparator<VcsRef> comparator = this.REF_COMPARATOR;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgRefManager", "getBranchLayoutComparator"));
        }
        return comparator;
    }

    @NotNull
    private List<VcsRef> sort(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "org/zmlx/hg4idea/log/HgRefManager", "sort"));
        }
        List list = ContainerUtil.sorted(refs, this.getLabelsOrderComparator());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgRefManager", "sort"));
        }
        return list;
    }

    private static class SimpleRefType
    implements VcsRefType {
        @NotNull
        private final String myName;
        private final boolean myIsBranch;
        @NotNull
        private final Color myColor;

        public SimpleRefType(@NotNull String name, boolean isBranch, @NotNull Color color) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/zmlx/hg4idea/log/HgRefManager$SimpleRefType", "<init>"));
            }
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "org/zmlx/hg4idea/log/HgRefManager$SimpleRefType", "<init>"));
            }
            this.myName = name;
            this.myIsBranch = isBranch;
            this.myColor = color;
        }

        public boolean isBranch() {
            return this.myIsBranch;
        }

        @NotNull
        public Color getBackgroundColor() {
            Color color = this.myColor;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/log/HgRefManager$SimpleRefType", "getBackgroundColor"));
            }
            return color;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleRefType type = (SimpleRefType)o;
            return this.myIsBranch == type.myIsBranch && Objects.equals(this.myName, type.myName);
        }

        public int hashCode() {
            return Objects.hash(this.myName, this.myIsBranch);
        }
    }
}

