/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.update;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgResolveCommand;
import org.zmlx.hg4idea.command.HgResolveStatusEnum;

public final class HgConflictResolver {
    @NotNull
    private final Project myProject;
    private final UpdatedFiles updatedFiles;

    public HgConflictResolver(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/update/HgConflictResolver", "<init>"));
        }
        this(project, null);
    }

    public HgConflictResolver(@NotNull Project project, UpdatedFiles updatedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/update/HgConflictResolver", "<init>"));
        }
        this.myProject = project;
        this.updatedFiles = updatedFiles;
    }

    public void resolve(VirtualFile repo) {
        Map<HgFile, HgResolveStatusEnum> resolves = new HgResolveCommand(this.myProject).getListSynchronously(repo);
        ArrayList<File> conflictFiles = new ArrayList<File>();
        for (HgFile hgFile : resolves.keySet()) {
            File file = hgFile.getFile();
            if (resolves.get(hgFile) == HgResolveStatusEnum.UNRESOLVED) {
                conflictFiles.add(file);
                this.updateUpdatedFiles(file, true);
                continue;
            }
            this.updateUpdatedFiles(file, false);
        }
        if (conflictFiles.isEmpty()) {
            return;
        }
        HgVcs vcs = HgVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        List conflicts = DvcsUtil.sortVirtualFilesByPresentation((Collection)DvcsUtil.findVirtualFilesWithRefresh(conflictFiles));
        ApplicationManager.getApplication().invokeAndWait(() -> AbstractVcsHelper.getInstance((Project)this.myProject).showMergeDialog(conflicts, vcs.getMergeProvider()));
    }

    private void updateUpdatedFiles(@NotNull File file, boolean unresolved) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/zmlx/hg4idea/provider/update/HgConflictResolver", "updateUpdatedFiles"));
        }
        if (this.updatedFiles != null) {
            this.updatedFiles.getGroupById("UPDATED").remove(file.getAbsolutePath());
            this.updatedFiles.getGroupById(unresolved ? "MERGED_WITH_CONFLICTS" : "MERGED").add(file.getPath(), "hg4idea", null);
        }
    }

    public static boolean hasConflicts(Project project, VirtualFile repo) {
        Map<HgFile, HgResolveStatusEnum> resolves = new HgResolveCommand(project).getListSynchronously(repo);
        return ContainerUtil.exists(resolves.values(), resolveStatus -> resolveStatus == HgResolveStatusEnum.UNRESOLVED);
    }
}

