/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgRepositorySelectorComponent;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPullDialog
extends DialogWrapper {
    private final Project project;
    private HgRepositorySelectorComponent hgRepositorySelector;
    private JPanel mainPanel;
    private EditorComboBox myRepositoryURL;
    private String myCurrentRepositoryUrl;

    public HgPullDialog(@NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/ui/HgPullDialog", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/ui/HgPullDialog", "<init>"));
        }
        super(project, false);
        this.project = project;
        this.$$$setupUI$$$();
        this.hgRepositorySelector.setTitle("Select repository to pull changesets for");
        this.hgRepositorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HgPullDialog.this.onChangeRepository();
            }
        });
        this.setTitle("Pull");
        this.setOKButtonText("Pull");
        this.init();
        this.setRoots(repositories, selectedRepo);
    }

    public void createUIComponents() {
        this.myRepositoryURL = new EditorComboBox("");
        this.myRepositoryURL.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                HgPullDialog.this.onChangePullSource();
            }
        });
    }

    private void addPathsFromHgrc(@NotNull VirtualFile repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/ui/HgPullDialog", "addPathsFromHgrc"));
        }
        Collection<String> paths = HgUtil.getRepositoryPaths(this.project, repo);
        for (String path : paths) {
            this.myRepositoryURL.prependItem(path);
        }
    }

    @NotNull
    public HgRepository getRepository() {
        HgRepository hgRepository = this.hgRepositorySelector.getRepository();
        if (hgRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/ui/HgPullDialog", "getRepository"));
        }
        return hgRepository;
    }

    public String getSource() {
        return this.myCurrentRepositoryUrl;
    }

    private void setRoots(@NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/ui/HgPullDialog", "setRoots"));
        }
        this.hgRepositorySelector.setRoots(repositories);
        this.hgRepositorySelector.setSelectedRoot(selectedRepo);
        this.onChangeRepository();
    }

    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    protected String getHelpId() {
        return "reference.mercurial.pull.dialog";
    }

    private void onChangeRepository() {
        VirtualFile repo = this.hgRepositorySelector.getRepository().getRoot();
        String defaultPath = HgUtil.getRepositoryDefaultPath(this.project, repo);
        if (!StringUtil.isEmptyOrSpaces((String)defaultPath)) {
            this.addPathsFromHgrc(repo);
            this.myRepositoryURL.setText(HgUtil.removePasswordIfNeeded(defaultPath));
            this.myCurrentRepositoryUrl = defaultPath;
            this.onChangePullSource();
        }
    }

    private void onChangePullSource() {
        this.myCurrentRepositoryUrl = this.myRepositoryURL.getText();
        this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)this.myRepositoryURL.getText()));
    }

    protected String getDimensionServiceKey() {
        return HgPullDialog.class.getName();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HgRepositorySelectorComponent hgRepositorySelectorComponent;
        JPanel jPanel;
        this.createUIComponents();
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.hgRepositorySelector = hgRepositorySelectorComponent = new HgRepositorySelectorComponent();
        JComponent jComponent = hgRepositorySelectorComponent.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Pull From:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        EditorComboBox editorComboBox = this.myRepositoryURL;
        editorComboBox.setEditable(true);
        jPanel2.add((Component)editorComboBox, new GridConstraints(1, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

