/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.ArtifactBuildTask;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.InternalProjectTaskRunner;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.build.GradleArtifactBuildTasksProvider;
import org.jetbrains.plugins.gradle.execution.build.GradleExecutionEnvironmentProvider;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectTaskRunner
extends ProjectTaskRunner {
    public void run(final @NotNull Project project, @NotNull ProjectTaskContext context, final @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "run"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "run"));
        }
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "run"));
        }
        String executionName = "Gradle build";
        MultiMap buildTasksMap = MultiMap.createLinkedSet();
        MultiMap cleanTasksMap = MultiMap.createLinkedSet();
        Map taskMap = InternalProjectTaskRunner.groupBy(tasks);
        final List<Module> modules = GradleProjectTaskRunner.addModulesBuildTasks((Collection)taskMap.get(ModuleBuildTask.class), (MultiMap<String, String>)cleanTasksMap, (MultiMap<String, String>)buildTasksMap);
        final List<Module> modulesOfFiles = GradleProjectTaskRunner.addModulesBuildTasks((Collection)taskMap.get(ModuleFilesBuildTask.class), (MultiMap<String, String>)cleanTasksMap, (MultiMap<String, String>)buildTasksMap);
        GradleProjectTaskRunner.addArtifactsBuildTasks((Collection)taskMap.get(ArtifactBuildTask.class), (MultiMap<String, String>)cleanTasksMap, (MultiMap<String, String>)buildTasksMap);
        final Set rootPaths = buildTasksMap.keySet();
        final AtomicInteger successCounter = new AtomicInteger();
        final AtomicInteger errorCounter = new AtomicInteger();
        TaskCallback taskCallback = callback == null ? null : new TaskCallback(){

            public void onSuccess() {
                this.handle(true);
            }

            public void onFailure() {
                this.handle(false);
            }

            private void handle(boolean success) {
                int errors;
                int successes = success ? successCounter.incrementAndGet() : successCounter.get();
                int n = errors = success ? errorCounter.get() : errorCounter.incrementAndGet();
                if (successes + errors == rootPaths.size()) {
                    List affectedModules;
                    HashSet affectedRoots;
                    if (!project.isDisposed() && !(affectedRoots = ContainerUtil.newHashSet((Object[])CompilerPathsEx.getOutputPaths((Module[])((Module[])ContainerUtil.toArray((List)(affectedModules = ContainerUtil.concat((List)modules, (List)modulesOfFiles)), (Object[])new Module[affectedModules.size()]))))).isEmpty()) {
                        CompilerUtil.refreshOutputRoots((Collection)affectedRoots);
                    }
                    callback.finished(new ProjectTaskResult(false, errors, 0));
                }
            }
        };
        String gradleVmOptions = GradleSettings.getInstance(project).getGradleVmOptions();
        for (String rootProjectPath : rootPaths) {
            Collection buildTasks = buildTasksMap.get((Object)rootProjectPath);
            if (buildTasks.isEmpty()) continue;
            Collection cleanTasks = cleanTasksMap.get((Object)rootProjectPath);
            ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
            settings.setExecutionName(executionName);
            settings.setExternalProjectPath(rootProjectPath);
            settings.setTaskNames(ContainerUtil.collect(ContainerUtil.concat((Iterable[])new Iterable[]{cleanTasks, buildTasks}).iterator()));
            settings.setVmOptions(gradleVmOptions);
            settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
            ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)DefaultRunExecutor.EXECUTOR_ID, (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)taskCallback, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC, (boolean)false);
        }
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        if (projectTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectTask", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "canRun"));
        }
        if (!GradleSystemRunningSettings.getInstance().isUseGradleAwareMake()) {
            return false;
        }
        if (projectTask instanceof ModuleBuildTask) {
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)((ModuleBuildTask)projectTask).getModule());
        }
        if (projectTask instanceof ArtifactBuildTask) {
            ArtifactBuildTask artifactBuildTask = (ArtifactBuildTask)projectTask;
            for (GradleArtifactBuildTasksProvider buildTasksProvider : (GradleArtifactBuildTasksProvider[])GradleArtifactBuildTasksProvider.EP_NAME.getExtensions()) {
                if (!buildTasksProvider.isApplicable(artifactBuildTask)) continue;
                return true;
            }
        }
        if (projectTask instanceof ExecuteRunConfigurationTask) {
            RunConfigurationModule module;
            RunProfile runProfile = ((ExecuteRunConfigurationTask)projectTask).getRunProfile();
            if (runProfile instanceof ModuleBasedConfiguration && !ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)(module = ((ModuleBasedConfiguration)runProfile).getConfigurationModule()).getModule())) {
                return false;
            }
            for (GradleExecutionEnvironmentProvider environmentProvider : (GradleExecutionEnvironmentProvider[])GradleExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
                if (!environmentProvider.isApplicable((ExecuteRunConfigurationTask)projectTask)) continue;
                return true;
            }
        }
        return false;
    }

    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ExecuteRunConfigurationTask task, @Nullable Executor executor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "createExecutionEnvironment"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "createExecutionEnvironment"));
        }
        for (GradleExecutionEnvironmentProvider environmentProvider : (GradleExecutionEnvironmentProvider[])GradleExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
            if (!environmentProvider.isApplicable(task)) continue;
            return environmentProvider.createExecutionEnvironment(project, task, executor);
        }
        return null;
    }

    private static List<Module> addModulesBuildTasks(@Nullable Collection<? extends ProjectTask> projectTasks, @NotNull MultiMap<String, String> cleanTasksMap, @NotNull MultiMap<String, String> buildTasksMap) {
        if (cleanTasksMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cleanTasksMap", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "addModulesBuildTasks"));
        }
        if (buildTasksMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTasksMap", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "addModulesBuildTasks"));
        }
        if (ContainerUtil.isEmpty(projectTasks)) {
            return Collections.emptyList();
        }
        SmartList affectedModules = new SmartList();
        CachedModuleDataFinder moduleDataFinder = new CachedModuleDataFinder();
        for (ProjectTask projectTask : projectTasks) {
            DataNode<ModuleData> moduleDataNode;
            String externalProjectPath;
            String projectId;
            if (!(projectTask instanceof ModuleBuildTask)) continue;
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            Module module = moduleBuildTask.getModule();
            affectedModules.add(module);
            String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
            if (rootProjectPath == null || (projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module)) == null || (externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module)) == null || StringUtil.endsWith((CharSequence)externalProjectPath, (CharSequence)"buildSrc") || (moduleDataNode = moduleDataFinder.findModuleData(module)) == null) continue;
            List gradleTasks = ContainerUtil.mapNotNull((Collection)ExternalSystemApiUtil.findAll(moduleDataNode, (Key)ProjectKeys.TASK), node -> ((TaskData)node.getData()).isInherited() ? null : ((TaskData)node.getData()).getName());
            Collection cleanRootTasks = cleanTasksMap.getModifiable((Object)rootProjectPath);
            Collection buildRootTasks = buildTasksMap.getModifiable((Object)rootProjectPath);
            String moduleType = ExternalSystemApiUtil.getExternalModuleType((Module)module);
            String gradlePath = GradleProjectResolverUtil.getGradlePath(module);
            if (gradlePath == null) continue;
            if (gradlePath.equals(":")) {
                gradlePath = "";
            }
            if ("sourceSet".equals(moduleType)) {
                String gradleTask;
                String sourceSetName = GradleProjectResolverUtil.getSourceSetName(module);
                String string = gradleTask = StringUtil.isEmpty((String)sourceSetName) || "main".equals(sourceSetName) ? "classes" : sourceSetName + "Classes";
                if (gradleTasks.contains(gradleTask)) {
                    if (!moduleBuildTask.isIncrementalBuild()) {
                        cleanRootTasks.add(gradlePath + ":clean" + StringUtil.capitalize((String)gradleTask));
                    }
                    buildRootTasks.add(gradlePath + ":" + gradleTask);
                    continue;
                }
                if (!"main".equals(sourceSetName) && !"test".equals(sourceSetName)) continue;
                if (!moduleBuildTask.isIncrementalBuild()) {
                    cleanRootTasks.add(gradlePath + ":clean");
                }
                buildRootTasks.add(gradlePath + ":build");
                continue;
            }
            if (!moduleBuildTask.isIncrementalBuild()) {
                if (gradleTasks.contains("classes")) {
                    cleanRootTasks.add(StringUtil.equals((CharSequence)rootProjectPath, (CharSequence)externalProjectPath) ? ":cleanClasses" : gradlePath + ":cleanClasses");
                    cleanRootTasks.add(StringUtil.equals((CharSequence)rootProjectPath, (CharSequence)externalProjectPath) ? ":cleanTestClasses" : gradlePath + ":cleanTestClasses");
                } else if (gradleTasks.contains("clean")) {
                    cleanRootTasks.add(StringUtil.equals((CharSequence)rootProjectPath, (CharSequence)externalProjectPath) ? "clean" : gradlePath + ":clean");
                } else {
                    cleanTasksMap.getModifiable((Object)externalProjectPath).add("clean");
                }
            }
            if (gradleTasks.contains("classes")) {
                buildRootTasks.add(StringUtil.equals((CharSequence)rootProjectPath, (CharSequence)externalProjectPath) ? ":classes" : gradlePath + ":classes");
                buildRootTasks.add(StringUtil.equals((CharSequence)rootProjectPath, (CharSequence)externalProjectPath) ? ":testClasses" : gradlePath + ":testClasses");
                continue;
            }
            if (gradleTasks.contains("build")) {
                buildRootTasks.add(StringUtil.equals((CharSequence)rootProjectPath, (CharSequence)externalProjectPath) ? "build" : gradlePath + ":build");
                continue;
            }
            buildTasksMap.getModifiable((Object)externalProjectPath).add("build");
        }
        return affectedModules;
    }

    private static void addArtifactsBuildTasks(@Nullable Collection<? extends ProjectTask> tasks, @NotNull MultiMap<String, String> cleanTasksMap, @NotNull MultiMap<String, String> buildTasksMap) {
        if (cleanTasksMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cleanTasksMap", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "addArtifactsBuildTasks"));
        }
        if (buildTasksMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTasksMap", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "addArtifactsBuildTasks"));
        }
        if (ContainerUtil.isEmpty(tasks)) {
            return;
        }
        for (ProjectTask projectTask : tasks) {
            if (!(projectTask instanceof ArtifactBuildTask)) continue;
            ArtifactBuildTask artifactBuildTask = (ArtifactBuildTask)projectTask;
            for (GradleArtifactBuildTasksProvider buildTasksProvider : (GradleArtifactBuildTasksProvider[])GradleArtifactBuildTasksProvider.EP_NAME.getExtensions()) {
                if (!buildTasksProvider.isApplicable(artifactBuildTask)) continue;
                buildTasksProvider.addArtifactsTargetsBuildTasks(artifactBuildTask, (Consumer<ExternalTaskPojo>)((Consumer)task -> {
                    if (cleanTasksMap == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cleanTasksMap", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "lambda$addArtifactsBuildTasks$1"));
                    }
                    cleanTasksMap.putValue((Object)task.getLinkedExternalProjectPath(), (Object)task.getName());
                }), (Consumer<ExternalTaskPojo>)((Consumer)task -> {
                    if (buildTasksMap == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTasksMap", "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner", "lambda$addArtifactsBuildTasks$2"));
                    }
                    buildTasksMap.putValue((Object)task.getLinkedExternalProjectPath(), (Object)task.getName());
                }));
            }
        }
    }
}

