/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.ToggleModelAction;
import com.intellij.execution.testframework.ToggleModelActionProvider;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import icons.GradleIcons;
import java.io.File;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class OpenGradleTestResultActionProvider
implements ToggleModelActionProvider {
    public static final BooleanProperty OPEN_GRADLE_REPORT = new BooleanProperty("openGradleReport", false);

    public ToggleModelAction createToggleModelAction(TestConsoleProperties properties) {
        return new MyToggleModelAction(properties);
    }

    private static class MyToggleModelAction
    extends ToggleModelAction {
        @Nullable
        private ProjectSystemId mySystemId;

        public MyToggleModelAction(TestConsoleProperties properties) {
            super(GradleBundle.message("gradle.test.runner.ui.tests.actions.open.gradle.report.text", new Object[0]), GradleBundle.message("gradle.test.runner.ui.tests.actions.open.gradle.report.desc", new Object[0]), GradleIcons.GradleNavigate, (AbstractProperty.AbstractPropertyContainer)properties, OPEN_GRADLE_REPORT);
        }

        public void setModel(TestFrameworkRunningModel model) {
            RunProfile runConfiguration = model.getProperties().getConfiguration();
            if (runConfiguration instanceof ExternalSystemRunConfiguration) {
                this.mySystemId = ((ExternalSystemRunConfiguration)runConfiguration).getSettings().getExternalSystemId();
            }
        }

        public void setSelected(AnActionEvent e, boolean state) {
            String reportFilePath = this.getReportFilePath();
            if (reportFilePath != null) {
                BrowserUtil.browse((String)reportFilePath);
            }
        }

        protected boolean isEnabled() {
            String reportFilePath = this.getReportFilePath();
            return reportFilePath != null;
        }

        protected boolean isVisible() {
            return GradleConstants.SYSTEM_ID.equals((Object)this.mySystemId);
        }

        @Nullable
        private String getReportFilePath() {
            GradleConsoleProperties gradleConsoleProperties;
            File testReport;
            AbstractProperty.AbstractPropertyContainer properties = this.getProperties();
            if (properties instanceof GradleConsoleProperties && (testReport = (gradleConsoleProperties = (GradleConsoleProperties)properties).getGradleTestReport()) != null && testReport.isFile()) {
                return testReport.getPath();
            }
            return null;
        }
    }
}

