/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.util.Pair;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

public abstract class AbstractProjectImportErrorHandler {
    public static final String OPEN_GRADLE_SETTINGS = "Please fix the project's Gradle settings.";
    public static final String SET_UP_HTTP_PROXY = "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
    public static final String UNEXPECTED_ERROR_FILE_BUG = "This is an unexpected error. Please file a bug containing the idea.log file.";
    public static final String FIX_GRADLE_VERSION = "Please point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
    public static final String EMPTY_LINE = "\n\n";

    @Nullable
    public abstract ExternalSystemException getUserFriendlyError(@NotNull Throwable var1, @NotNull String var2, @Nullable String var3);

    @NotNull
    public ExternalSystemException createUserFriendlyError(@NotNull String msg, @Nullable String location, String ... quickFixes) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "createUserFriendlyError"));
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "createUserFriendlyError"));
        }
        ExternalSystemException externalSystemException = GradleExecutionErrorHandler.createUserFriendlyError(msg, location, quickFixes);
        if (externalSystemException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "createUserFriendlyError"));
        }
        return externalSystemException;
    }

    @Nullable
    public String parseMissingMethod(@NotNull String rootCauseText) {
        if (rootCauseText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCauseText", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "parseMissingMethod"));
        }
        Matcher matcher = GradleExecutionErrorHandler.MISSING_METHOD_PATTERN.matcher(rootCauseText);
        return matcher.find() ? matcher.group(1) : null;
    }

    @NotNull
    public Pair<Throwable, String> getRootCauseAndLocation(@NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "getRootCauseAndLocation"));
        }
        Pair<Throwable, String> pair = GradleExecutionErrorHandler.getRootCauseAndLocation(error);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "getRootCauseAndLocation"));
        }
        return pair;
    }

    @Nullable
    public String getLocationFrom(@NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/plugins/gradle/service/project/AbstractProjectImportErrorHandler", "getLocationFrom"));
        }
        return GradleExecutionErrorHandler.getLocationFrom(error);
    }
}

