/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

@Order(value=-2147483646)
public class GradleSourceSetDataService
extends AbstractModuleDataService<GradleSourceSetData> {
    @NotNull
    public Key<GradleSourceSetData> getTargetDataKey() {
        Key<GradleSourceSetData> key = GradleSourceSetData.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "getTargetDataKey"));
        }
        return key;
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(@NotNull Collection<DataNode<GradleSourceSetData>> toImport, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "computeOrphanData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "computeOrphanData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "computeOrphanData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "computeOrphanData"));
        }
        Computable computable = () -> {
            if (modelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "lambda$computeOrphanData$0"));
            }
            if (projectData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "lambda$computeOrphanData$0"));
            }
            List orphanIdeModules = ContainerUtil.newSmartList();
            for (Module module : modelsProvider.getModules()) {
                if (module.isDisposed() || !ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module) || !"sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) continue;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath) || module.getUserData(AbstractModuleDataService.MODULE_DATA_KEY) != null) continue;
                orphanIdeModules.add(module);
            }
            return orphanIdeModules;
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/GradleSourceSetDataService", "computeOrphanData"));
        }
        return computable;
    }

    protected void setModuleOptions(Module module, DataNode<GradleSourceSetData> moduleDataNode) {
        super.setModuleOptions(module, moduleDataNode);
        ExternalSystemModulePropertyManager.getInstance((Module)module).setExternalModuleType("sourceSet");
    }
}

