/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.theoryinpractice.testng.configuration.browser.SuiteBrowser;
import com.theoryinpractice.testng.inspection.TestNGSearchScope;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UndeclaredTestInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(UndeclaredTestInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("TestNG" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection", "getGroupDisplayName"));
        }
        return "TestNG";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Undeclared test" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection", "getDisplayName"));
        }
        return "Undeclared test";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("UndeclaredTests" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection", "getShortName"));
        }
        return "UndeclaredTests";
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection", "checkClass"));
        }
        if (TestNGUtil.hasTest((PsiModifierListOwner)aClass) && PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true)) {
            Project project = aClass.getProject();
            String qName = aClass.getQualifiedName();
            if (qName == null) {
                return null;
            }
            String packageQName = StringUtil.getPackageName((String)qName);
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < qName.length(); ++i) {
                if (qName.charAt(i) != '.') continue;
                names.add(qName.substring(0, i));
            }
            names.add(qName);
            Collections.reverse(names);
            for (String name : names) {
                boolean isFullName = qName.equals(name);
                boolean[] found = new boolean[]{false};
                PsiSearchHelper.SERVICE.getInstance((Project)project).processUsagesInNonJavaFiles(name, (file, startOffset, endOffset) -> {
                    if (file.findReferenceAt(startOffset) != null) {
                        if (!isFullName) {
                            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), XmlTag.class);
                            if (tag == null || !tag.getName().equals("package")) {
                                return true;
                            }
                            XmlAttribute attribute = tag.getAttribute("name");
                            if (attribute == null) {
                                return true;
                            }
                            String value = attribute.getValue();
                            if (value == null) {
                                return true;
                            }
                            if (!value.endsWith(".*") && !value.equals(packageQName)) {
                                return true;
                            }
                        }
                        found[0] = true;
                        return false;
                    }
                    return true;
                }, (GlobalSearchScope)new TestNGSearchScope(project));
                if (!found[0]) continue;
                return null;
            }
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            LOG.assertTrue(nameIdentifier != null);
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)nameIdentifier, "Undeclared test '" + aClass.getName() + "'", isOnTheFly, new LocalQuickFix[]{new RegisterClassFix(aClass), new CreateTestngFix()}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
        }
        return null;
    }

    public static void patchTestngXml(XmlFile testngXML, PsiClass psiClass) {
        XmlTag rootTag = testngXML.getDocument().getRootTag();
        if (rootTag != null && rootTag.getName().equals("suite")) {
            try {
                XmlTag classesTag;
                XmlTag testTag = rootTag.findFirstSubTag("test");
                if (testTag == null) {
                    testTag = (XmlTag)rootTag.add((PsiElement)rootTag.createChildTag("test", rootTag.getNamespace(), null, false));
                    testTag.setAttribute("name", psiClass.getName());
                }
                if ((classesTag = testTag.findFirstSubTag("classes")) == null) {
                    classesTag = (XmlTag)testTag.add((PsiElement)testTag.createChildTag("classes", testTag.getNamespace(), null, false));
                }
                XmlTag classTag = (XmlTag)classesTag.add((PsiElement)classesTag.createChildTag("class", classesTag.getNamespace(), null, false));
                String qualifiedName = psiClass.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                classTag.setAttribute("name", qualifiedName);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static class CreateTestngFix
    implements LocalQuickFix {
        private CreateTestngFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Create suite" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$CreateTestngFix", "getFamilyName"));
            }
            return "Create suite";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$CreateTestngFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$CreateTestngFix", "applyFix"));
            }
            final PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (Project)project, null);
            if (file != null) {
                final PsiManager psiManager = PsiManager.getInstance((Project)project);
                final PsiDirectory directory = psiManager.findDirectory(file);
                LOG.assertTrue(directory != null);
                new WriteCommandAction(project, this.getName(), null){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$CreateTestngFix$1", "run"));
                        }
                        XmlFile testngXml = (XmlFile)PsiFileFactory.getInstance((Project)psiManager.getProject()).createFileFromText("testng.xml", "<!DOCTYPE suite SYSTEM \"http://testng.org/testng-1.0.dtd\">\n<suite></suite>");
                        try {
                            testngXml = (XmlFile)directory.add((PsiElement)testngXml);
                        }
                        catch (IncorrectOperationException e) {
                            return;
                        }
                        UndeclaredTestInspection.patchTestngXml(testngXml, psiClass);
                    }
                }.execute();
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }

    private static class RegisterClassFix
    implements LocalQuickFix {
        private final String myClassName;

        public RegisterClassFix(PsiClass aClass) {
            this.myClassName = aClass.getName();
        }

        @NotNull
        public String getName() {
            String string = "Register '" + this.myClassName + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$RegisterClassFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Register test" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$RegisterClassFix", "getFamilyName"));
            }
            return "Register test";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$RegisterClassFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$RegisterClassFix", "applyFix"));
            }
            final PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
            LOG.assertTrue(psiClass != null);
            String testngXmlPath = new SuiteBrowser(project).showDialog();
            if (testngXmlPath == null) {
                return;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(testngXmlPath);
            LOG.assertTrue(virtualFile != null);
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            LOG.assertTrue(psiFile instanceof XmlFile);
            final XmlFile testngXML = (XmlFile)psiFile;
            new WriteCommandAction(project, this.getName(), new PsiFile[]{testngXML}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$RegisterClassFix$1", "run"));
                    }
                    UndeclaredTestInspection.patchTestngXml(testngXML, psiClass);
                }
            }.execute();
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

