/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.IdeaSubversionConfigurationDirectory;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;

public class GeneralSettingsPanel
implements ConfigurableUi<SvnConfiguration> {
    @NotNull
    private final Project myProject;
    private JPanel myMainPanel;
    private JCheckBox myUseCustomConfigurationDirectory;
    private TextFieldWithBrowseButton myConfigurationDirectoryText;
    private JButton myClearAuthButton;
    private JCheckBox myLockOnDemand;
    private JBCheckBox myWithCommandLineClient;
    private JBCheckBox myRunUnderTerminal;
    private TextFieldWithBrowseButton myCommandLineClient;
    private JPanel myCommandLineClientOptions;

    public GeneralSettingsPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/GeneralSettingsPanel", "<init>"));
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myWithCommandLineClient.addItemListener(e -> this.enableCommandLineClientOptions());
        this.enableCommandLineClientOptions();
        this.myUseCustomConfigurationDirectory.addActionListener(e -> {
            boolean enabled = this.myUseCustomConfigurationDirectory.isSelected();
            this.myConfigurationDirectoryText.setEnabled(enabled);
            this.myConfigurationDirectoryText.setEditable(enabled);
            SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
            String path = configuration.getConfigurationDirectory();
            if (!enabled || path == null) {
                this.myConfigurationDirectoryText.setText(IdeaSubversionConfigurationDirectory.getPath());
            } else {
                this.myConfigurationDirectoryText.setText(path);
            }
        });
        this.myCommandLineClient.addBrowseFolderListener("Subversion", "Select path to Subversion executable (1.7+)", project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myClearAuthButton.addActionListener(e -> SvnAuthenticationNotifier.clearAuthenticationCache(this.myProject, this.myMainPanel, this.myConfigurationDirectoryText.getText()));
        this.myConfigurationDirectoryText.addActionListener(e -> {
            String path = this.myConfigurationDirectoryText.getText().trim();
            SvnConfigurable.selectConfigurationDirectory(path, (Consumer<String>)((Consumer)s -> this.myConfigurationDirectoryText.setText(s)), this.myProject, this.myMainPanel);
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/GeneralSettingsPanel", "getComponent"));
        }
        return jPanel;
    }

    public void reset(@NotNull SvnConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/idea/svn/GeneralSettingsPanel", "reset"));
        }
        String path = configuration.getConfigurationDirectory();
        if (configuration.isUseDefaultConfiguation() || path == null) {
            path = IdeaSubversionConfigurationDirectory.getPath();
        }
        this.myConfigurationDirectoryText.setText(path);
        this.myUseCustomConfigurationDirectory.setSelected(!configuration.isUseDefaultConfiguation());
        boolean enabled = this.myUseCustomConfigurationDirectory.isSelected();
        this.myConfigurationDirectoryText.setEnabled(enabled);
        this.myConfigurationDirectoryText.setEditable(enabled);
        this.myLockOnDemand.setSelected(configuration.isUpdateLockOnDemand());
        this.myWithCommandLineClient.setSelected(configuration.isCommandLine());
        this.myRunUnderTerminal.setSelected(configuration.isRunUnderTerminal());
        SvnApplicationSettings applicationSettings17 = SvnApplicationSettings.getInstance();
        this.myCommandLineClient.setText(applicationSettings17.getCommandLinePath());
    }

    public boolean isModified(@NotNull SvnConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/idea/svn/GeneralSettingsPanel", "isModified"));
        }
        if (configuration.isUseDefaultConfiguation() == this.myUseCustomConfigurationDirectory.isSelected()) {
            return true;
        }
        if (configuration.isUpdateLockOnDemand() != this.myLockOnDemand.isSelected()) {
            return true;
        }
        if (!configuration.getUseAcceleration().equals((Object)this.acceleration())) {
            return true;
        }
        if (configuration.isRunUnderTerminal() != this.myRunUnderTerminal.isSelected()) {
            return true;
        }
        SvnApplicationSettings applicationSettings17 = SvnApplicationSettings.getInstance();
        if (!Comparing.equal((String)applicationSettings17.getCommandLinePath(), (String)this.myCommandLineClient.getText().trim())) {
            return true;
        }
        return !configuration.getConfigurationDirectory().equals(this.myConfigurationDirectoryText.getText().trim());
    }

    public void apply(@NotNull SvnConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/idea/svn/GeneralSettingsPanel", "apply"));
        }
        configuration.setConfigurationDirParameters(!this.myUseCustomConfigurationDirectory.isSelected(), this.myConfigurationDirectoryText.getText());
        SvnVcs vcs17 = SvnVcs.getInstance(this.myProject);
        configuration.setUpdateLockOnDemand(this.myLockOnDemand.isSelected());
        SvnApplicationSettings applicationSettings17 = SvnApplicationSettings.getInstance();
        boolean reloadWorkingCopies = !this.acceleration().equals((Object)configuration.getUseAcceleration()) || !StringUtil.equals((CharSequence)applicationSettings17.getCommandLinePath(), (CharSequence)this.myCommandLineClient.getText().trim());
        configuration.setUseAcceleration(this.acceleration());
        configuration.setRunUnderTerminal(this.myRunUnderTerminal.isSelected());
        applicationSettings17.setCommandLinePath(this.myCommandLineClient.getText().trim());
        boolean isClientValid = vcs17.checkCommandLineVersion();
        if (isClientValid && reloadWorkingCopies) {
            vcs17.invokeRefreshSvnRoots();
            VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty();
        }
    }

    public void enableCommandLineClientOptions() {
        UIUtil.setEnabled((Component)this.myCommandLineClientOptions, (boolean)this.myWithCommandLineClient.isSelected(), (boolean)true);
    }

    private SvnConfiguration.UseAcceleration acceleration() {
        if (this.myWithCommandLineClient.isSelected()) {
            return SvnConfiguration.UseAcceleration.commandLine;
        }
        return SvnConfiguration.UseAcceleration.nothing;
    }

    private void createUIComponents() {
        this.myLockOnDemand = new JCheckBox(){

            @Override
            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip(){
                    {
                        this.setUI((ComponentUI)new MultiLineTooltipUI());
                    }
                };
                toolTip.setComponent(this);
                return toolTip;
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBCheckBox jBCheckBox2;
        JButton jButton;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JCheckBox jCheckBox2 = this.myLockOnDemand;
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.Subversion.update.use.locks.on.demand.description"));
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.Subversion.update.use.locks.on.demand.text.configurable"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myClearAuthButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("button.text.clear.authentication.cache"));
        jPanel4.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 1, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.text.delete.stored.credentials"));
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(6, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(5, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myWithCommandLineClient = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Use command line client:");
        jBCheckBox2.setMargin(new Insets(2, 3, 2, 3));
        jPanel5.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommandLineClient = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCommandLineClientOptions = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        this.myRunUnderTerminal = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("command.line.interactive.mode.title"));
        jBCheckBox.setMargin(new Insets(2, -2, 2, 3));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("command.line.interactive.mode.description"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myUseCustomConfigurationDirectory = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use custom configuration directory:");
        jCheckBox.setMnemonic('U');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConfigurationDirectoryText = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEditable(false);
        jPanel6.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

