/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffMixin;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.DiffProviderEx;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LatestExistentSearcher;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoConsumer;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnDiffProvider
extends DiffProviderEx
implements DiffProvider,
DiffMixin {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnDiffProvider");
    public static final String COMMIT_MESSAGE = "svn:log";
    private static final int BATCH_INFO_SIZE = 20;
    @NotNull
    private final SvnVcs myVcs;

    public SvnDiffProvider(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/SvnDiffProvider", "<init>"));
        }
        this.myVcs = vcs;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnDiffProvider", "getCurrentRevision"));
        }
        Info svnInfo = this.myVcs.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        return SvnDiffProvider.getRevision(svnInfo);
    }

    @Nullable
    private static VcsRevisionNumber getRevision(@Nullable Info info) {
        SvnRevisionNumber result = null;
        if (info != null) {
            SVNRevision revision = SVNRevision.UNDEFINED.equals((Object)info.getCommittedRevision()) && info.getCopyFromRevision() != null ? info.getCopyFromRevision() : info.getRevision();
            result = new SvnRevisionNumber(revision);
        }
        return result;
    }

    @NotNull
    public Map<VirtualFile, VcsRevisionNumber> getCurrentRevisions(@NotNull Iterable<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/svn/SvnDiffProvider", "getCurrentRevisions"));
        }
        HashMap result = ContainerUtil.newHashMap();
        HashMap items = ContainerUtil.newHashMap();
        ArrayList ioFiles = ContainerUtil.newArrayList();
        for (VirtualFile file : files) {
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            ioFiles.add(ioFile);
            items.put(ioFile.getAbsolutePath(), file);
            if (items.size() != 20) continue;
            this.collectRevisionsInBatch(result, items, ioFiles);
            items.clear();
            ioFiles.clear();
        }
        this.collectRevisionsInBatch(result, items, ioFiles);
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "getCurrentRevisions"));
        }
        return hashMap;
    }

    private void collectRevisionsInBatch(@NotNull Map<VirtualFile, VcsRevisionNumber> revisionMap, @NotNull Map<String, VirtualFile> fileMap, @NotNull List<File> ioFiles) {
        if (revisionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionMap", "org/jetbrains/idea/svn/SvnDiffProvider", "collectRevisionsInBatch"));
        }
        if (fileMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileMap", "org/jetbrains/idea/svn/SvnDiffProvider", "collectRevisionsInBatch"));
        }
        if (ioFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFiles", "org/jetbrains/idea/svn/SvnDiffProvider", "collectRevisionsInBatch"));
        }
        this.myVcs.collectInfo(ioFiles, SvnDiffProvider.createInfoHandler(revisionMap, fileMap));
    }

    @NotNull
    private static InfoConsumer createInfoHandler(@NotNull Map<VirtualFile, VcsRevisionNumber> revisionMap, @NotNull Map<String, VirtualFile> fileMap) {
        if (revisionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionMap", "org/jetbrains/idea/svn/SvnDiffProvider", "createInfoHandler"));
        }
        if (fileMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileMap", "org/jetbrains/idea/svn/SvnDiffProvider", "createInfoHandler"));
        }
        InfoConsumer infoConsumer = info -> {
            if (fileMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileMap", "org/jetbrains/idea/svn/SvnDiffProvider", "lambda$createInfoHandler$0"));
            }
            if (revisionMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionMap", "org/jetbrains/idea/svn/SvnDiffProvider", "lambda$createInfoHandler$0"));
            }
            if (info != null) {
                VirtualFile file = (VirtualFile)fileMap.get(info.getFile().getAbsolutePath());
                if (file != null) {
                    revisionMap.put(file, SvnDiffProvider.getRevision(info));
                } else {
                    LOG.info("Could not find virtual file for path " + info.getFile().getAbsolutePath());
                }
            }
        };
        if (infoConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "createInfoHandler"));
        }
        return infoConsumer;
    }

    @Nullable
    public VcsRevisionDescription getCurrentRevisionDescription(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnDiffProvider", "getCurrentRevisionDescription"));
        }
        return this.getCurrentRevisionDescription(VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @Nullable
    private VcsRevisionDescription getCurrentRevisionDescription(@NotNull File path) {
        File localPath;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnDiffProvider", "getCurrentRevisionDescription"));
        }
        Info svnInfo = this.myVcs.getInfo(path);
        if (svnInfo == null) {
            return null;
        }
        if (svnInfo.getCommittedRevision().equals((Object)SVNRevision.UNDEFINED) && !svnInfo.getCopyFromRevision().equals((Object)SVNRevision.UNDEFINED) && svnInfo.getCopyFromURL() != null && (localPath = this.myVcs.getSvnFileUrlMapping().getLocalPath(svnInfo.getCopyFromURL().toString())) != null) {
            return this.getCurrentRevisionDescription(localPath);
        }
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new SvnRevisionNumber(svnInfo.getCommittedRevision()), svnInfo.getCommittedDate(), svnInfo.getAuthor(), this.getCommitMessage(path, svnInfo));
    }

    @Nullable
    private String getCommitMessage(@NotNull File path, @NotNull Info info) {
        String result;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnDiffProvider", "getCommitMessage"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/SvnDiffProvider", "getCommitMessage"));
        }
        try {
            PropertyValue property = this.myVcs.getFactory(path).createPropertyClient().getProperty(SvnTarget.fromFile((File)path), COMMIT_MESSAGE, true, info.getCommittedRevision());
            result = PropertyValue.toString(property);
        }
        catch (VcsException e) {
            LOG.info("Failed to get commit message for file " + path + ", " + info.getCommittedRevision() + ", " + info.getRevision(), (Throwable)e);
            result = "";
        }
        return result;
    }

    @NotNull
    private static ItemLatestState defaultResult() {
        ItemLatestState itemLatestState = SvnDiffProvider.createResult(SVNRevision.HEAD, true, true);
        if (itemLatestState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "defaultResult"));
        }
        return itemLatestState;
    }

    @NotNull
    private static ItemLatestState createResult(@NotNull SVNRevision revision, boolean exists, boolean defaultHead) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/SvnDiffProvider", "createResult"));
        }
        ItemLatestState itemLatestState = new ItemLatestState((VcsRevisionNumber)new SvnRevisionNumber(revision), exists, defaultHead);
        if (itemLatestState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "createResult"));
        }
        return itemLatestState;
    }

    @NotNull
    public ItemLatestState getLastRevision(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastRevision"));
        }
        ItemLatestState itemLatestState = this.getLastRevision(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        if (itemLatestState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastRevision"));
        }
        return itemLatestState;
    }

    @NotNull
    public ContentRevision createFileContent(@NotNull VcsRevisionNumber revisionNumber, @NotNull VirtualFile selectedFile) {
        if (revisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionNumber", "org/jetbrains/idea/svn/SvnDiffProvider", "createFileContent"));
        }
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "org/jetbrains/idea/svn/SvnDiffProvider", "createFileContent"));
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)selectedFile);
        SVNRevision svnRevision = ((SvnRevisionNumber)revisionNumber).getRevision();
        if (!SVNRevision.HEAD.equals((Object)svnRevision) && revisionNumber.equals(this.getCurrentRevision(selectedFile))) {
            SvnContentRevision svnContentRevision = SvnContentRevision.createBaseRevision(this.myVcs, filePath, svnRevision);
            if (svnContentRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "createFileContent"));
            }
            return svnContentRevision;
        }
        Status svnStatus = this.getFileStatus(VfsUtilCore.virtualToIoFile((VirtualFile)selectedFile), false);
        SvnContentRevision svnContentRevision = svnStatus != null && svnRevision.equals((Object)svnStatus.getRevision()) ? SvnContentRevision.createBaseRevision(this.myVcs, filePath, svnRevision) : SvnContentRevision.createRemote(this.myVcs, filePath, svnRevision);
        if (svnContentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "createFileContent"));
        }
        return svnContentRevision;
    }

    @Nullable
    private Status getFileStatus(@NotNull File file, boolean remote) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnDiffProvider", "getFileStatus"));
        }
        Status result = null;
        try {
            result = this.myVcs.getFactory(file).createStatusClient().doStatus(file, remote);
        }
        catch (SvnBindException e) {
            LOG.debug((Throwable)((Object)e));
        }
        return result;
    }

    @NotNull
    public ItemLatestState getLastRevision(@NotNull FilePath filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastRevision"));
        }
        ItemLatestState itemLatestState = this.getLastRevision(filePath.getIOFile());
        if (itemLatestState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastRevision"));
        }
        return itemLatestState;
    }

    @Nullable
    public VcsRevisionNumber getLatestCommittedRevision(@NotNull VirtualFile vcsRoot) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "org/jetbrains/idea/svn/SvnDiffProvider", "getLatestCommittedRevision"));
        }
        Info info = this.myVcs.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)vcsRoot), SVNRevision.HEAD);
        return info != null ? new SvnRevisionNumber(info.getCommittedRevision()) : null;
    }

    @NotNull
    private ItemLatestState getLastRevision(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastRevision"));
        }
        Status svnStatus = this.getFileStatus(file, true);
        if (svnStatus == null || SvnDiffProvider.itemExists(svnStatus) && SVNRevision.UNDEFINED.equals((Object)svnStatus.getRemoteRevision())) {
            Info info = this.myVcs.getInfo(file, SVNRevision.HEAD);
            if (info == null || info.getURL() == null) {
                LOG.info("No SVN status returned for " + file.getPath());
                ItemLatestState itemLatestState = SvnDiffProvider.defaultResult();
                if (itemLatestState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastRevision"));
                }
                return itemLatestState;
            }
            ItemLatestState itemLatestState = SvnDiffProvider.createResult(info.getCommittedRevision(), true, false);
            if (itemLatestState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastRevision"));
            }
            return itemLatestState;
        }
        if (!SvnDiffProvider.itemExists(svnStatus)) {
            ItemLatestState itemLatestState = SvnDiffProvider.createResult(this.getLastExistingRevision(file, svnStatus), false, false);
            if (itemLatestState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastRevision"));
            }
            return itemLatestState;
        }
        ItemLatestState itemLatestState = SvnDiffProvider.createResult((SVNRevision)ObjectUtils.notNull((Object)svnStatus.getRemoteRevision(), (Object)svnStatus.getRevision()), true, false);
        if (itemLatestState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastRevision"));
        }
        return itemLatestState;
    }

    @NotNull
    private SVNRevision getLastExistingRevision(@NotNull File file, @NotNull Status svnStatus) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastExistingRevision"));
        }
        if (svnStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svnStatus", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastExistingRevision"));
        }
        WorkingCopyFormat format = this.myVcs.getWorkingCopyFormat(file);
        long revision = -1L;
        if (format.less(WorkingCopyFormat.ONE_DOT_EIGHT)) {
            if (svnStatus.getRepositoryRootURL() != null) {
                revision = new LatestExistentSearcher(this.myVcs, svnStatus.getURL(), svnStatus.getRepositoryRootURL()).getDeletionRevision();
            } else {
                LOG.info("Could not find repository url for file " + file);
            }
        }
        SVNRevision sVNRevision = SVNRevision.create((long)revision);
        if (sVNRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnDiffProvider", "getLastExistingRevision"));
        }
        return sVNRevision;
    }

    private static boolean itemExists(@NotNull Status svnStatus) {
        if (svnStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "svnStatus", "org/jetbrains/idea/svn/SvnDiffProvider", "itemExists"));
        }
        return !StatusType.STATUS_DELETED.equals((Object)svnStatus.getRemoteContentsStatus()) && !StatusType.STATUS_DELETED.equals((Object)svnStatus.getRemoteNodeStatus());
    }
}

