/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.RootUrlPair;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class UniqueRootsFilter {
    @NotNull
    public <T extends RootUrlPair> List<T> filter(@NotNull List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/UniqueRootsFilter", "filter"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        Collections.sort(list, Comparator.comparing(item -> item.getVirtualFile().getPath()));
        for (RootUrlPair child : list) {
            if (UniqueRootsFilter.alreadyRegistered(child, result)) continue;
            result.add(child);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/UniqueRootsFilter", "filter"));
        }
        return arrayList;
    }

    private static <T extends RootUrlPair> boolean alreadyRegistered(@NotNull T child, @NotNull List<T> registered) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/idea/svn/UniqueRootsFilter", "alreadyRegistered"));
        }
        if (registered == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registered", "org/jetbrains/idea/svn/UniqueRootsFilter", "alreadyRegistered"));
        }
        return ContainerUtil.exists(registered, parent -> {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/idea/svn/UniqueRootsFilter", "lambda$alreadyRegistered$1"));
            }
            return UniqueRootsFilter.isSamePath(child, parent) || UniqueRootsFilter.isSameSupposedUrl(child, parent);
        });
    }

    private static <T extends RootUrlPair> boolean isSamePath(@NotNull T child, @NotNull T parent) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/idea/svn/UniqueRootsFilter", "isSamePath"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/idea/svn/UniqueRootsFilter", "isSamePath"));
        }
        return parent.getVirtualFile().getPath().equals(child.getVirtualFile().getPath());
    }

    private static <T extends RootUrlPair> boolean isSameSupposedUrl(@NotNull T child, @NotNull T parent) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/idea/svn/UniqueRootsFilter", "isSameSupposedUrl"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/idea/svn/UniqueRootsFilter", "isSameSupposedUrl"));
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)child.getVirtualFile(), (VirtualFile)parent.getVirtualFile(), (char)'/');
        return relativePath != null && SVNPathUtil.append((String)parent.getUrl(), (String)relativePath).equals(child.getUrl());
    }
}

