/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWorkingCopyFormatHolder;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.actions.ExclusiveBackgroundVcsAction;
import org.jetbrains.idea.svn.actions.SvnExcludingIgnoredOperation;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.dialogs.ShareDialog;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class ShareProjectAction
extends BasicAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = SvnBundle.message("share.directory.action", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/ShareProjectAction", "getActionName"));
        }
        return string;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/actions/ShareProjectAction", "update"));
        }
        Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project = e.getProject();
        boolean visible = project != null && !ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning() && !ArrayUtil.isEmpty((Object[])files) && files.length == 1 && files[0].isDirectory();
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && !SvnStatusUtil.isUnderControl(project, (VirtualFile)files[0]));
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "isEnabled"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ShareProjectAction", "isEnabled"));
        }
        return false;
    }

    public static boolean share(@NotNull Project project, @NotNull VirtualFile file) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/actions/ShareProjectAction", "share"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ShareProjectAction", "share"));
        }
        return ShareProjectAction.performImpl(SvnVcs.getInstance(project), file);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "perform"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ShareProjectAction", "perform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/actions/ShareProjectAction", "perform"));
        }
        ShareProjectAction.performImpl(vcs, file);
    }

    private static boolean performImpl(@NotNull SvnVcs vcs, @NotNull VirtualFile file) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "performImpl"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ShareProjectAction", "performImpl"));
        }
        ShareDialog shareDialog = new ShareDialog(vcs.getProject(), file.getName());
        shareDialog.show();
        String parent = shareDialog.getSelectedURL();
        if (shareDialog.isOK() && parent != null) {
            Ref actionStarted = new Ref((Object)Boolean.TRUE);
            Exception[] error = new Exception[1];
            ShareDialog.ShareTarget shareTarget = shareDialog.getShareTarget();
            if (ShareDialog.ShareTarget.useSelected.equals((Object)shareTarget) && !ShareProjectAction.isFolderEmpty(vcs, parent) && 0 != Messages.showYesNoDialog((Project)vcs.getProject(), (String)("Remote folder \"" + parent + "\" is not empty.\nDo you want to continue sharing?"), (String)"Share Directory", (Icon)Messages.getWarningIcon())) {
                return false;
            }
            WorkingCopyFormat format = SvnCheckoutProvider.promptForWCopyFormat(VfsUtilCore.virtualToIoFile((VirtualFile)file), vcs.getProject());
            actionStarted.set((Object)(format != WorkingCopyFormat.UNKNOWN ? 1 : 0));
            if (format == WorkingCopyFormat.UNKNOWN) {
                return true;
            }
            ExclusiveBackgroundVcsAction.run(vcs.getProject(), () -> {
                if (vcs == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "lambda$performImpl$1"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ShareProjectAction", "lambda$performImpl$1"));
                }
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                    if (vcs == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "lambda$null$0"));
                    }
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ShareProjectAction", "lambda$null$0"));
                    }
                    try {
                        SvnWorkingCopyFormatHolder.setPresetFormat(format);
                        SvnTarget checkoutTarget = ShareProjectAction.createFolderStructure(vcs, file, shareTarget, shareDialog.createStandardStructure(), SvnUtil.createUrl(parent), shareDialog.getCommitText());
                        ProgressManager.progress((String)SvnBundle.message("share.directory.checkout.back.progress.text", checkoutTarget.getPathOrUrlString()));
                        ClientFactory factory = SvnCheckoutProvider.getFactory(vcs, format);
                        factory.createCheckoutClient().checkout(SvnTarget.fromURL((SVNURL)checkoutTarget.getURL()), VfsUtilCore.virtualToIoFile((VirtualFile)file), checkoutTarget.getPegRevision(), Depth.INFINITY, false, false, format, null);
                        ShareProjectAction.addRecursively(vcs, factory, file);
                    }
                    catch (VcsException e) {
                        error[0] = e;
                    }
                    finally {
                        vcs.invokeRefreshSvnRoots();
                        SvnWorkingCopyFormatHolder.setPresetFormat(null);
                    }
                }, SvnBundle.message("share.directory.title", new Object[0]), true, vcs.getProject());
            });
            if (Boolean.TRUE.equals(actionStarted.get())) {
                if (error[0] != null) {
                    throw new VcsException(error[0].getMessage());
                }
                Messages.showInfoMessage((Project)vcs.getProject(), (String)SvnBundle.message("share.directory.info.message", file.getName()), (String)SvnBundle.message("share.directory.title", new Object[0]));
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static SvnTarget createFolderStructure(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull ShareDialog.ShareTarget shareTarget, boolean createStandardStructure, @NotNull SVNURL parentUrl, @NotNull String commitText) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createFolderStructure"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createFolderStructure"));
        }
        if (shareTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shareTarget", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createFolderStructure"));
        }
        if (parentUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentUrl", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createFolderStructure"));
        }
        if (commitText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitText", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createFolderStructure"));
        }
        switch (shareTarget) {
            case useSelected: {
                SvnTarget svnTarget = SvnTarget.fromURL((SVNURL)parentUrl, (SVNRevision)SVNRevision.HEAD);
                if (svnTarget == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createFolderStructure"));
                }
                return svnTarget;
            }
            case useProjectName: {
                SvnTarget svnTarget = ShareProjectAction.createRemoteFolder(vcs, parentUrl, file.getName(), commitText);
                if (svnTarget == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createFolderStructure"));
                }
                return svnTarget;
            }
        }
        SvnTarget projectRoot = ShareProjectAction.createRemoteFolder(vcs, parentUrl, file.getName(), commitText);
        SvnTarget trunk = ShareProjectAction.createRemoteFolder(vcs, projectRoot.getURL(), "trunk", commitText);
        if (createStandardStructure) {
            ShareProjectAction.createRemoteFolder(vcs, projectRoot.getURL(), "branches", commitText);
            ShareProjectAction.createRemoteFolder(vcs, projectRoot.getURL(), "tags", commitText);
        }
        SvnTarget svnTarget = trunk;
        if (svnTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createFolderStructure"));
        }
        return svnTarget;
    }

    private static boolean isFolderEmpty(@NotNull SvnVcs vcs, @NotNull String folderUrl) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "isFolderEmpty"));
        }
        if (folderUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderUrl", "org/jetbrains/idea/svn/actions/ShareProjectAction", "isFolderEmpty"));
        }
        return (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "lambda$isFolderEmpty$2"));
            }
            if (folderUrl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderUrl", "org/jetbrains/idea/svn/actions/ShareProjectAction", "lambda$isFolderEmpty$2"));
            }
            return SvnUtil.remoteFolderIsEmpty(vcs, folderUrl);
        }, "Check Remote Folder Contents", false, vcs.getProject());
    }

    @NotNull
    private static SvnTarget createRemoteFolder(@NotNull SvnVcs vcs, @NotNull SVNURL parent, @NotNull String folderName, @NotNull String commitText) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createRemoteFolder"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createRemoteFolder"));
        }
        if (folderName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderName", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createRemoteFolder"));
        }
        if (commitText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitText", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createRemoteFolder"));
        }
        SVNURL url = SvnUtil.append(parent, folderName);
        String message = SvnBundle.message("share.directory.commit.message", folderName, ApplicationNamesInfo.getInstance().getFullProductName(), commitText);
        SvnTarget target = SvnTarget.fromURL((SVNURL)url);
        ProgressManager.progress((String)SvnBundle.message("share.directory.create.dir.progress.text", url.toString()));
        long revision = vcs.getFactoryFromSettings().createBrowseClient().createDirectory(target, message, false);
        SvnTarget svnTarget = SvnTarget.fromURL((SVNURL)url, (SVNRevision)SVNRevision.create((long)revision));
        if (svnTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createRemoteFolder"));
        }
        return svnTarget;
    }

    @Override
    protected void doVcsRefresh(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "doVcsRefresh"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ShareProjectAction", "doVcsRefresh"));
        }
        VcsDirtyScopeManager.getInstance((Project)vcs.getProject()).dirDirtyRecursively(file);
    }

    private static void addRecursively(@NotNull SvnVcs vcs, @NotNull ClientFactory factory, @NotNull VirtualFile rootFile) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "addRecursively"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/idea/svn/actions/ShareProjectAction", "addRecursively"));
        }
        if (rootFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootFile", "org/jetbrains/idea/svn/actions/ShareProjectAction", "addRecursively"));
        }
        SvnExcludingIgnoredOperation operation = new SvnExcludingIgnoredOperation(vcs.getProject(), file -> {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/idea/svn/actions/ShareProjectAction", "lambda$addRecursively$3"));
            }
            ProgressManager.progress((String)SvnBundle.message("share.or.import.add.progress.text", file.getPath()));
            factory.createAddClient().add(VfsUtilCore.virtualToIoFile((VirtualFile)file), Depth.EMPTY, false, false, true, null);
        }, Depth.INFINITY);
        operation.execute(rootFile);
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "batchPerform"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/svn/actions/ShareProjectAction", "batchPerform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/actions/ShareProjectAction", "batchPerform"));
        }
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

