/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.dialogs.PropertiesComponent;

public class ShowPropertiesAction
extends BasicAction {
    @Override
    @NotNull
    protected String getActionName() {
        if ("Show Properties" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/ShowPropertiesAction", "getActionName"));
        }
        return "Show Properties";
    }

    @Override
    protected boolean needsAllFiles() {
        return false;
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShowPropertiesAction", "isEnabled"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ShowPropertiesAction", "isEnabled"));
        }
        FileStatus status = FileStatusManager.getInstance((Project)vcs.getProject()).getStatus(file);
        return status != null && !FileStatus.UNKNOWN.equals(status) && !FileStatus.IGNORED.equals(status);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShowPropertiesAction", "perform"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ShowPropertiesAction", "perform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/actions/ShowPropertiesAction", "perform"));
        }
        this.batchPerform(vcs, (VirtualFile[])ContainerUtil.ar((Object[])new VirtualFile[]{file}), context);
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files, @NotNull DataContext context) throws VcsException {
        PropertiesComponent component;
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShowPropertiesAction", "batchPerform"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/svn/actions/ShowPropertiesAction", "batchPerform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/actions/ShowPropertiesAction", "batchPerform"));
        }
        File[] ioFiles = SvnUtil.toIoFiles(files);
        ToolWindow w = ToolWindowManager.getInstance((Project)vcs.getProject()).getToolWindow("SVN Properties");
        if (w == null) {
            component = new PropertiesComponent();
            w = ToolWindowManager.getInstance((Project)vcs.getProject()).registerToolWindow("SVN Properties", (JComponent)component, ToolWindowAnchor.BOTTOM);
        } else {
            component = (PropertiesComponent)w.getContentManager().getContents()[0].getComponent();
        }
        w.setTitle(ioFiles[0].getName());
        w.show(null);
        w.activate(() -> {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShowPropertiesAction", "lambda$batchPerform$0"));
            }
            component.setFile(vcs, ioFiles[0]);
        });
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

