/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SystemProperties;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.messages.Topic;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.ui.UIUtil;
import com.trilead.ssh2.auth.AgentProxy;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.IdeaSVNConfigFile;
import org.jetbrains.idea.svn.NativeLogReader;
import org.jetbrains.idea.svn.SSLExceptionsHelper;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnNativeCallsTranslator;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.ProviderType;
import org.jetbrains.idea.svn.auth.ProxySvnAuthentication;
import org.jetbrains.idea.svn.auth.SvnAuthenticationInteraction;
import org.jetbrains.idea.svn.auth.SvnAuthenticationListener;
import org.jetbrains.idea.svn.config.ProxyGroup;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManagerExt;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNHostOptionsProvider;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNPersistentAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthStoreHandler;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorage;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorageOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNGnomeKeyringPasswordProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptionsProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNPersistentAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SvnAuthenticationManager
extends DefaultSVNAuthenticationManager
implements SvnAuthenticationListener,
ISVNAuthenticationManagerExt {
    private static final Logger LOG = Logger.getInstance(SvnAuthenticationManager.class);
    public static final String SVN_SSH = "svn+ssh";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String HTTP_PROXY_HOST = "http-proxy-host";
    public static final String HTTP_PROXY_PORT = "http-proxy-port";
    public static final String HTTP_PROXY_USERNAME = "http-proxy-username";
    public static final String HTTP_PROXY_PASSWORD = "http-proxy-password";
    private SvnVcs myVcs;
    private Project myProject;
    private File myConfigDirectory;
    private ISVNAuthenticationProvider myRuntimeCacheProvider;
    private PersistentAuthenticationProviderProxy myPersistentAuthenticationProviderProxy;
    private SvnConfiguration myConfig;
    private static final ThreadLocal<Boolean> ourJustEntered = new ThreadLocal();
    private SvnAuthenticationInteraction myInteraction;
    private EventDispatcher<SvnAuthenticationListener> myListener;
    private IdeaSVNHostOptionsProvider myLocalHostOptionsProvider;
    private final ThreadLocalSavePermissions mySavePermissions;
    private final Map<Thread, String> myKeyAlgorithm;
    private boolean myArtificialSaving;
    private ISVNAuthenticationProvider myProvider;
    public static final Topic<ISVNAuthenticationProviderListener> AUTHENTICATION_PROVIDER_LISTENER = new Topic("AUTHENTICATION_PROVIDER_LISTENER", ISVNAuthenticationProviderListener.class);
    private static final ThreadLocal<ISVNAuthenticationProvider> ourThreadLocalProvider = new ThreadLocal();
    private static final int DEFAULT_READ_TIMEOUT = 30000;

    public SvnAuthenticationManager(@NotNull SvnVcs vcs, File configDirectory) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/auth/SvnAuthenticationManager", "<init>"));
        }
        super(configDirectory, true, null, null);
        this.myVcs = vcs;
        this.myProject = this.myVcs.getProject();
        this.myConfigDirectory = configDirectory;
        this.myKeyAlgorithm = new HashMap<Thread, String>();
        this.ensureListenerCreated();
        this.mySavePermissions = new ThreadLocalSavePermissions();
        this.myConfig = this.myVcs.getSvnConfiguration();
        if (this.myPersistentAuthenticationProviderProxy != null) {
            this.myPersistentAuthenticationProviderProxy.setProject(this.myProject);
        }
        this.myInteraction = new MySvnAuthenticationInteraction(this.myProject);
        Disposer.register((Disposable)this.myProject, () -> {
            this.myVcs = null;
            this.myProject = null;
            if (this.myPersistentAuthenticationProviderProxy != null) {
                this.myPersistentAuthenticationProviderProxy.myProject = null;
                ((MyKeyringMasterKeyProvider)this.myPersistentAuthenticationProviderProxy.myISVNGnomeKeyringPasswordProvider).myProject = null;
                this.myPersistentAuthenticationProviderProxy = null;
            }
            if (this.myInteraction instanceof MySvnAuthenticationInteraction) {
                ((MySvnAuthenticationInteraction)this.myInteraction).myProject = null;
            }
            if (this.myConfig != null) {
                this.myConfig.clear();
                this.myConfig = null;
            }
            this.myInteraction = null;
        });
        this.myRuntimeCacheProvider = this.createRuntimeAuthenticationProvider();
    }

    public SVNAuthentication requestFromCache(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        return this.myRuntimeCacheProvider.requestClientAuthentication(kind, url, realm, errorMessage, previousAuth, authMayBeStored);
    }

    public String getDefaultUsername(String kind, SVNURL url) {
        String result = SystemProperties.getUserName();
        if ("svn.ssh".equals(kind) || "svn.username".equals(kind) && SVN_SSH.equals(url.getProtocol())) {
            result = url != null && !StringUtil.isEmpty((String)url.getUserInfo()) ? url.getUserInfo() : this.getDefaultOptions().getDefaultSSHUserName();
        }
        return result;
    }

    protected SVNSSHAuthentication getDefaultSSHAuthentication(SVNURL url) {
        String userName = this.getDefaultUsername("svn.ssh", url);
        String password = this.getDefaultOptions().getDefaultSSHPassword();
        String keyFile = this.getDefaultOptions().getDefaultSSHKeyFile();
        int port = this.getDefaultOptions().getDefaultSSHPortNumber();
        String passphrase = this.getDefaultOptions().getDefaultSSHPassphrase();
        if (userName != null && password != null) {
            return new SVNSSHAuthentication(userName, password, port, this.getHostOptionsProvider().getHostOptions(url).isAuthStorageEnabled(), url, false);
        }
        if (userName != null && keyFile != null) {
            return new SVNSSHAuthentication(userName, new File(keyFile), passphrase, port, this.getHostOptionsProvider().getHostOptions(url).isAuthStorageEnabled(), url, false);
        }
        return null;
    }

    public void setAuthenticationProvider(ISVNAuthenticationProvider provider) {
        ISVNAuthenticationProvider useProvider = provider;
        if (!(provider instanceof AuthenticationProviderProxy)) {
            useProvider = new AuthenticationProviderProxy(provider);
        }
        this.myProvider = useProvider;
        super.setAuthenticationProvider(this.myProvider);
    }

    public ISVNAuthenticationProvider getProvider() {
        ISVNAuthenticationProvider threadProvider = ourThreadLocalProvider.get();
        if (threadProvider != null) {
            return threadProvider;
        }
        return this.myProvider;
    }

    public ISVNAuthenticationProvider getInnerProvider() {
        return this.myProvider;
    }

    public ISVNAuthenticationStorage getRuntimeAuthStorage() {
        return super.getRuntimeAuthStorage();
    }

    private SvnConfiguration getConfig() {
        if (this.myConfig == null) {
            throw new ProcessCanceledException();
        }
        return this.myConfig;
    }

    public void setArtificialSaving(boolean artificialSaving) {
        this.myArtificialSaving = artificialSaving;
    }

    private void ensureListenerCreated() {
        if (this.myListener == null) {
            this.myListener = EventDispatcher.create(SvnAuthenticationListener.class);
        }
    }

    public IdeaSVNHostOptionsProvider getHostOptionsProvider() {
        if (this.myLocalHostOptionsProvider == null) {
            this.myLocalHostOptionsProvider = new IdeaSVNHostOptionsProvider();
        }
        return this.myLocalHostOptionsProvider;
    }

    public void addListener(SvnAuthenticationListener listener) {
        this.myListener.addListener((EventListener)listener);
    }

    @Override
    public void actualSaveWillBeTried(ProviderType type, SVNURL url, String realm, String kind) {
        ((SvnAuthenticationListener)this.myListener.getMulticaster()).actualSaveWillBeTried(type, url, realm, kind);
    }

    @Override
    public void saveAttemptStarted(ProviderType type, SVNURL url, String realm, String kind) {
        ((SvnAuthenticationListener)this.myListener.getMulticaster()).saveAttemptStarted(type, url, realm, kind);
    }

    @Override
    public void saveAttemptFinished(ProviderType type, SVNURL url, String realm, String kind) {
        ((SvnAuthenticationListener)this.myListener.getMulticaster()).saveAttemptFinished(type, url, realm, kind);
    }

    @Override
    public void acknowledge(boolean accepted, String kind, String realm, SVNErrorMessage message, SVNAuthentication authentication) {
        ((SvnAuthenticationListener)this.myListener.getMulticaster()).acknowledge(accepted, kind, realm, message, authentication);
    }

    @Override
    public void requested(ProviderType type, SVNURL url, String realm, String kind, boolean canceled) {
        if (ProviderType.interactive.equals((Object)type) && !canceled) {
            ourJustEntered.set(true);
        }
        ((SvnAuthenticationListener)this.myListener.getMulticaster()).requested(type, url, realm, kind, canceled);
    }

    protected ISVNAuthenticationProvider createCacheAuthenticationProvider(File authDir, String userName) {
        this.myConfigDirectory = new File(authDir.getParent());
        this.myPersistentAuthenticationProviderProxy = new PersistentAuthenticationProviderProxy(authDir, userName);
        return this.myPersistentAuthenticationProviderProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyHostKey(String hostName, int port, String keyAlgorithm, byte[] hostKey) throws SVNException {
        this.myKeyAlgorithm.put(Thread.currentThread(), keyAlgorithm);
        try {
            super.verifyHostKey(hostName, port, keyAlgorithm, hostKey);
        }
        finally {
            this.myKeyAlgorithm.remove(Thread.currentThread());
        }
    }

    @Nullable
    public String getSSHKeyAlgorithm() {
        return this.myKeyAlgorithm.get(Thread.currentThread());
    }

    public void acknowledgeConnectionSuccessful(SVNURL url, String method) {
        CommonProxy.getInstance().removeNoProxy(url.getProtocol(), url.getHost(), url.getPort());
        SSLExceptionsHelper.removeInfo();
        ourThreadLocalProvider.remove();
    }

    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication) throws SVNException {
        this.acknowledgeAuthentication(accepted, kind, realm, errorMessage, authentication, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeAuthentication(boolean accepted, String kind, String realm, SVNErrorMessage errorMessage, SVNAuthentication authentication, SVNURL url) throws SVNException {
        this.showSshAgentErrorIfAny(errorMessage, authentication);
        SSLExceptionsHelper.removeInfo();
        ourThreadLocalProvider.remove();
        if (url != null) {
            CommonProxy.getInstance().removeNoProxy(url.getProtocol(), url.getHost(), url.getPort());
        }
        boolean successSaving = false;
        ((SvnAuthenticationListener)this.myListener.getMulticaster()).acknowledge(accepted, kind, realm, errorMessage, authentication);
        try {
            boolean authStorageEnabled = this.getHostOptionsProvider().getHostOptions(authentication.getURL()).isAuthStorageEnabled();
            SVNAuthentication proxy = ProxySvnAuthentication.proxy(authentication, authStorageEnabled, this.myArtificialSaving);
            super.acknowledgeAuthentication(accepted, kind, realm, errorMessage, proxy);
            successSaving = true;
        }
        finally {
            this.mySavePermissions.remove();
            if (this.myArtificialSaving) {
                this.myArtificialSaving = false;
                throw new CredentialsSavedException(successSaving);
            }
        }
    }

    private void showSshAgentErrorIfAny(@Nullable SVNErrorMessage errorMessage, @Nullable SVNAuthentication authentication) {
        AgentProxy agentProxy;
        if (errorMessage != null && authentication instanceof SVNSSHAuthentication && (agentProxy = ((SVNSSHAuthentication)authentication).getAgentProxy()) != null) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)errorMessage.getFullMessage(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
        }
    }

    public void acknowledgeForSSL(boolean accepted, SVNAuthentication proxy) {
        if (accepted && proxy instanceof SVNSSLAuthentication && ((SVNSSLAuthentication)proxy).getCertificateFile() != null) {
            SVNSSLAuthentication svnsslAuthentication = (SVNSSLAuthentication)proxy;
            SVNURL url = svnsslAuthentication.getURL();
            IdeaSVNHostOptionsProvider provider = this.getHostOptionsProvider();
            SVNCompositeConfigFile serversFile = provider.getServersFile();
            String groupName = SvnAuthenticationManager.getGroupName(serversFile.getProperties("groups"), url.getHost());
            groupName = StringUtil.isEmptyOrSpaces((String)groupName) ? "global" : groupName;
            serversFile.setPropertyValue(groupName, "ssl-client-cert-file", svnsslAuthentication.getCertificateFile().getPath(), true);
            serversFile.save();
        }
    }

    public ISVNProxyManager getProxyManager(SVNURL url) throws SVNException {
        SSLExceptionsHelper.addInfo("Accessing URL: " + url.toString());
        ourThreadLocalProvider.set(this.myProvider);
        ISVNProxyManager proxy = this.createProxy(url);
        CommonProxy.getInstance().noProxy(url.getProtocol(), url.getHost(), url.getPort());
        return proxy;
    }

    private ISVNProxyManager createProxy(SVNURL url) {
        String host = url.getHost();
        String proxyHost = this.getServersPropertyIdea(host, HTTP_PROXY_HOST);
        if (StringUtil.isEmptyOrSpaces((String)proxyHost)) {
            if (this.getConfig().isIsUseDefaultProxy()) {
                try {
                    List<Proxy> proxies = HttpConfigurable.getInstance().getOnlyBySettingsSelector().select(new URI(url.toString()));
                    if (proxies != null && !proxies.isEmpty()) {
                        for (Proxy proxy : proxies) {
                            SocketAddress address;
                            if (!HttpConfigurable.isRealProxy((Proxy)proxy) || !Proxy.Type.HTTP.equals((Object)proxy.type()) || !((address = proxy.address()) instanceof InetSocketAddress)) continue;
                            return new MyPromptingProxyManager(((InetSocketAddress)address).getHostName(), String.valueOf(((InetSocketAddress)address).getPort()), url.getProtocol());
                        }
                    }
                }
                catch (URISyntaxException e) {
                    LOG.info((Throwable)e);
                }
            }
            return null;
        }
        String proxyExceptions = this.getServersPropertyIdea(host, "http-proxy-exceptions");
        String proxyExceptionsSeparator = ",";
        if (proxyExceptions == null) {
            proxyExceptions = System.getProperty("http.nonProxyHosts");
            proxyExceptionsSeparator = "|";
        }
        if (proxyExceptions != null) {
            StringTokenizer exceptions = new StringTokenizer(proxyExceptions, proxyExceptionsSeparator);
            while (exceptions.hasMoreTokens()) {
                String exception = exceptions.nextToken().trim();
                if (!DefaultSVNOptions.matches((String)exception, (String)host)) continue;
                return null;
            }
        }
        String proxyPort = this.getServersPropertyIdea(host, HTTP_PROXY_PORT);
        String proxyUser = this.getServersPropertyIdea(host, HTTP_PROXY_USERNAME);
        String proxyPassword = this.getServersPropertyIdea(host, HTTP_PROXY_PASSWORD);
        return new MySimpleProxyManager(proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public int getReadTimeout(@NotNull SVNURL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/auth/SvnAuthenticationManager", "getReadTimeout"));
        }
        String protocol = url.getProtocol();
        if (HTTP.equals(protocol) || HTTPS.equals(protocol)) {
            String host = url.getHost();
            String timeout = this.getServersPropertyIdea(host, "http-timeout");
            if (timeout != null) {
                try {
                    return Integer.parseInt(timeout) * 1000;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 30000;
        }
        if (SVN_SSH.equals(protocol)) {
            return (int)this.getConfig().getSshReadTimeout();
        }
        return 0;
    }

    public int getConnectTimeout(@NotNull SVNURL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/auth/SvnAuthenticationManager", "getConnectTimeout"));
        }
        String protocol = url.getProtocol();
        if (SVN_SSH.equals(protocol)) {
            return (int)this.getConfig().getSshConnectionTimeout();
        }
        int connectTimeout = this.getHostOptionsProvider().getHostOptions(url).getConnectTimeout();
        if ((HTTP.equals(protocol) || HTTPS.equals(protocol)) && connectTimeout <= 0) {
            return 30000;
        }
        return connectTimeout;
    }

    public int getReadTimeout(@NotNull SVNRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/idea/svn/auth/SvnAuthenticationManager", "getReadTimeout"));
        }
        return this.getReadTimeout(repository.getLocation());
    }

    public int getConnectTimeout(@NotNull SVNRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/idea/svn/auth/SvnAuthenticationManager", "getConnectTimeout"));
        }
        return this.getConnectTimeout(repository.getLocation());
    }

    private String getServersPropertyIdea(String host, String name) {
        SVNCompositeConfigFile serversFile = this.getHostOptionsProvider().getServersFile();
        return SvnAuthenticationManager.getPropertyIdea(host, serversFile, name);
    }

    private static String getPropertyIdea(String host, SVNCompositeConfigFile serversFile, String name) {
        Map hostProps;
        String value;
        String groupName = SvnAuthenticationManager.getGroupName(serversFile.getProperties("groups"), host);
        if (groupName != null && (value = (String)(hostProps = serversFile.getProperties(groupName)).get(name)) != null) {
            return value;
        }
        Map globalProps = serversFile.getProperties("global");
        return (String)globalProps.get(name);
    }

    public static boolean checkHostGroup(String url, String patterns, String exceptions) {
        SVNURL svnurl;
        try {
            svnurl = SVNURL.parseURIEncoded((String)url);
        }
        catch (SVNException e) {
            return false;
        }
        String host = svnurl.getHost();
        return SvnAuthenticationManager.matches(patterns, host) && !SvnAuthenticationManager.matches(exceptions, host);
    }

    private static boolean matches(String pattern, String host) {
        StringTokenizer tokenizer = new StringTokenizer(pattern, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!DefaultSVNOptions.matches((String)token, (String)host)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getGroupForHost(String host, IdeaSVNConfigFile serversFile) {
        Map<String, ProxyGroup> groups = serversFile.getAllGroups();
        for (Map.Entry<String, ProxyGroup> entry : groups.entrySet()) {
            if (!SvnAuthenticationManager.matchesGroupPattern(host, entry.getValue().getPatterns())) continue;
            return entry.getKey();
        }
        return null;
    }

    private static String getGroupName(Map groups, String host) {
        for (Object o : groups.keySet()) {
            String name = (String)o;
            String pattern = (String)groups.get(name);
            if (!SvnAuthenticationManager.matchesGroupPattern(host, pattern)) continue;
            return name;
        }
        return null;
    }

    private static boolean matchesGroupPattern(String host, String pattern) {
        StringTokenizer tokens = new StringTokenizer(pattern, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!DefaultSVNOptions.matches((String)token, (String)host)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTurned(String value) {
        return value == null || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }

    private static ModalityState getCurrent() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return ModalityState.current();
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi == null) {
            return ModalityState.defaultModalityState();
        }
        return pi.getModalityState();
    }

    public void setInteraction(SvnAuthenticationInteraction interaction) {
        this.myInteraction = interaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T wrapNativeCall(ThrowableComputable<T, SVNException> runnable) throws SVNException {
        try {
            NativeLogReader.startTracking();
            Object t = runnable.compute();
            List<NativeLogReader.CallInfo> logged = NativeLogReader.getLogged();
            StringBuilder sb = new StringBuilder();
            for (NativeLogReader.CallInfo info : logged) {
                String message = SvnNativeCallsTranslator.getMessage(info);
                if (message == null) continue;
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(message);
            }
            if (sb.length() > 0) {
                VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)sb.toString(), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                LOG.info(sb.toString());
            }
            Object object = t;
            return (T)object;
        }
        finally {
            NativeLogReader.clear();
            NativeLogReader.endTracking();
        }
    }

    public static class CredentialsSavedException
    extends RuntimeException {
        private final boolean mySuccess;

        public CredentialsSavedException(boolean success) {
            this.mySuccess = success;
        }

        public boolean isSuccess() {
            return this.mySuccess;
        }
    }

    private static class MyKeyringMasterKeyProvider
    implements ISVNGnomeKeyringPasswordProvider {
        private Project myProject;

        public MyKeyringMasterKeyProvider(Project project) {
            this.myProject = project;
        }

        public char[] getKeyringPassword(String keyringName) throws SVNException {
            String message = keyringName != null ? SvnBundle.message("gnome.keyring.prompt.named", keyringName) : SvnBundle.message("gnome.keyring.prompt.nameless", new Object[0]);
            Ref result = Ref.create();
            UIUtil.invokeAndWaitIfNeeded(() -> result.set((Object)Messages.showPasswordDialog((Project)this.myProject, (String)message, (String)SvnBundle.message("subversion.name", new Object[0]), (Icon)Messages.getQuestionIcon())));
            return !result.isNull() ? ((String)result.get()).toCharArray() : null;
        }
    }

    private static class ProxyPasswordStorageForDebug
    implements DefaultSVNPersistentAuthenticationProvider.IPasswordStorage {
        private final DefaultSVNPersistentAuthenticationProvider.IPasswordStorage myDelegate;
        private final EventDispatcher<SvnAuthenticationListener> myListener;

        public ProxyPasswordStorageForDebug(DefaultSVNPersistentAuthenticationProvider.IPasswordStorage delegate, EventDispatcher<SvnAuthenticationListener> listener) {
            this.myDelegate = delegate;
            this.myListener = listener;
        }

        public String getPassType() {
            return this.myDelegate.getPassType();
        }

        public boolean savePassword(String realm, char[] password, SVNAuthentication auth, SVNProperties authParameters) throws SVNException {
            boolean saved = this.myDelegate.savePassword(realm, password, auth, authParameters);
            if (saved) {
                ((SvnAuthenticationListener)this.myListener.getMulticaster()).actualSaveWillBeTried(ProviderType.persistent, auth.getURL(), realm, auth.getKind());
            }
            return saved;
        }

        public char[] readPassword(String realm, String userName, SVNProperties authParameters) throws SVNException {
            return this.myDelegate.readPassword(realm, userName, authParameters);
        }

        public boolean savePassphrase(String realm, char[] passphrase, SVNAuthentication auth, SVNProperties authParameters, boolean force) throws SVNException {
            boolean saved = this.myDelegate.savePassphrase(realm, passphrase, auth, authParameters, force);
            if (saved) {
                ((SvnAuthenticationListener)this.myListener.getMulticaster()).actualSaveWillBeTried(ProviderType.persistent, auth.getURL(), realm, auth.getKind());
            }
            return saved;
        }

        public char[] readPassphrase(String realm, SVNProperties authParameters) throws SVNException {
            return this.myDelegate.readPassphrase(realm, authParameters);
        }
    }

    private class IdeaSVNHostOptions
    extends DefaultSVNHostOptions {
        private SVNCompositeConfigFile myConfigFile;
        private final SVNURL myUrl;

        private IdeaSVNHostOptions(SVNCompositeConfigFile serversFile, SVNURL url) {
            super(serversFile, url);
            this.myUrl = url;
        }

        public boolean isStorePlainTextPasswords(String realm, SVNAuthentication auth) throws SVNException {
            boolean value;
            if ("svn.username".equals(auth.getKind())) {
                return true;
            }
            boolean superValue = super.isStorePlainTextPasswords(realm, auth);
            boolean bl = value = SvnAuthenticationManager.this.mySavePermissions.allowed() || superValue;
            if (!value && !SvnAuthenticationManager.this.mySavePermissions.have()) {
                this.promptAndSaveWhenWeLackEncryption(realm, auth, (Getter<Boolean>)((Getter)() -> SvnAuthenticationManager.this.myInteraction.promptForPlaintextPasswordSaving(this.myUrl, realm)));
            }
            return value;
        }

        public boolean isStorePlainTextPassphrases(String realm, SVNAuthentication auth) throws SVNException {
            boolean value;
            if ("svn.username".equals(auth.getKind())) {
                return true;
            }
            boolean bl = value = SvnAuthenticationManager.this.mySavePermissions.allowed() || super.isStorePlainTextPassphrases(realm, auth);
            if (!value && !SvnAuthenticationManager.this.mySavePermissions.have()) {
                this.promptAndSaveWhenWeLackEncryption(realm, auth, (Getter<Boolean>)((Getter)() -> {
                    File file = null;
                    String certificateName = null;
                    if (auth instanceof SVNSSLAuthentication) {
                        file = ((SVNSSLAuthentication)auth).getCertificateFile();
                        certificateName = "client certificate";
                    } else if (auth instanceof SVNSSHAuthentication) {
                        file = ((SVNSSHAuthentication)auth).getPrivateKeyFile();
                        certificateName = "private key file";
                    } else assert (false);
                    return SvnAuthenticationManager.this.myInteraction.promptForSSLPlaintextPassphraseSaving(this.myUrl, realm, file, certificateName);
                }));
            }
            return value;
        }

        public boolean isAuthStorageEnabled() {
            boolean value = this.hasAuthStorageEnabledOption() ? super.isAuthStorageEnabled() : SvnAuthenticationManager.isTurned(this.getConfigFile().getPropertyValue("auth", "store-auth-creds"));
            if (!value) {
                SvnAuthenticationManager.this.myInteraction.warnOnAuthStorageDisabled(this.myUrl);
            }
            return value;
        }

        public boolean isStorePasswords() {
            boolean value;
            String storePasswords = this.getStorePasswords();
            if (storePasswords != null) {
                value = SvnAuthenticationManager.isTurned(storePasswords);
            } else {
                String configValue = this.getConfigFile().getPropertyValue("auth", "store-passwords");
                value = SvnAuthenticationManager.isTurned(configValue);
            }
            if (!value) {
                SvnAuthenticationManager.this.myInteraction.warnOnPasswordStorageDisabled(this.myUrl);
            }
            return value;
        }

        public boolean isStoreSSLClientCertificatePassphrases() {
            boolean value = super.isStoreSSLClientCertificatePassphrases();
            if (!value) {
                SvnAuthenticationManager.this.myInteraction.warnOnSSLPassphraseStorageDisabled(this.myUrl);
            }
            return value;
        }

        public String getStorePasswords() {
            return SvnAuthenticationManager.this.getServersPropertyIdea(this.getHost(), "store-passwords");
        }

        private SVNCompositeConfigFile getConfigFile() {
            if (this.myConfigFile == null) {
                File config = new File(SvnAuthenticationManager.this.myConfigDirectory, "config");
                SVNConfigFile.createDefaultConfiguration((File)SvnAuthenticationManager.this.myConfigDirectory);
                SVNConfigFile userConfig = new SVNConfigFile(config);
                SVNConfigFile systemConfig = new SVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "config"));
                this.myConfigFile = new SVNCompositeConfigFile(systemConfig, userConfig);
            }
            return this.myConfigFile;
        }

        private void promptAndSaveWhenWeLackEncryption(String realm, SVNAuthentication auth, Getter<Boolean> prompt) {
            Boolean[] saveOnce = new Boolean[1];
            Runnable actualSave = () -> {
                SvnAuthenticationManager.this.mySavePermissions.put(Boolean.TRUE.equals(saveOnce[0]));
                try {
                    SvnAuthenticationManager.this.myPersistentAuthenticationProviderProxy.actualSavePermissions(realm, auth);
                }
                finally {
                    SvnAuthenticationManager.this.mySavePermissions.remove();
                }
            };
            if (SvnAuthenticationManager.this.myInteraction.promptInAwt()) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> {
                    saveOnce[0] = Boolean.TRUE.equals(prompt.get());
                    ApplicationManager.getApplication().executeOnPooledThread(actualSave);
                }, (ModalityState)SvnAuthenticationManager.getCurrent(), (Project)SvnAuthenticationManager.this.myProject);
            } else {
                saveOnce[0] = Boolean.TRUE.equals(prompt.get());
                actualSave.run();
            }
        }
    }

    private static class ThreadLocalSavePermissions {
        private final Map<Thread, Boolean> myPlainTextAllowed = Collections.synchronizedMap(new HashMap());

        private ThreadLocalSavePermissions() {
        }

        public void put(boolean value) {
            this.myPlainTextAllowed.put(Thread.currentThread(), value);
        }

        public boolean have() {
            return this.myPlainTextAllowed.containsKey(Thread.currentThread());
        }

        public void remove() {
            this.myPlainTextAllowed.remove(Thread.currentThread());
        }

        public boolean allowed() {
            return Boolean.TRUE.equals(this.myPlainTextAllowed.get(Thread.currentThread()));
        }
    }

    public class IdeaSVNHostOptionsProvider
    extends DefaultSVNHostOptionsProvider {
        public IdeaSVNHostOptionsProvider() {
            super(SvnAuthenticationManager.this.myConfigDirectory);
        }

        public SVNCompositeConfigFile getServersFile() {
            return super.getServersFile();
        }

        public ISVNHostOptions getHostOptions(SVNURL url) {
            return new IdeaSVNHostOptions(this.getServersFile(), url);
        }
    }

    private static class MySvnAuthenticationInteraction
    implements SvnAuthenticationInteraction {
        private Project myProject;

        private MySvnAuthenticationInteraction(Project project) {
            this.myProject = project;
        }

        @Override
        public void warnOnAuthStorageDisabled(SVNURL url) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)"Cannot store credentials: forbidden by \"store-auth-creds=no\"", (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
        }

        @Override
        public void warnOnPasswordStorageDisabled(SVNURL url) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)"Cannot store password: forbidden by \"store-passwords=no\"", (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
        }

        @Override
        public void warnOnSSLPassphraseStorageDisabled(SVNURL url) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)"Cannot store passphrase: forbidden by \"store-ssl-client-cert-pp=no\"", (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
        }

        @Override
        public boolean promptForPlaintextPasswordSaving(SVNURL url, String realm) {
            int answer = Messages.showYesNoDialog((Project)this.myProject, (String)String.format("Your password for authentication realm:\n%s\ncan only be stored to disk unencrypted. Would you like to store it in plaintext?", realm), (String)"Store the password in plaintext?", (Icon)Messages.getQuestionIcon());
            return answer == 0;
        }

        @Override
        public boolean promptInAwt() {
            return true;
        }

        @Override
        public boolean promptForSSLPlaintextPassphraseSaving(SVNURL url, String realm, File certificateFile, String certificateName) {
            int answer = Messages.showYesNoDialog((Project)this.myProject, (String)String.format("Your passphrase for " + certificateName + ":\n%s\ncan only be stored to disk unencrypted. Would you like to store it in plaintext?", certificateFile.getPath()), (String)"Store the passphrase in plaintext?", (Icon)Messages.getQuestionIcon());
            return answer == 0;
        }

        public void dispose() {
            this.myProject = null;
        }
    }

    private static class MySimpleProxyManager
    implements ISVNProxyManager {
        protected String myProxyHost;
        private final String myProxyPort;
        protected String myProxyUser;
        protected String myProxyPassword;

        public MySimpleProxyManager(String host, String port, String user, String password) {
            this.myProxyHost = host;
            this.myProxyPort = port == null ? "3128" : port;
            this.myProxyUser = user;
            this.myProxyPassword = password;
        }

        public String getProxyHost() {
            return this.myProxyHost;
        }

        public int getProxyPort() {
            try {
                return Integer.parseInt(this.myProxyPort);
            }
            catch (NumberFormatException numberFormatException) {
                return 3128;
            }
        }

        public String getProxyUserName() {
            return this.myProxyUser;
        }

        public String getProxyPassword() {
            return this.myProxyPassword;
        }

        public void acknowledgeProxyContext(boolean accepted, SVNErrorMessage errorMessage) {
        }
    }

    private static class MyPromptingProxyManager
    extends MySimpleProxyManager {
        private final String myProtocol;

        private MyPromptingProxyManager(String host, String port, String protocol) {
            super(host, port, null, null);
            this.myProtocol = protocol;
        }

        @Override
        public String getProxyUserName() {
            if (this.myProxyUser != null) {
                return this.myProxyUser;
            }
            this.tryGetCredentials();
            return this.myProxyUser;
        }

        private void tryGetCredentials() {
            try {
                InetAddress ia = InetAddress.getByName(this.getProxyHost());
                PasswordAuthentication authentication = Authenticator.requestPasswordAuthentication(this.getProxyHost(), ia, this.getProxyPort(), this.myProtocol, this.getProxyHost(), this.myProtocol, null, Authenticator.RequestorType.PROXY);
                if (authentication != null) {
                    this.myProxyUser = authentication.getUserName();
                    this.myProxyPassword = String.valueOf(authentication.getPassword());
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }

        @Override
        public String getProxyPassword() {
            if (this.myProxyPassword != null) {
                return this.myProxyPassword;
            }
            this.tryGetCredentials();
            return this.myProxyPassword;
        }
    }

    private class PersistentAuthenticationProviderProxy
    implements ISVNAuthenticationProvider,
    ISVNPersistentAuthenticationProvider {
        private final ISVNAuthenticationProvider myDelegate;
        private final ISVNGnomeKeyringPasswordProvider myISVNGnomeKeyringPasswordProvider;
        private final File myAuthDir;
        private Project myProject;
        private static final int maxAttempts = 10;

        private PersistentAuthenticationProviderProxy(File authDir, String userName) {
            this.myISVNGnomeKeyringPasswordProvider = new MyKeyringMasterKeyProvider(this.myProject);
            ISVNAuthenticationStorageOptions delegatingOptions = new ISVNAuthenticationStorageOptions(){

                public boolean isNonInteractive() throws SVNException {
                    return SvnAuthenticationManager.this.getAuthenticationStorageOptions().isNonInteractive();
                }

                public ISVNAuthStoreHandler getAuthStoreHandler() throws SVNException {
                    return SvnAuthenticationManager.this.getAuthenticationStorageOptions().getAuthStoreHandler();
                }

                public ISVNGnomeKeyringPasswordProvider getGnomeKeyringPasswordProvider() {
                    return PersistentAuthenticationProviderProxy.this.myISVNGnomeKeyringPasswordProvider;
                }

                public boolean isSSLPassphrasePromptSupported() {
                    return false;
                }
            };
            SvnAuthenticationManager.this.ensureListenerCreated();
            this.myDelegate = new DefaultSVNPersistentAuthenticationProvider(authDir, userName, delegatingOptions, SvnAuthenticationManager.this.getDefaultOptions(), (ISVNHostOptionsProvider)SvnAuthenticationManager.this.getHostOptionsProvider()){

                protected DefaultSVNPersistentAuthenticationProvider.IPasswordStorage[] createPasswordStorages(DefaultSVNOptions options) {
                    DefaultSVNPersistentAuthenticationProvider.IPasswordStorage[] passwordStorages = super.createPasswordStorages(options);
                    DefaultSVNPersistentAuthenticationProvider.IPasswordStorage[] proxied = new DefaultSVNPersistentAuthenticationProvider.IPasswordStorage[passwordStorages.length];
                    for (int i = 0; i < passwordStorages.length; ++i) {
                        DefaultSVNPersistentAuthenticationProvider.IPasswordStorage storage = passwordStorages[i];
                        proxied[i] = new ProxyPasswordStorageForDebug(storage, (EventDispatcher<SvnAuthenticationListener>)SvnAuthenticationManager.this.myListener);
                    }
                    return proxied;
                }
            };
            this.myAuthDir = authDir;
        }

        public void setProject(Project project) {
            this.myProject = project;
        }

        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            try {
                return (SVNAuthentication)SvnAuthenticationManager.this.wrapNativeCall(() -> {
                    SVNAuthentication svnAuthentication = this.myDelegate.requestClientAuthentication(kind, url, realm, errorMessage, previousAuth, authMayBeStored);
                    ((SvnAuthenticationListener)SvnAuthenticationManager.this.myListener.getMulticaster()).requested(ProviderType.persistent, url, realm, kind, svnAuthentication == null);
                    return svnAuthentication;
                });
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void actualSavePermissions(String realm, SVNAuthentication auth) {
            String actualKind = auth.getKind();
            File dir = new File(this.myAuthDir, actualKind);
            String fileName = SVNFileUtil.computeChecksum((String)realm);
            File authFile = new File(dir, fileName);
            try {
                ((ISVNPersistentAuthenticationProvider)this.myDelegate).saveAuthentication(auth, actualKind, realm);
            }
            catch (SVNException e) {
                if (this.myProject != null) {
                    ApplicationManager.getApplication().invokeLater((Runnable)new VcsBalloonProblemNotifier(this.myProject, "<b>Problem when storing Subversion credentials:</b>&nbsp;" + e.getMessage(), MessageType.ERROR));
                }
            }
            finally {
                this.setWriteable(authFile);
            }
        }

        public void saveAuthentication(SVNAuthentication auth, String kind, String realm) throws SVNException {
            try {
                SvnAuthenticationManager.this.wrapNativeCall(() -> {
                    Boolean fromInteractive = (Boolean)ourJustEntered.get();
                    ourJustEntered.set(null);
                    if (!SvnAuthenticationManager.this.myArtificialSaving && !Boolean.TRUE.equals(fromInteractive)) {
                        return null;
                    }
                    ((SvnAuthenticationListener)SvnAuthenticationManager.this.myListener.getMulticaster()).saveAttemptStarted(ProviderType.persistent, auth.getURL(), realm, auth.getKind());
                    ((ISVNPersistentAuthenticationProvider)this.myDelegate).saveAuthentication(auth, kind, realm);
                    ((SvnAuthenticationListener)SvnAuthenticationManager.this.myListener.getMulticaster()).saveAttemptFinished(ProviderType.persistent, auth.getURL(), realm, auth.getKind());
                    return null;
                });
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public void saveFingerprints(String realm, byte[] fingerprints) {
            try {
                SvnAuthenticationManager.this.wrapNativeCall(() -> {
                    ((ISVNPersistentAuthenticationProvider)this.myDelegate).saveFingerprints(realm, fingerprints);
                    return null;
                });
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public byte[] loadFingerprints(String realm) {
            try {
                return (byte[])SvnAuthenticationManager.this.wrapNativeCall(() -> ((ISVNPersistentAuthenticationProvider)this.myDelegate).loadFingerprints(realm));
            }
            catch (SVNException e) {
                LOG.info((Throwable)e);
                throw new RuntimeException(e);
            }
        }

        private void setWriteable(File file) {
            if (!file.exists()) {
                return;
            }
            if (file.getParentFile() == null) {
                return;
            }
            for (int i = 0; i < 10; ++i) {
                File parent = file.getParentFile();
                try {
                    File tempFile = FileUtil.createTempFile((File)parent, (String)"123", (String)"1", (boolean)true);
                    FileUtil.delete((File)tempFile);
                    if (!file.renameTo(tempFile) || !file.createNewFile()) continue;
                    FileUtil.copy((File)tempFile, (File)file);
                    FileUtil.delete((File)tempFile);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static interface ISVNAuthenticationProviderListener {
        public void requestClientAuthentication(String var1, SVNURL var2, String var3, SVNErrorMessage var4, SVNAuthentication var5, boolean var6, SVNAuthentication var7);

        public void acceptServerAuthentication(SVNURL var1, String var2, Object var3, boolean var4, int var5);
    }

    private class AuthenticationProviderProxy
    implements ISVNAuthenticationProvider {
        private final ISVNAuthenticationProvider myDelegate;

        private AuthenticationProviderProxy(ISVNAuthenticationProvider delegate) {
            this.myDelegate = delegate;
        }

        public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
            SVNAuthentication authentication = this.myDelegate.requestClientAuthentication(kind, url, realm, errorMessage, previousAuth, authMayBeStored);
            if (SvnAuthenticationManager.this.myProject != null && !SvnAuthenticationManager.this.myProject.isDisposed()) {
                ((ISVNAuthenticationProviderListener)SvnAuthenticationManager.this.myProject.getMessageBus().syncPublisher(AUTHENTICATION_PROVIDER_LISTENER)).requestClientAuthentication(kind, url, realm, errorMessage, previousAuth, authMayBeStored, authentication);
            }
            return authentication;
        }

        public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
            int result = this.myDelegate.acceptServerAuthentication(url, realm, certificate, resultMayBeStored);
            if (SvnAuthenticationManager.this.myProject != null && !SvnAuthenticationManager.this.myProject.isDisposed()) {
                ((ISVNAuthenticationProviderListener)SvnAuthenticationManager.this.myProject.getMessageBus().syncPublisher(AUTHENTICATION_PROVIDER_LISTENER)).acceptServerAuthentication(url, realm, certificate, resultMayBeStored, result);
            }
            return result;
        }
    }
}

