/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browser.MessageBoxCellRenderer;
import org.jetbrains.idea.svn.dialogs.browser.OpeningExpander;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class CopyOptionsDialog
extends DialogWrapper {
    private final SVNURL myURL;
    private CommitMessage myCommitMessage;
    private final Project myProject;
    private JTextField myNameField;
    private JLabel myURLLabel;
    private RepositoryBrowserComponent myBrowser;
    private JLabel myTargetURL;
    private BorderLayoutPanel myMainPanel;

    public CopyOptionsDialog(String title, Project project, RepositoryTreeNode root, RepositoryTreeNode node, boolean copy) {
        super(project, true);
        this.myProject = project;
        this.myURL = node.getURL();
        this.createUI();
        this.myTargetURL.setForeground(copy ? FileStatus.ADDED.getColor() : FileStatus.MODIFIED.getColor());
        this.setOKButtonText(copy ? "Copy" : "Move");
        this.myURLLabel.setText(this.myURL.toString());
        TreeNode[] path = node.getSelfPath();
        TreeNode[] subPath = new TreeNode[path.length - 1];
        System.arraycopy(path, 1, subPath, 0, path.length - 1);
        this.myBrowser.setRepositoryURL(root.getURL(), false, new OpeningExpander.Factory(subPath, node.getParent() instanceof RepositoryTreeNode ? (RepositoryTreeNode)node.getParent() : null));
        this.myBrowser.addChangeListener(e -> this.update());
        this.myNameField.setText(SVNPathUtil.tail((String)this.myURL.getPath()));
        this.myNameField.selectAll();
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CopyOptionsDialog.this.update();
            }
        });
        String lastMessage = VcsConfiguration.getInstance((Project)this.myProject).getLastNonEmptyCommitMessage();
        if (lastMessage != null) {
            this.myCommitMessage.setText(lastMessage);
            this.myCommitMessage.getEditorField().selectAll();
        }
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myBrowser);
        this.setTitle(title);
        this.init();
        this.update();
    }

    @NotNull
    public static ComboBox<String> configureRecentMessagesComponent(@NotNull Project project, @NotNull ComboBox<String> comboBox, @NotNull Consumer<String> messageConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/dialogs/browser/CopyOptionsDialog", "configureRecentMessagesComponent"));
        }
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "org/jetbrains/idea/svn/dialogs/browser/CopyOptionsDialog", "configureRecentMessagesComponent"));
        }
        if (messageConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageConsumer", "org/jetbrains/idea/svn/dialogs/browser/CopyOptionsDialog", "configureRecentMessagesComponent"));
        }
        ArrayList messages = VcsConfiguration.getInstance((Project)project).getRecentMessages();
        Collections.reverse(messages);
        CollectionComboBoxModel model = new CollectionComboBoxModel((List)messages);
        comboBox.setModel((ComboBoxModel)model);
        comboBox.setRenderer((ListCellRenderer)((Object)new MessageBoxCellRenderer()));
        comboBox.addActionListener(e -> {
            if (messageConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageConsumer", "org/jetbrains/idea/svn/dialogs/browser/CopyOptionsDialog", "lambda$configureRecentMessagesComponent$1"));
            }
            messageConsumer.accept((String)model.getSelected());
        });
        ComboBox<String> comboBox2 = comboBox;
        if (comboBox2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browser/CopyOptionsDialog", "configureRecentMessagesComponent"));
        }
        return comboBox2;
    }

    private void createUI() {
        this.myMainPanel = JBUI.Panels.simplePanel();
        this.myBrowser = new RepositoryBrowserComponent(SvnVcs.getInstance(this.myProject));
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RepositoryBrowserDialog.MkDirAction(this.myBrowser){

            @Override
            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setText("New Remote Folder...");
            }
        });
        group.add((AnAction)new RepositoryBrowserDialog.DeleteAction(this.myBrowser));
        group.add((AnAction)new RepositoryBrowserDialog.RefreshAction(this.myBrowser));
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group);
        final JPopupMenu component = popupMenu.getComponent();
        this.myBrowser.getRepositoryTree().addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                component.show(comp, x, y);
            }
        });
        Splitter splitter = new Splitter(true, 0.7f);
        splitter.setFirstComponent((JComponent)this.createBrowserPartWrapper());
        splitter.setSecondComponent((JComponent)this.createCommitMessageWrapper());
        this.myMainPanel.addToCenter((Component)splitter);
        ComboBox<String> messagesBox = CopyOptionsDialog.configureRecentMessagesComponent(this.myProject, (ComboBox<String>)new ComboBox(), message -> {
            if (message != null) {
                this.myCommitMessage.setText(message);
                this.myCommitMessage.getEditorField().selectAll();
            }
        });
        this.myMainPanel.addToBottom((Component)JBUI.Panels.simplePanel().addToTop((Component)new JLabel("Recent Messages:")).addToBottom(messagesBox).withBorder((Border)JBUI.Borders.emptyTop((int)4)));
    }

    @NotNull
    private JPanel createCommitMessageWrapper() {
        this.myCommitMessage = new CommitMessage(this.myProject, false, false, true);
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)this.myCommitMessage).addToTop((Component)new JLabel("Commit Message:"));
        if (borderLayoutPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browser/CopyOptionsDialog", "createCommitMessageWrapper"));
        }
        return borderLayoutPanel;
    }

    @NotNull
    private JPanel createBrowserPartWrapper() {
        JPanel wrapper = new JPanel(new GridBagLayout());
        GridBag gridBag = new GridBag().setDefaultAnchor(18).setDefaultFill(0).setDefaultInsets((Insets)JBUI.insets((int)1)).setDefaultWeightX(1.0).setDefaultWeightY(0.0);
        gridBag.nextLine().next().weightx(0.0);
        wrapper.add((Component)new JLabel("Source URL:"), gridBag);
        gridBag.next().fillCellHorizontally();
        this.myURLLabel = new JLabel();
        this.myURLLabel.setFont(this.myURLLabel.getFont().deriveFont(1));
        wrapper.add((Component)this.myURLLabel, gridBag);
        gridBag.nextLine().next().weightx(0.0).pady(4);
        wrapper.add((Component)new JLabel("Target Location:"), gridBag);
        gridBag.nextLine().next().fillCell().weighty(1.0).coverLine(2);
        wrapper.add((Component)this.myBrowser, gridBag);
        gridBag.nextLine().next().weightx(0.0).pady(4);
        wrapper.add((Component)new JLabel("Target Name:"), gridBag);
        gridBag.next().fillCellHorizontally();
        this.myNameField = new JTextField();
        wrapper.add((Component)this.myNameField, gridBag);
        gridBag.nextLine().next().weightx(0.0).pady(2);
        wrapper.add((Component)new JLabel("Target URL:"), gridBag);
        gridBag.next().fillCellHorizontally();
        this.myTargetURL = new JLabel();
        this.myTargetURL.setFont(this.myTargetURL.getFont().deriveFont(1));
        wrapper.add((Component)this.myTargetURL, gridBag);
        JPanel jPanel = wrapper;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browser/CopyOptionsDialog", "createBrowserPartWrapper"));
        }
        return jPanel;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.copy.options";
    }

    public String getCommitMessage() {
        return this.myCommitMessage.getComment();
    }

    public SVNURL getSourceURL() {
        return this.myURL;
    }

    public String getName() {
        return this.myNameField.getText();
    }

    @Nullable
    public SVNURL getTargetURL() {
        if (this.getOKAction().isEnabled()) {
            try {
                return SVNURL.parseURIEncoded((String)this.myTargetURL.getText());
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public RepositoryTreeNode getTargetParentNode() {
        return this.myBrowser.getSelectedNode();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void update() {
        RepositoryTreeNode baseNode = this.myBrowser.getSelectedNode();
        if (baseNode == null) {
            this.myTargetURL.setText("");
            this.getOKAction().setEnabled(false);
            return;
        }
        SVNURL baseURL = baseNode.getURL();
        String name = this.myNameField.getText();
        if (StringUtil.isEmpty((String)name)) {
            this.getOKAction().setEnabled(false);
            return;
        }
        try {
            baseURL = baseURL.appendPath(this.myNameField.getText(), false);
        }
        catch (SVNException e) {
            this.getOKAction().setEnabled(false);
            return;
        }
        this.myTargetURL.setText(baseURL.toString());
        this.getOKAction().setEnabled(!this.myURL.toString().equals(this.myTargetURL.getText()));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }
}

