/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.components.ServiceManager;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.Loader;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.RepositoryLoader;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

public class CacheLoader
extends Loader {
    @NotNull
    private final Loader myRepositoryLoader;

    public static Loader getInstance() {
        return (Loader)ServiceManager.getService(Loader.class);
    }

    public CacheLoader() {
        super(SvnRepositoryCache.getInstance());
        this.myRepositoryLoader = new RepositoryLoader(this.myCache);
    }

    @Override
    public void load(@NotNull RepositoryTreeNode node, @NotNull Expander expander) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/svn/dialogs/browserCache/CacheLoader", "load"));
        }
        if (expander == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expander", "org/jetbrains/idea/svn/dialogs/browserCache/CacheLoader", "load"));
        }
        SwingUtilities.invokeLater(() -> {
            String error;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/svn/dialogs/browserCache/CacheLoader", "lambda$load$0"));
            }
            if (expander == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expander", "org/jetbrains/idea/svn/dialogs/browserCache/CacheLoader", "lambda$load$0"));
            }
            String nodeUrl = node.getURL().toString();
            List<DirectoryEntry> cached = this.myCache.getChildren(nodeUrl);
            if (cached != null) {
                this.refreshNode(node, cached, expander);
            }
            if ((error = this.myCache.getError(nodeUrl)) != null) {
                this.refreshNodeError(node, error);
            }
            this.myRepositoryLoader.load(node, expander);
        });
    }

    @Override
    @NotNull
    protected NodeLoadState getNodeLoadState() {
        NodeLoadState nodeLoadState = NodeLoadState.CACHED;
        if (nodeLoadState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browserCache/CacheLoader", "getNodeLoadState"));
        }
        return nodeLoadState;
    }
}

