/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.ChangesBunch;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesAdapter;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.SwitchRevisionsProviderException;

public class LoadedRevisionsCache
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history.LoadedRevisionsCache");
    private final Project myProject;
    private final Map<String, Bunch> myMap;
    private final Object refreshLock = new Object();
    private long myRefreshTime;
    private final MessageBusConnection myConnection;

    public static LoadedRevisionsCache getInstance(Project project) {
        return (LoadedRevisionsCache)PeriodicalTasksCloser.getInstance().safeGetService(project, LoadedRevisionsCache.class);
    }

    private LoadedRevisionsCache(Project project) {
        this.myProject = project;
        this.myMap = ApplicationManager.getApplication().isUnitTestMode() ? new HashMap<String, Bunch>() : new SoftHashMap();
        this.myConnection = project.getMessageBus().connect();
        this.myConnection.subscribe(CommittedChangesCache.COMMITTED_TOPIC, (Object)new CommittedChangesAdapter(){

            public void changesLoaded(RepositoryLocation location, List<CommittedChangeList> changes) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    LoadedRevisionsCache.this.myMap.clear();
                    LoadedRevisionsCache.this.setRefreshTime(System.currentTimeMillis());
                });
            }
        });
        this.setRefreshTime(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRefreshTime() {
        Object object = this.refreshLock;
        synchronized (object) {
            return this.myRefreshTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRefreshTime(long refreshTime) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.myRefreshTime = refreshTime;
        }
    }

    private static void debugInfo(@NotNull List<CommittedChangeList> data, boolean consistentWithPrevious, Bunch bindTo) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/history/LoadedRevisionsCache", "debugInfo"));
        }
        LOG.debug(">>> cache internal >>> consistent: " + consistentWithPrevious + " bindTo: " + (Object)((Object)bindTo) + " oldest list: " + data.get(data.size() - 1).getNumber() + ", youngest list: " + data.get(0).getNumber());
    }

    public void dispose() {
        this.myConnection.disconnect();
        this.myMap.clear();
    }

    @NotNull
    private static List<List<CommittedChangeList>> split(List<CommittedChangeList> list, int size) {
        int listSize = list.size();
        if (listSize < size) {
            List<List<CommittedChangeList>> list2 = Collections.singletonList(list);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LoadedRevisionsCache", "split"));
            }
            return list2;
        }
        int first = listSize % size;
        int start = 0;
        int end = first == 0 ? Math.min(listSize, size) : first;
        ArrayList<List<CommittedChangeList>> result = new ArrayList<List<CommittedChangeList>>(listSize / size + 1);
        while (start < listSize) {
            result.add(list.subList(start, end));
            start = end;
            end += size;
        }
        ArrayList<List<CommittedChangeList>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/LoadedRevisionsCache", "split"));
        }
        return arrayList;
    }

    @Nullable
    public Bunch put(List<CommittedChangeList> data, boolean consistentWithPrevious, Bunch bindTo) {
        Bunch fromCache;
        if (data.isEmpty()) {
            return null;
        }
        SvnRepositoryLocation repositoryLocation = ((SvnChangeList)data.get(0)).getLocation();
        String location = repositoryLocation.getURL();
        List<List<CommittedChangeList>> list = LoadedRevisionsCache.split(data, 50);
        Bunch bindToBunch = bindTo;
        if (bindToBunch == null && (fromCache = this.myMap.get(location)) != null) {
            long passedSmallestNumber = data.get(data.size() - 1).getNumber();
            List cachedList = fromCache.getList();
            long greatestNumber = ((CommittedChangeList)cachedList.get(0)).getNumber();
            if (greatestNumber < passedSmallestNumber) {
                bindToBunch = fromCache;
            }
        }
        boolean consistent = consistentWithPrevious;
        for (int i = list.size() - 1; i >= 0; --i) {
            List<CommittedChangeList> changeLists = list.get(i);
            LoadedRevisionsCache.debugInfo(changeLists, consistent, bindToBunch);
            bindToBunch = new Bunch(changeLists, consistent, bindToBunch);
            consistent = true;
        }
        this.myMap.put(location, bindToBunch);
        return bindToBunch;
    }

    @Nullable
    public Iterator<ChangesBunch> iterator(String location) {
        Bunch bunch = this.myMap.get(location);
        if (bunch == null) {
            return null;
        }
        return new BunchIterator(bunch);
    }

    public static class Bunch
    extends ChangesBunch {
        private final Bunch myNext;

        private Bunch(List<CommittedChangeList> list, boolean consistent, Bunch next) {
            super(list, consistent);
            this.myNext = next;
        }

        public Bunch getNext() {
            return this.myNext;
        }
    }

    private class BunchIterator
    implements Iterator<ChangesBunch> {
        private final long myCreationTime;
        private Bunch myBunch;

        private BunchIterator(Bunch bunch) {
            this.myBunch = bunch;
            this.myCreationTime = System.currentTimeMillis();
        }

        private void checkValidity() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myCreationTime <= LoadedRevisionsCache.this.getRefreshTime()) {
                throw new SwitchRevisionsProviderException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkValidity();
            return this.myBunch != null;
        }

        @Override
        public ChangesBunch next() {
            this.checkValidity();
            Bunch current = this.myBunch;
            this.myBunch = this.myBunch.myNext;
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

