/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnEditCommitMessageAction;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;

public class SvnEditCommitMessageFromFileHistoryAction
extends AnAction {
    public SvnEditCommitMessageFromFileHistoryAction() {
        super("Edit Revision Comment", "Edit revision comment. Previous message is rewritten.", AllIcons.Actions.Edit);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        VcsKey vcsKey = (VcsKey)e.getData(VcsDataKeys.VCS);
        if (vcsKey == null || !SvnVcs.getKey().equals((Object)vcsKey)) {
            return;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        VirtualFile revisionVirtualFile = (VirtualFile)e.getData(VcsDataKeys.VCS_VIRTUAL_FILE);
        if (revision == null || revisionVirtualFile == null) {
            return;
        }
        SvnFileRevision svnFileRevision = (SvnFileRevision)revision;
        Consumer listener = (Consumer)VcsDataKeys.REMOTE_HISTORY_CHANGED_LISTENER.getData(e.getDataContext());
        SvnEditCommitMessageAction.askAndEditRevision(svnFileRevision.getRevision().getNumber(), svnFileRevision.getCommitMessage(), (SvnRepositoryLocation)svnFileRevision.getChangedRepositoryPath(), project, (Consumer<String>)((Consumer)newMessage -> {
            svnFileRevision.setCommitMessage((String)newMessage);
            if (listener != null) {
                listener.consume(newMessage);
            }
            ProjectLevelVcsManager.getInstance((Project)project).getVcsHistoryCache().editCached(VcsUtil.getFilePath((VirtualFile)revisionVirtualFile), vcsKey, revisions -> {
                for (VcsFileRevision fileRevision : revisions) {
                    if (!(fileRevision instanceof SvnFileRevision) || ((SvnFileRevision)fileRevision).getRevision().getNumber() != svnFileRevision.getRevision().getNumber()) continue;
                    ((SvnFileRevision)fileRevision).setCommitMessage((String)newMessage);
                    break;
                }
            });
        }), true);
    }

    public void update(AnActionEvent e) {
        VcsKey vcsKey = (VcsKey)e.getData(VcsDataKeys.VCS);
        boolean isSvn = SvnVcs.getKey().equals((Object)vcsKey);
        e.getPresentation().setVisible(isSvn);
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        e.getPresentation().setEnabled(isSvn && revision != null);
    }
}

