/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.OneShotMergeInfoHelper;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeCalculatorTask
extends BaseMergeTask {
    public static final String PROP_BUNCH_SIZE = "idea.svn.quick.merge.bunch.size";
    private static final int BUNCH_SIZE = 100;
    @Nullable
    private final SvnBranchPointsCalculator.WrapperInvertor myCopyPoint;
    @NotNull
    private final OneShotMergeInfoHelper myMergeChecker;
    @NotNull
    private final List<SvnChangeList> myChangeLists;
    @NotNull
    private final Consumer<MergeCalculatorTask> myCallback;
    private boolean myAllListsLoaded;

    public MergeCalculatorTask(@NotNull QuickMerge mergeProcess, @Nullable SvnBranchPointsCalculator.WrapperInvertor copyPoint, @NotNull Consumer<MergeCalculatorTask> callback) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "<init>"));
        }
        super(mergeProcess);
        this.myCopyPoint = copyPoint;
        this.myCallback = callback;
        this.myChangeLists = ContainerUtil.newArrayList();
        this.myMergeChecker = new OneShotMergeInfoHelper(this.myMergeContext);
    }

    public boolean areAllListsLoaded() {
        return this.myAllListsLoaded;
    }

    @NotNull
    public MergeChecker getMergeChecker() {
        OneShotMergeInfoHelper oneShotMergeInfoHelper = this.myMergeChecker;
        if (oneShotMergeInfoHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getMergeChecker"));
        }
        return oneShotMergeInfoHelper;
    }

    @NotNull
    public List<SvnChangeList> getChangeLists() {
        List<SvnChangeList> list = this.myChangeLists;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getChangeLists"));
        }
        return list;
    }

    @Override
    public void run() throws VcsException {
        ProgressManager.progress((String)"Collecting merge information");
        this.myMergeChecker.prepare();
        if (this.myCopyPoint != null) {
            this.myChangeLists.addAll(this.getNotMergedChangeLists(this.getChangeListsAfter(this.myCopyPoint.getTrue().getTargetRevision())));
            this.myAllListsLoaded = true;
        } else {
            Pair<List<SvnChangeList>, Boolean> loadResult = MergeCalculatorTask.loadChangeLists(this.myMergeContext, -1L, MergeCalculatorTask.getBunchSize(-1));
            this.myChangeLists.addAll((Collection)loadResult.first);
            this.myAllListsLoaded = (Boolean)loadResult.second;
        }
        if (!this.myChangeLists.isEmpty()) {
            this.myCallback.consume((Object)this);
        } else {
            this.myMergeProcess.end("Everything is up-to-date", false);
        }
    }

    @NotNull
    private List<Pair<SvnChangeList, LogHierarchyNode>> getChangeListsAfter(long revision) throws VcsException {
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        settings.CHANGE_AFTER = Long.toString(revision);
        settings.USE_CHANGE_AFTER_FILTER = true;
        List<Pair<SvnChangeList, LogHierarchyNode>> list = MergeCalculatorTask.getChangeLists(this.myMergeContext, settings, revision, -1, Pair::create);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getChangeListsAfter"));
        }
        return list;
    }

    @NotNull
    private List<SvnChangeList> getNotMergedChangeLists(@NotNull List<Pair<SvnChangeList, LogHierarchyNode>> changeLists) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        ProgressManager.progress((String)"Collecting not merged revisions");
        for (Pair<SvnChangeList, LogHierarchyNode> pair : changeLists) {
            SvnChangeList changeList = (SvnChangeList)pair.getFirst();
            ProgressManager.progress2((String)SvnBundle.message("progress.text2.processing.revision", changeList.getNumber()));
            if (!SvnMergeInfoCache.MergeCheckResult.NOT_MERGED.equals((Object)this.myMergeChecker.checkList(changeList)) || this.myMergeChecker.checkListForPaths((LogHierarchyNode)pair.getSecond())) continue;
            result.add(changeList);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Pair<List<SvnChangeList>, Boolean> loadChangeLists(@NotNull MergeContext mergeContext, long beforeRevision, int n) throws VcsException {
        void size;
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "loadChangeLists"));
        }
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        if (beforeRevision > 0L) {
            settings.CHANGE_BEFORE = String.valueOf(beforeRevision);
            settings.USE_CHANGE_BEFORE_FILTER = true;
        }
        List changeLists = MergeCalculatorTask.getChangeLists(mergeContext, settings, beforeRevision, (int)size, (changeList, tree) -> changeList);
        Pair pair = Pair.create(changeLists.subList(0, Math.min((int)size, changeLists.size())), (Object)(changeLists.size() < size + true ? 1 : 0));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "loadChangeLists"));
        }
        return pair;
    }

    public static int getBunchSize(int size) {
        Integer configuredSize = Integer.getInteger(PROP_BUNCH_SIZE);
        return configuredSize != null ? configuredSize : (size > 0 ? size : 100);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static <T> List<T> getChangeLists(@NotNull MergeContext mergeContext, @NotNull ChangeBrowserSettings settings, long revisionToExclude, int size, @NotNull PairFunction<SvnChangeList, LogHierarchyNode, T> pairFunction) throws VcsException {
        void resultProvider;
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getChangeLists"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getChangeLists"));
        }
        if (pairFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultProvider", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getChangeLists"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        ((SvnCommittedChangesProvider)mergeContext.getVcs().getCommittedChangesProvider()).getCommittedChangesWithMergedRevisons(settings, new SvnRepositoryLocation(mergeContext.getSourceUrl()), size > 0 ? size + (revisionToExclude > 0L ? 2 : 1) : 0, (PairConsumer<SvnChangeList, LogHierarchyNode>)((PairConsumer)(arg_0, arg_1) -> MergeCalculatorTask.lambda$getChangeLists$1(revisionToExclude, result, (PairFunction)resultProvider, arg_0, arg_1)));
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getChangeLists"));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$getChangeLists$1(long revisionToExclude, List result, @NotNull PairFunction resultProvider, SvnChangeList changeList, LogHierarchyNode logHierarchyNode) {
        if (resultProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultProvider", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "lambda$getChangeLists$1"));
        }
        if (revisionToExclude != changeList.getNumber()) {
            void tree;
            result.add(resultProvider.fun((Object)changeList, (Object)tree));
        }
    }
}

