/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class MergeContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myBranchName;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final WCInfo myWcInfo;
    @NotNull
    private final String mySourceUrl;
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myRepositoryRelativeSourcePath;
    @NotNull
    private final String myRepositoryRelativeWorkingCopyPath;

    public MergeContext(@NotNull SvnVcs vcs, @NotNull String sourceUrl, @NotNull WCInfo wcInfo, @NotNull String branchName, @NotNull VirtualFile root) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/integrate/MergeContext", "<init>"));
        }
        if (sourceUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceUrl", "org/jetbrains/idea/svn/integrate/MergeContext", "<init>"));
        }
        if (wcInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wcInfo", "org/jetbrains/idea/svn/integrate/MergeContext", "<init>"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "org/jetbrains/idea/svn/integrate/MergeContext", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/integrate/MergeContext", "<init>"));
        }
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myBranchName = branchName;
        this.myRoot = root;
        this.mySourceUrl = sourceUrl;
        this.myWcInfo = wcInfo;
        this.myTitle = "Merge from " + this.myBranchName;
        this.myRepositoryRelativeSourcePath = SvnUtil.ensureStartSlash(SVNPathUtil.getRelativePath((String)this.myWcInfo.getRepositoryRoot(), (String)this.mySourceUrl));
        this.myRepositoryRelativeWorkingCopyPath = SvnUtil.ensureStartSlash(SVNPathUtil.getRelativePath((String)this.myWcInfo.getRepositoryRoot(), (String)this.myWcInfo.getRootUrl()));
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeContext", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getBranchName() {
        String string = this.myBranchName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeContext", "getBranchName"));
        }
        return string;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeContext", "getRoot"));
        }
        return virtualFile;
    }

    @NotNull
    public WCInfo getWcInfo() {
        WCInfo wCInfo = this.myWcInfo;
        if (wCInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeContext", "getWcInfo"));
        }
        return wCInfo;
    }

    @NotNull
    public String getSourceUrl() {
        String string = this.mySourceUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeContext", "getSourceUrl"));
        }
        return string;
    }

    @NotNull
    public String getRepositoryRelativeSourcePath() {
        String string = this.myRepositoryRelativeSourcePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeContext", "getRepositoryRelativeSourcePath"));
        }
        return string;
    }

    @NotNull
    public String getRepositoryRelativeWorkingCopyPath() {
        String string = this.myRepositoryRelativeWorkingCopyPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeContext", "getRepositoryRelativeWorkingCopyPath"));
        }
        return string;
    }

    @NotNull
    public SvnVcs getVcs() {
        SvnVcs svnVcs = this.myVcs;
        if (svnVcs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeContext", "getVcs"));
        }
        return svnVcs;
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeContext", "getTitle"));
        }
        return string;
    }
}

