/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnMergeInfoRootPanelManual;
import org.jetbrains.idea.svn.mergeinfo.ListMergeStatus;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeInfoHolder {
    @NotNull
    private final DecoratorManager myManager;
    @NotNull
    private final SvnMergeInfoCache myMergeInfoCache;
    @NotNull
    private final RootsAndBranches myMainPanel;
    @NotNull
    private final SvnMergeInfoRootPanelManual myPanel;
    @NotNull
    private final Map<Couple<String>, MergeInfoCached> myCachedMap;

    public MergeInfoHolder(@NotNull Project project, @NotNull DecoratorManager manager, @NotNull RootsAndBranches mainPanel, @NotNull SvnMergeInfoRootPanelManual panel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "<init>"));
        }
        if (mainPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainPanel", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "<init>"));
        }
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "<init>"));
        }
        this.myManager = manager;
        this.myMainPanel = mainPanel;
        this.myPanel = panel;
        this.myMergeInfoCache = SvnMergeInfoCache.getInstance(project);
        this.myCachedMap = ContainerUtil.newHashMap();
    }

    @Nullable
    private MergeInfoCached getCurrentCache() {
        return this.myCachedMap.get(MergeInfoHolder.createKey(this.myPanel.getWcInfo(), this.myPanel.getBranch()));
    }

    private boolean isEnabledAndConfigured(boolean ignoreEnabled) {
        return (ignoreEnabled || this.myMainPanel.isHighlightingOn() && this.myPanel.isEnabled()) && this.myPanel.getBranch() != null && this.myPanel.getLocalBranch() != null;
    }

    public boolean refreshEnabled(boolean ignoreEnabled) {
        return this.isEnabledAndConfigured(ignoreEnabled) && this.getCurrentCache() == null;
    }

    @NotNull
    private static Couple<String> createKey(@NotNull WCInfoWithBranches root, @NotNull WCInfoWithBranches.Branch branch) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "createKey"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "createKey"));
        }
        Couple couple = Couple.of((Object)root.getPath(), (Object)branch.getUrl());
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "createKey"));
        }
        return couple;
    }

    @NotNull
    public ListMergeStatus refresh(boolean ignoreEnabled) {
        CommittedChangeListsListener refresher = this.createRefresher(ignoreEnabled);
        if (refresher != null) {
            this.myManager.reportLoadedLists(refresher);
        }
        this.myManager.repaintTree();
        ListMergeStatus listMergeStatus = ListMergeStatus.REFRESHING;
        if (listMergeStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "refresh"));
        }
        return listMergeStatus;
    }

    @Nullable
    public CommittedChangeListsListener createRefresher(boolean ignoreEnabled) {
        MyRefresher result = null;
        if (this.refreshEnabled(ignoreEnabled)) {
            MergeInfoCached state = this.myMergeInfoCache.getCachedState(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            this.myCachedMap.put(MergeInfoHolder.createKey(this.myPanel.getWcInfo(), this.myPanel.getBranch()), state != null ? state.copy() : new MergeInfoCached());
            this.myMergeInfoCache.clear(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            result = new MyRefresher();
        }
        return result;
    }

    @NotNull
    public ListMergeStatus check(CommittedChangeList list, boolean ignoreEnabled) {
        ListMergeStatus result;
        if (!this.isEnabledAndConfigured(ignoreEnabled) || !(list instanceof SvnChangeList)) {
            result = ListMergeStatus.ALIEN;
        } else {
            MergeInfoCached cachedState = this.getCurrentCache();
            MergeInfoCached state = this.myMergeInfoCache.getCachedState(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch());
            result = cachedState != null ? this.check(list, cachedState, true) : (state != null ? this.check(list, state, false) : this.refresh(ignoreEnabled));
        }
        ListMergeStatus listMergeStatus = result;
        if (listMergeStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "check"));
        }
        return listMergeStatus;
    }

    @NotNull
    public ListMergeStatus check(@NotNull CommittedChangeList list, @NotNull MergeInfoCached state, boolean isCached) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "check"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "check"));
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = state.getMap().get(list.getNumber());
        ListMergeStatus result = state.copiedAfter(list) ? ListMergeStatus.COMMON : ListMergeStatus.from(mergeCheckResult);
        ListMergeStatus listMergeStatus = (ListMergeStatus)((Object)ObjectUtils.notNull((Object)((Object)result), (Object)((Object)(isCached ? ListMergeStatus.REFRESHING : ListMergeStatus.ALIEN))));
        if (listMergeStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/MergeInfoHolder", "check"));
        }
        return listMergeStatus;
    }

    public void updateMixedRevisionsForPanel() {
        this.myPanel.setMixedRevisions(this.myMergeInfoCache.isMixedRevisions(this.myPanel.getWcInfo(), this.myPanel.getLocalBranch()));
    }

    private class MyRefresher
    implements CommittedChangeListsListener {
        @NotNull
        private final WCInfoWithBranches myRefreshedRoot;
        private final WCInfoWithBranches.Branch myRefreshedBranch;
        private final String myBranchPath;

        private MyRefresher() {
            this.myRefreshedRoot = MergeInfoHolder.this.myPanel.getWcInfo();
            this.myRefreshedBranch = MergeInfoHolder.this.myPanel.getBranch();
            this.myBranchPath = MergeInfoHolder.this.myPanel.getLocalBranch();
        }

        public void onBeforeStartReport() {
        }

        public boolean report(CommittedChangeList list) {
            if (list instanceof SvnChangeList) {
                SvnMergeInfoCache.MergeCheckResult checkState = MergeInfoHolder.this.myMergeInfoCache.getState(this.myRefreshedRoot, (SvnChangeList)list, this.myRefreshedBranch, this.myBranchPath);
                long number = list.getNumber();
                ApplicationManager.getApplication().invokeLater(() -> {
                    MergeInfoCached cachedState = (MergeInfoCached)MergeInfoHolder.this.myCachedMap.get(MergeInfoHolder.createKey(this.myRefreshedRoot, this.myRefreshedBranch));
                    if (cachedState != null) {
                        cachedState.getMap().put(number, checkState);
                    }
                    MergeInfoHolder.this.myManager.repaintTree();
                });
            }
            return true;
        }

        public void onAfterEndReport() {
            ApplicationManager.getApplication().invokeLater(() -> {
                MergeInfoHolder.this.myCachedMap.remove(MergeInfoHolder.createKey(this.myRefreshedRoot, this.myRefreshedBranch));
                MergeInfoHolder.this.updateMixedRevisionsForPanel();
                MergeInfoHolder.this.myManager.repaintTree();
            });
        }
    }
}

