/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.openapi.util.Getter;
import java.io.File;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.lock.Lock;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class PortableStatus
extends Status {
    private boolean myConflicted;
    private Getter<Info> myInfoGetter;
    private Info myInfo;
    private String myPath;
    private boolean myFileExists;

    public PortableStatus(SVNURL url, File file, @NotNull NodeKind kind, SVNRevision revision, SVNRevision committedRevision, Date committedDate, String author, StatusType contentsStatus, StatusType propertiesStatus, StatusType remoteContentsStatus, StatusType remotePropertiesStatus, boolean isLocked, boolean isCopied, boolean isSwitched, boolean isFileExternal, @Nullable Lock remoteLock, @Nullable Lock localLock, Map entryProperties, String changelistName, int wcFormatVersion, boolean isConflicted, Getter<Info> infoGetter) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/idea/svn/status/PortableStatus", "<init>"));
        }
        super(url, file, kind, revision, committedRevision, contentsStatus, propertiesStatus, remoteContentsStatus, remotePropertiesStatus, isLocked, isCopied, isSwitched, null, remoteLock, localLock, changelistName, null);
        this.myConflicted = isConflicted;
        this.myInfoGetter = infoGetter == null ? () -> null : infoGetter;
    }

    public PortableStatus() {
        this.myInfoGetter = () -> null;
        this.setCommittedRevision(SVNRevision.UNDEFINED);
    }

    @Override
    public void setIsConflicted(boolean isConflicted) {
        this.myConflicted = isConflicted;
        super.setIsConflicted(isConflicted);
    }

    public void setInfoGetter(Getter<Info> infoGetter) {
        this.myInfoGetter = infoGetter;
    }

    @Override
    public boolean isConflicted() {
        return this.myConflicted;
    }

    private Info initInfo() {
        if (this.myInfo == null) {
            StatusType contentsStatus = this.getContentsStatus();
            if (contentsStatus == null || StatusType.UNKNOWN.equals((Object)contentsStatus)) {
                return null;
            }
            this.myInfo = (Info)this.myInfoGetter.get();
        }
        return this.myInfo;
    }

    public Info getInfo() {
        return this.initInfo();
    }

    @Override
    @NotNull
    public NodeKind getKind() {
        if (this.myFileExists) {
            NodeKind nodeKind = super.getKind();
            if (nodeKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/status/PortableStatus", "getKind"));
            }
            return nodeKind;
        }
        Info info = this.initInfo();
        if (info != null) {
            NodeKind nodeKind = info.getKind();
            if (nodeKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/status/PortableStatus", "getKind"));
            }
            return nodeKind;
        }
        NodeKind nodeKind = super.getKind();
        if (nodeKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/status/PortableStatus", "getKind"));
        }
        return nodeKind;
    }

    @Override
    public String getCopyFromURL() {
        if (!this.isCopied()) {
            return null;
        }
        Info info = this.initInfo();
        if (info == null) {
            return null;
        }
        SVNURL url = this.initInfo().getCopyFromURL();
        return url == null ? null : url.toString();
    }

    @Override
    public SVNURL getURL() {
        SVNURL url = super.getURL();
        if (url == null) {
            Info info = this.initInfo();
            url = info != null ? info.getURL() : url;
        }
        return url;
    }

    @Override
    public SVNURL getRepositoryRootURL() {
        SVNURL url = super.getRepositoryRootURL();
        if (url == null) {
            Info info = this.initInfo();
            url = info != null ? info.getRepositoryRootURL() : url;
        }
        return url;
    }

    @Override
    public File getFile() {
        File file = super.getFile();
        if (file == null) {
            Info info = this.initInfo();
            file = info != null ? info.getFile() : file;
        }
        return file;
    }

    @Override
    @NotNull
    public SVNRevision getRevision() {
        SVNRevision revision = super.getRevision();
        if (revision.isValid()) {
            SVNRevision sVNRevision = revision;
            if (sVNRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/status/PortableStatus", "getRevision"));
            }
            return sVNRevision;
        }
        StatusType status = this.getContentsStatus();
        if (StatusType.STATUS_NONE.equals((Object)status) || StatusType.STATUS_UNVERSIONED.equals((Object)status) || StatusType.STATUS_ADDED.equals((Object)status)) {
            SVNRevision sVNRevision = revision;
            if (sVNRevision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/status/PortableStatus", "getRevision"));
            }
            return sVNRevision;
        }
        Info info = this.initInfo();
        SVNRevision sVNRevision = info == null ? revision : info.getRevision();
        if (sVNRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/status/PortableStatus", "getRevision"));
        }
        return sVNRevision;
    }

    @Override
    @Nullable
    public TreeConflictDescription getTreeConflict() {
        if (!this.isConflicted()) {
            return null;
        }
        Info info = this.initInfo();
        return info == null ? null : info.getTreeConflict();
    }

    public void setPath(String path) {
        this.myPath = path;
    }

    public String getPath() {
        return this.myPath;
    }

    public void setKind(boolean exists, @NotNull NodeKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/idea/svn/status/PortableStatus", "setKind"));
        }
        this.myFileExists = exists;
        this.setKind(kind);
    }
}

