/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.BatchOutputEventListener;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.text.AbstractLineChoppingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;

public class StyledTextOutputBackedRenderer
extends BatchOutputEventListener {
    private final OutputEventTextOutputImpl textOutput;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private boolean debugOutput;
    private RenderableOutputEvent lastEvent;

    public StyledTextOutputBackedRenderer(StyledTextOutput textOutput) {
        this.textOutput = new OutputEventTextOutputImpl(textOutput);
    }

    public void onOutput(OutputEvent event) {
        if (event instanceof LogLevelChangeEvent) {
            LogLevelChangeEvent changeEvent = (LogLevelChangeEvent)event;
            boolean bl = this.debugOutput = changeEvent.getNewLogLevel() == LogLevel.DEBUG;
        }
        if (event instanceof RenderableOutputEvent) {
            RenderableOutputEvent outputEvent = (RenderableOutputEvent)event;
            this.textOutput.style(outputEvent.getLogLevel() == LogLevel.ERROR ? StyledTextOutput.Style.Error : StyledTextOutput.Style.Normal);
            if (this.debugOutput && (this.textOutput.atEndOfLine || this.lastEvent == null || !this.lastEvent.getCategory().equals(outputEvent.getCategory()))) {
                if (!this.textOutput.atEndOfLine) {
                    this.textOutput.println();
                }
                this.textOutput.text(this.dateFormat.format(new Date(outputEvent.getTimestamp())));
                this.textOutput.text(" [");
                this.textOutput.text((Object)outputEvent.getLogLevel());
                this.textOutput.text("] [");
                this.textOutput.text(outputEvent.getCategory());
                this.textOutput.text("] ");
            }
            outputEvent.render(this.textOutput);
            this.lastEvent = outputEvent;
            this.textOutput.style(StyledTextOutput.Style.Normal);
        }
    }

    private class OutputEventTextOutputImpl
    extends AbstractLineChoppingStyledTextOutput {
        private final StyledTextOutput textOutput;
        private boolean atEndOfLine = true;

        public OutputEventTextOutputImpl(StyledTextOutput textOutput) {
            this.textOutput = textOutput;
        }

        protected void doStyleChange(StyledTextOutput.Style style) {
            this.textOutput.style(style);
        }

        protected void doLineText(CharSequence text) {
            this.textOutput.text(text);
            this.atEndOfLine = false;
        }

        protected void doEndLine(CharSequence endOfLine) {
            this.textOutput.text(endOfLine);
            this.atEndOfLine = true;
        }
    }
}

