/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.logging.config.LoggingRouter;
import org.gradle.internal.logging.config.LoggingSystem;
import org.gradle.internal.logging.console.AnsiConsole;
import org.gradle.internal.logging.console.BuildStatusRenderer;
import org.gradle.internal.logging.console.ColorMap;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.console.ConsoleLayoutCalculator;
import org.gradle.internal.logging.console.DefaultColorMap;
import org.gradle.internal.logging.console.DefaultWorkInProgressFormatter;
import org.gradle.internal.logging.console.StyledTextOutputBackedRenderer;
import org.gradle.internal.logging.console.ThrottlingOutputEventListener;
import org.gradle.internal.logging.console.WorkInProgressRenderer;
import org.gradle.internal.logging.events.BatchOutputEventListener;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.MaxWorkerCountChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.sink.ConsoleConfigureAction;
import org.gradle.internal.logging.sink.ProgressLogEventGenerator;
import org.gradle.internal.logging.text.StreamBackedStandardOutputListener;
import org.gradle.internal.logging.text.StreamingStyledTextOutput;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.FallbackConsoleMetaData;
import org.gradle.internal.time.TimeProvider;
import org.gradle.internal.time.TrueTimeProvider;

@ThreadSafe
public class OutputEventRenderer
implements OutputEventListener,
LoggingRouter {
    private final ListenerBroadcast<OutputEventListener> formatters = new ListenerBroadcast(OutputEventListener.class);
    private final ListenerBroadcast<StandardOutputListener> stdoutListeners = new ListenerBroadcast(StandardOutputListener.class);
    private final ListenerBroadcast<StandardOutputListener> stderrListeners = new ListenerBroadcast(StandardOutputListener.class);
    private final Object lock = new Object();
    private final DefaultColorMap colourMap = new DefaultColorMap();
    private LogLevel logLevel = LogLevel.LIFECYCLE;
    private int maxWorkerCount;
    private final ConsoleConfigureAction consoleConfigureAction;
    private OutputStream originalStdOut;
    private OutputStream originalStdErr;
    private StreamBackedStandardOutputListener stdOutListener;
    private StreamBackedStandardOutputListener stdErrListener;
    private OutputEventListener console;

    public OutputEventRenderer() {
        OutputEventListener stdOutChain = this.onNonError(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput((StandardOutputListener)this.stdoutListeners.getSource())), false));
        this.formatters.add((Object)stdOutChain);
        OutputEventListener stdErrChain = this.onError(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(new StreamingStyledTextOutput((StandardOutputListener)this.stderrListeners.getSource())), false));
        this.formatters.add((Object)stdErrChain);
        this.consoleConfigureAction = new ConsoleConfigureAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingSystem.Snapshot snapshot() {
        Object object = this.lock;
        synchronized (object) {
            return new SnapshotImpl(this.logLevel, this.console, this.maxWorkerCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(LoggingSystem.Snapshot state) {
        Object object = this.lock;
        synchronized (object) {
            SnapshotImpl snapshot = (SnapshotImpl)state;
            if (snapshot.logLevel != this.logLevel) {
                this.configure(snapshot.logLevel);
            }
            if (snapshot.maxWorkerCount != this.maxWorkerCount) {
                this.configureMaxWorkerCount(snapshot.maxWorkerCount);
            }
            if (snapshot.console != this.console) {
                if (snapshot.console == null) {
                    this.formatters.remove((Object)this.console);
                    this.console.onOutput(new EndOutputEvent());
                    this.console = null;
                } else {
                    throw new UnsupportedOperationException("Cannot restore previous console. This is not implemented yet.");
                }
            }
        }
    }

    public ColorMap getColourMap() {
        return this.colourMap;
    }

    public OutputStream getOriginalStdOut() {
        return this.originalStdOut;
    }

    public OutputStream getOriginalStdErr() {
        return this.originalStdErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachProcessConsole(ConsoleOutput consoleOutput) {
        Object object = this.lock;
        synchronized (object) {
            this.consoleConfigureAction.execute(this, consoleOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachAnsiConsole(OutputStream outputStream) {
        Object object = this.lock;
        synchronized (object) {
            FallbackConsoleMetaData consoleMetaData = new FallbackConsoleMetaData();
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            AnsiConsole console = new AnsiConsole((Appendable)writer, (Flushable)writer, (ColorMap)this.colourMap, (ConsoleMetaData)consoleMetaData, true);
            this.addConsole(console, true, true, (ConsoleMetaData)consoleMetaData);
        }
    }

    public void attachSystemOutAndErr() {
        this.addStandardOutputListener();
        this.addStandardErrorListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStandardOutputListener() {
        Object object = this.lock;
        synchronized (object) {
            this.originalStdOut = System.out;
            if (this.stdOutListener != null) {
                this.stdoutListeners.remove((Object)this.stdOutListener);
            }
            this.stdOutListener = new StreamBackedStandardOutputListener(System.out);
            this.addStandardOutputListener(this.stdOutListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStandardErrorListener() {
        Object object = this.lock;
        synchronized (object) {
            this.originalStdErr = System.err;
            if (this.stdErrListener != null) {
                this.stderrListeners.remove((Object)this.stdErrListener);
            }
            this.stdErrListener = new StreamBackedStandardOutputListener(System.err);
            this.addStandardErrorListener(this.stdErrListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStandardOutputListener() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stdOutListener != null) {
                this.stdoutListeners.remove((Object)this.stdOutListener);
                this.stdOutListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStandardErrorListener() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stdErrListener != null) {
                this.stderrListeners.remove((Object)this.stdErrListener);
                this.stdErrListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputEventListener(OutputEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.formatters.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputEventListener(OutputEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.formatters.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputEventRenderer addConsole(Console console, boolean stdout, boolean stderr, ConsoleMetaData consoleMetaData) {
        ThrottlingOutputEventListener consoleChain = new ThrottlingOutputEventListener(new BuildStatusRenderer(new WorkInProgressRenderer(new ProgressLogEventGenerator(new StyledTextOutputBackedRenderer(console.getBuildOutputArea()), true), console.getBuildProgressArea(), new DefaultWorkInProgressFormatter(consoleMetaData), new ConsoleLayoutCalculator(consoleMetaData)), console.getStatusBar(), console, consoleMetaData), (TimeProvider)new TrueTimeProvider());
        Object object = this.lock;
        synchronized (object) {
            if (stdout && stderr) {
                this.console = consoleChain;
                this.removeStandardOutputListener();
                this.removeStandardErrorListener();
            } else if (stdout) {
                this.console = this.onNonError(consoleChain);
                this.removeStandardOutputListener();
            } else {
                this.console = this.onError(consoleChain);
                this.removeStandardErrorListener();
            }
            consoleChain.onOutput(new LogLevelChangeEvent(this.logLevel));
            consoleChain.onOutput(new MaxWorkerCountChangeEvent(this.maxWorkerCount));
            this.formatters.add((Object)this.console);
        }
        return this;
    }

    private OutputEventListener onError(final OutputEventListener listener) {
        return new BatchOutputEventListener(){

            public void onOutput(OutputEvent event) {
                if (event.getLogLevel() == LogLevel.ERROR || event.getLogLevel() == null) {
                    listener.onOutput(event);
                }
            }
        };
    }

    private OutputEventListener onNonError(final OutputEventListener listener) {
        return new BatchOutputEventListener(){

            public void onOutput(OutputEvent event) {
                if (event.getLogLevel() != LogLevel.ERROR || event.getLogLevel() == null) {
                    listener.onOutput(event);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.add((Object)listener);
        }
    }

    public void addStandardOutputListener(OutputStream outputStream) {
        this.addStandardOutputListener(new StreamBackedStandardOutputListener(outputStream));
    }

    public void addStandardErrorListener(OutputStream outputStream) {
        this.addStandardErrorListener(new StreamBackedStandardOutputListener(outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStandardOutputListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stdoutListeners.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStandardErrorListener(StandardOutputListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrListeners.remove((Object)listener);
        }
    }

    public void configure(LogLevel logLevel) {
        this.onOutput(new LogLevelChangeEvent(logLevel));
    }

    public void configureMaxWorkerCount(int maxWorkerCount) {
        this.onOutput(new MaxWorkerCountChangeEvent(maxWorkerCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutput(OutputEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (event.getLogLevel() != null && event.getLogLevel().compareTo(this.logLevel) < 0) {
                return;
            }
            if (event instanceof LogLevelChangeEvent) {
                LogLevelChangeEvent changeEvent = (LogLevelChangeEvent)event;
                LogLevel newLogLevel = changeEvent.getNewLogLevel();
                if (newLogLevel == this.logLevel) {
                    return;
                }
                this.logLevel = newLogLevel;
            } else if (event instanceof MaxWorkerCountChangeEvent) {
                MaxWorkerCountChangeEvent changeEvent = (MaxWorkerCountChangeEvent)event;
                int newMaxWorkerCount = changeEvent.getNewMaxWorkerCount();
                if (newMaxWorkerCount == this.maxWorkerCount) {
                    return;
                }
                this.maxWorkerCount = newMaxWorkerCount;
            }
            ((OutputEventListener)this.formatters.getSource()).onOutput(event);
        }
    }

    private class SnapshotImpl
    implements LoggingSystem.Snapshot {
        private final LogLevel logLevel;
        private final OutputEventListener console;
        private final int maxWorkerCount;

        SnapshotImpl(LogLevel logLevel, OutputEventListener console, int maxWorkerCount) {
            this.logLevel = logLevel;
            this.console = console;
            this.maxWorkerCount = maxWorkerCount;
        }
    }
}

