/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.runner;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.runner.JUnitPlatformRunnerListener;
import org.junit.platform.runner.JUnitPlatformTestTree;
import org.junit.platform.suite.api.ExcludeClassNamePatterns;
import org.junit.platform.suite.api.ExcludeEngines;
import org.junit.platform.suite.api.ExcludePackages;
import org.junit.platform.suite.api.ExcludeTags;
import org.junit.platform.suite.api.IncludeClassNamePatterns;
import org.junit.platform.suite.api.IncludeEngines;
import org.junit.platform.suite.api.IncludePackages;
import org.junit.platform.suite.api.IncludeTags;
import org.junit.platform.suite.api.SelectClasses;
import org.junit.platform.suite.api.SelectPackages;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

@API(value=API.Usage.Maintained)
public class JUnitPlatform
extends Runner
implements Filterable {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Class<?> testClass;
    private final Launcher launcher;
    private LauncherDiscoveryRequest discoveryRequest;
    private JUnitPlatformTestTree testTree;

    public JUnitPlatform(Class<?> testClass) throws InitializationError {
        this(testClass, LauncherFactory.create());
    }

    JUnitPlatform(Class<?> testClass, Launcher launcher) throws InitializationError {
        this.launcher = launcher;
        this.testClass = testClass;
        this.discoveryRequest = this.createDiscoveryRequest();
        this.testTree = this.generateTestTree();
    }

    public Description getDescription() {
        return this.testTree.getSuiteDescription();
    }

    public void run(RunNotifier notifier) {
        JUnitPlatformRunnerListener listener = new JUnitPlatformRunnerListener(this.testTree, notifier);
        this.launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
        this.launcher.execute(this.discoveryRequest);
    }

    private JUnitPlatformTestTree generateTestTree() {
        Preconditions.notNull((Object)this.discoveryRequest, (String)"DiscoveryRequest must not be null");
        TestPlan plan = this.launcher.discover(this.discoveryRequest);
        return new JUnitPlatformTestTree(plan, this.testClass);
    }

    private LauncherDiscoveryRequest createDiscoveryRequest() {
        boolean isSuite;
        List<DiscoverySelector> selectors = this.getSelectorsFromAnnotations();
        boolean bl = isSuite = !selectors.isEmpty();
        if (!isSuite) {
            selectors.add((DiscoverySelector)DiscoverySelectors.selectClass(this.testClass));
        }
        LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request().selectors(selectors);
        this.addFiltersFromAnnotations(requestBuilder, isSuite);
        return requestBuilder.build();
    }

    private void addFiltersFromAnnotations(LauncherDiscoveryRequestBuilder requestBuilder, boolean isSuite) {
        this.addIncludeClassNamePatternFilter(requestBuilder, isSuite);
        this.addExcludeClassNamePatternFilter(requestBuilder);
        this.addIncludePackagesFilter(requestBuilder);
        this.addExcludePackagesFilter(requestBuilder);
        this.addIncludedTagsFilter(requestBuilder);
        this.addExcludedTagsFilter(requestBuilder);
        this.addIncludedEnginesFilter(requestBuilder);
        this.addExcludedEnginesFilter(requestBuilder);
    }

    private List<DiscoverySelector> getSelectorsFromAnnotations() {
        ArrayList<DiscoverySelector> selectors = new ArrayList<DiscoverySelector>();
        selectors.addAll(this.transform(this.getSelectedClasses(), DiscoverySelectors::selectClass));
        selectors.addAll(this.transform(this.getSelectedPackageNames(), DiscoverySelectors::selectPackage));
        return selectors;
    }

    private <T> List<DiscoverySelector> transform(T[] sourceElements, Function<T, DiscoverySelector> transformer) {
        return Arrays.stream(sourceElements).map(transformer).collect(Collectors.toList());
    }

    private void addIncludeClassNamePatternFilter(LauncherDiscoveryRequestBuilder requestBuilder, boolean isSuite) {
        String[] patterns = this.getIncludeClassNamePatterns(isSuite);
        if (patterns.length > 0) {
            requestBuilder.filters(new org.junit.platform.engine.Filter[]{ClassNameFilter.includeClassNamePatterns((String[])patterns)});
        }
    }

    private void addExcludeClassNamePatternFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
        String[] patterns = this.getExcludeClassNamePatterns();
        if (patterns.length > 0) {
            requestBuilder.filters(new org.junit.platform.engine.Filter[]{ClassNameFilter.excludeClassNamePatterns((String[])patterns)});
        }
    }

    private void addIncludePackagesFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
        String[] includedPackages = this.getIncludedPackages();
        if (includedPackages.length > 0) {
            requestBuilder.filters(new org.junit.platform.engine.Filter[]{PackageNameFilter.includePackageNames((String[])includedPackages)});
        }
    }

    private void addExcludePackagesFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
        String[] excludedPackages = this.getExcludedPackages();
        if (excludedPackages.length > 0) {
            requestBuilder.filters(new org.junit.platform.engine.Filter[]{PackageNameFilter.excludePackageNames((String[])excludedPackages)});
        }
    }

    private void addIncludedTagsFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
        String[] includedTags = this.getIncludedTags();
        if (includedTags.length > 0) {
            requestBuilder.filters(new org.junit.platform.engine.Filter[]{TagFilter.includeTags((String[])includedTags)});
        }
    }

    private void addExcludedTagsFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
        String[] excludedTags = this.getExcludedTags();
        if (excludedTags.length > 0) {
            requestBuilder.filters(new org.junit.platform.engine.Filter[]{TagFilter.excludeTags((String[])excludedTags)});
        }
    }

    private void addIncludedEnginesFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
        String[] engineIds = this.getIncludedEngineIds();
        if (engineIds.length > 0) {
            requestBuilder.filters(new org.junit.platform.engine.Filter[]{EngineFilter.includeEngines((String[])engineIds)});
        }
    }

    private void addExcludedEnginesFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
        String[] engineIds = this.getExcludedEngineIds();
        if (engineIds.length > 0) {
            requestBuilder.filters(new org.junit.platform.engine.Filter[]{EngineFilter.excludeEngines((String[])engineIds)});
        }
    }

    private Class<?>[] getSelectedClasses() {
        return this.getValueFromAnnotation(SelectClasses.class, SelectClasses::value, EMPTY_CLASS_ARRAY);
    }

    private String[] getSelectedPackageNames() {
        return this.getValueFromAnnotation(SelectPackages.class, SelectPackages::value, EMPTY_STRING_ARRAY);
    }

    private String[] getIncludedPackages() {
        return this.getValueFromAnnotation(IncludePackages.class, IncludePackages::value, EMPTY_STRING_ARRAY);
    }

    private String[] getExcludedPackages() {
        return this.getValueFromAnnotation(ExcludePackages.class, ExcludePackages::value, EMPTY_STRING_ARRAY);
    }

    private String[] getIncludedTags() {
        return this.getValueFromAnnotation(IncludeTags.class, IncludeTags::value, EMPTY_STRING_ARRAY);
    }

    private String[] getExcludedTags() {
        return this.getValueFromAnnotation(ExcludeTags.class, ExcludeTags::value, EMPTY_STRING_ARRAY);
    }

    private String[] getIncludedEngineIds() {
        return this.getValueFromAnnotation(IncludeEngines.class, IncludeEngines::value, EMPTY_STRING_ARRAY);
    }

    private String[] getExcludedEngineIds() {
        return this.getValueFromAnnotation(ExcludeEngines.class, ExcludeEngines::value, EMPTY_STRING_ARRAY);
    }

    private String[] getIncludeClassNamePatterns(boolean isSuite) {
        Object[] patterns = this.getValueFromAnnotation(IncludeClassNamePatterns.class, IncludeClassNamePatterns::value, new String[0]);
        if (patterns.length == 0 && isSuite) {
            return new String[]{"^.*Tests?$"};
        }
        Preconditions.containsNoNullElements((Object[])patterns, (String)"IncludeClassNamePatterns must not contain null elements");
        this.trim((String[])patterns);
        return patterns;
    }

    private String[] getExcludeClassNamePatterns() {
        Object[] patterns = this.getValueFromAnnotation(ExcludeClassNamePatterns.class, ExcludeClassNamePatterns::value, new String[0]);
        Preconditions.containsNoNullElements((Object[])patterns, (String)"ExcludeClassNamePatterns must not contain null elements");
        this.trim((String[])patterns);
        return patterns;
    }

    private void trim(String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = patterns[i].trim();
        }
    }

    private <A extends Annotation, V> V getValueFromAnnotation(Class<A> annotationClass, Function<A, V> extractor, V defaultValue) {
        A annotation = this.testClass.getAnnotation(annotationClass);
        return annotation != null ? extractor.apply(annotation) : defaultValue;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Set<TestIdentifier> filteredIdentifiers = this.testTree.getFilteredLeaves(filter);
        if (filteredIdentifiers.isEmpty()) {
            throw new NoTestsRemainException();
        }
        this.discoveryRequest = this.createDiscoveryRequestForUniqueIds(filteredIdentifiers);
        this.testTree = this.generateTestTree();
    }

    private LauncherDiscoveryRequest createDiscoveryRequestForUniqueIds(Set<TestIdentifier> testIdentifiers) {
        List selectors = testIdentifiers.stream().map(TestIdentifier::getUniqueId).map(DiscoverySelectors::selectUniqueId).collect(Collectors.toList());
        return LauncherDiscoveryRequestBuilder.request().selectors(selectors).build();
    }
}

