/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util;

public class GridBounds {
    private final int minColumnIndex;
    private final int minRowIndex;
    private final int columnSpan;
    private final int rowSpan;

    public GridBounds(int columnIndex, int rowIndex, int columnSpan, int rowSpan) {
        assert (columnSpan >= 0);
        assert (rowSpan >= 0);
        this.minColumnIndex = columnIndex;
        this.minRowIndex = rowIndex;
        this.columnSpan = columnSpan;
        this.rowSpan = rowSpan;
    }

    public int getMinColumnIndex() {
        return this.minColumnIndex;
    }

    public int getMinRowIndex() {
        return this.minRowIndex;
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public int getMaxColumnIndex() {
        return this.minColumnIndex + this.columnSpan;
    }

    public int getMaxRowIndex() {
        return this.minRowIndex + this.rowSpan;
    }

    public boolean isEmpty() {
        return this.columnSpan == 0 || this.rowSpan == 0;
    }

    public GridBounds move(int columnDelta, int rowDelta) {
        int newColumnIndex = this.minColumnIndex + columnDelta;
        int newRowIndex = this.minRowIndex + rowDelta;
        return new GridBounds(newColumnIndex, newRowIndex, this.columnSpan, this.rowSpan);
    }

    public GridBounds union(GridBounds gridBounds) {
        int newMinColumnIndex = Math.min(this.minColumnIndex, gridBounds.minColumnIndex);
        int newMinRowIndex = Math.min(this.minRowIndex, gridBounds.minRowIndex);
        int newMaxColumnIndex = Math.max(this.getMaxColumnIndex(), gridBounds.getMaxColumnIndex());
        int newMaxRowIndex = Math.max(this.getMaxRowIndex(), gridBounds.getMaxRowIndex());
        int newColumnSpan = newMaxColumnIndex - newMinColumnIndex;
        int newRowSpan = newMaxRowIndex - newMinRowIndex;
        return new GridBounds(newMinColumnIndex, newMinRowIndex, newColumnSpan, newRowSpan);
    }
}

