/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsUpdate.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvsoperations.cvsUpdate.MergedWithConflictProjectOrModuleFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class CorruptedProjectFilesDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsoperations.cvsUpdate.ui.CorruptedProjectFilesDialog");
    private JLabel myMessageLabel;
    private JLabel myIconLabel;
    private final List<MergedWithConflictProjectOrModuleFile> myCorruptedFiles;
    private final Project myProject;
    private JPanel myPanel;
    private JRadioButton myGetAllOption;
    private JRadioButton mySkipAllOption;
    private JRadioButton myShowDialogOption;

    public CorruptedProjectFilesDialog(Project project, Collection<MergedWithConflictProjectOrModuleFile> mergedFiles) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myCorruptedFiles = new ArrayList<MergedWithConflictProjectOrModuleFile>(mergedFiles);
        this.myProject = project;
        this.myIconLabel.setIcon(Messages.getInformationIcon());
        this.myIconLabel.setText("");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myGetAllOption);
        buttonGroup.add(this.mySkipAllOption);
        buttonGroup.add(this.myShowDialogOption);
        this.myShowDialogOption.setSelected(true);
        this.setTitle(CvsBundle.message((String)"operation.name.update", (Object[])new Object[0]));
        this.init();
        this.showNextFileInfo();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new SkipFile(), new GetFile(), new SkipAll(), new GetAll()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cvsSupport2/cvsoperations/cvsUpdate/ui/CorruptedProjectFilesDialog", "createActions"));
        }
        return actionArray;
    }

    private void showNextFileInfo() {
        VirtualFile currentVirtualFile = this.getCurrentVirtualFile();
        FileType fileType = currentVirtualFile.getFileType();
        this.myMessageLabel.setText(CvsBundle.message((String)"label.project.files.cannot.be.merged.without.conflict", (Object[])new Object[]{fileType.getDescription(), currentVirtualFile.getPresentableUrl()}));
        this.setTitle(CvsBundle.message((String)"dialog.title.file.cannot.be.merged.without.conflicts", (Object[])new Object[]{fileType.getDescription(), currentVirtualFile.getName()}));
    }

    private void onCurrentFileProcessed(boolean isOk) {
        if (this.myCorruptedFiles.isEmpty()) {
            this.doCloseAction(isOk);
            return;
        }
        this.myCorruptedFiles.remove(0);
        if (this.myCorruptedFiles.isEmpty()) {
            this.doCloseAction(isOk);
        } else {
            this.showNextFileInfo();
        }
    }

    private void doCloseAction(boolean isOk) {
        if (isOk) {
            this.doOKAction();
        } else {
            this.doCancelAction();
        }
    }

    private VirtualFile getCurrentVirtualFile() {
        return this.myCorruptedFiles.get(0).getOriginal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveExternally(VirtualFile currentVirtualFile, Document document) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        fileDocumentManager.saveDocument(fileDocumentManager.getDocument(currentVirtualFile));
        File ioProjectFile = VfsUtil.virtualToIoFile((VirtualFile)currentVirtualFile);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(ioProjectFile));){
            FileUtil.copy((InputStream)new ByteArrayInputStream(document.getText().getBytes(currentVirtualFile.getCharset().name())), (OutputStream)outputStream);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected void doOKAction() {
        this.saveShowDialogOptions();
        super.doOKAction();
    }

    public void doCancelAction() {
        this.saveShowDialogOptions();
        super.doCancelAction();
    }

    private void saveShowDialogOptions() {
        CvsConfiguration cvsConfiguration = CvsConfiguration.getInstance(this.myProject);
        if (this.myShowDialogOption.isSelected()) {
            cvsConfiguration.SHOW_CORRUPTED_PROJECT_FILES = 0;
        } else if (this.mySkipAllOption.isSelected()) {
            cvsConfiguration.SHOW_CORRUPTED_PROJECT_FILES = 2;
        } else if (this.myGetAllOption.isSelected()) {
            cvsConfiguration.SHOW_CORRUPTED_PROJECT_FILES = 1;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myIconLabel = jLabel2 = new JLabel();
        jLabel2.setText("###");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.corrupted.project.files.description"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.corrupted.project.files.in.the.future"));
        jPanel4.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowDialogOption = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.corrupted.project.files.show.this.dialog"));
        jPanel4.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySkipAllOption = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.corrupted.project.files.skip.all.silently"));
        jPanel4.add((Component)jRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGetAllOption = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.corrupted.project.files.get.all.silently"));
        jPanel4.add((Component)jRadioButton, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class GetAll
    extends AbstractAction {
        public GetAll() {
            this.putValue("Name", CvsBundle.message((String)"button.text.get.all", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MergedWithConflictProjectOrModuleFile myCorruptedFile : CorruptedProjectFilesDialog.this.myCorruptedFiles) {
                myCorruptedFile.setShouldBeCheckedOut();
            }
            CorruptedProjectFilesDialog.this.myCorruptedFiles.clear();
            CorruptedProjectFilesDialog.this.onCurrentFileProcessed(true);
        }
    }

    private class SkipAll
    extends AbstractAction {
        public SkipAll() {
            this.putValue("Name", CvsBundle.message((String)"button.text.skip.all", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CorruptedProjectFilesDialog.this.myCorruptedFiles.clear();
            CorruptedProjectFilesDialog.this.onCurrentFileProcessed(false);
        }
    }

    private class GetFile
    extends AbstractAction {
        public GetFile() {
            this.putValue("Name", CvsBundle.message((String)"button.text.get", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((MergedWithConflictProjectOrModuleFile)CorruptedProjectFilesDialog.this.myCorruptedFiles.get(0)).setShouldBeCheckedOut();
            CorruptedProjectFilesDialog.this.onCurrentFileProcessed(true);
        }
    }

    private class SkipFile
    extends AbstractAction {
        public SkipFile() {
            this.putValue("Name", CvsBundle.message((String)"button.text.skip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CorruptedProjectFilesDialog.this.onCurrentFileProcessed(false);
        }
    }
}

