/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.dateOrRevision.ui;

import com.intellij.cvsSupport2.config.DateOrRevisionSettings;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsHelper;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.SyncDateFormat;
import com.michaelbaranov.microba.calendar.DatePicker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DateOrRevisionOrTagSettings {
    @NonNls
    private static final String FORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private static final SyncDateFormat CVS_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US));
    private JRadioButton myUseBranch;
    private JRadioButton myUseDate;
    private JRadioButton myUseHead;
    private TextFieldWithBrowseButton myBranch;
    private JPanel myPanel;
    private DatePicker myDatePicker;
    private final Project myProject;
    private final TagsProvider myTagsProvider;
    private static final String EMPTY_DATE = "";

    public DateOrRevisionOrTagSettings(TagsProvider tagsProvider, Project project) {
        this.myTagsProvider = tagsProvider;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myDatePicker.setDateFormat(DateFormatUtil.getDateTimeFormat().getDelegate());
        this.myUseBranch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateOrRevisionOrTagSettings.this.refreshEnabling();
                if (DateOrRevisionOrTagSettings.this.myUseBranch.isEnabled()) {
                    DateOrRevisionOrTagSettings.this.myBranch.getTextField().selectAll();
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)DateOrRevisionOrTagSettings.this.myBranch.getTextField(), true));
                }
            }
        });
        this.myUseHead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateOrRevisionOrTagSettings.this.refreshEnabling();
            }
        });
        this.myUseDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DateOrRevisionOrTagSettings.this.myUseDate.isSelected() && DateOrRevisionOrTagSettings.this.getDateString().equals(DateOrRevisionOrTagSettings.EMPTY_DATE)) {
                    DateOrRevisionOrTagSettings.this.setDate(new Date());
                }
                DateOrRevisionOrTagSettings.this.refreshEnabling();
                if (DateOrRevisionOrTagSettings.this.myUseDate.isEnabled()) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)DateOrRevisionOrTagSettings.this.myDatePicker, true));
                }
            }
        });
        this.myBranch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tagName = TagsHelper.chooseBranch(DateOrRevisionOrTagSettings.this.myTagsProvider, DateOrRevisionOrTagSettings.this.myProject);
                if (tagName != null) {
                    DateOrRevisionOrTagSettings.this.myBranch.setText(tagName);
                }
            }
        });
        this.refreshEnabling();
    }

    private void setDate(Date date) {
        try {
            this.myDatePicker.setDate(date);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void updateFrom(@NotNull DateOrRevisionSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/cvsSupport2/cvsoperations/dateOrRevision/ui/DateOrRevisionOrTagSettings", "updateFrom"));
        }
        this.myUseHead.setSelected(!settings.USE_BRANCH && !settings.USE_DATE);
        this.myUseBranch.setSelected(settings.USE_BRANCH);
        this.myUseDate.setSelected(settings.USE_DATE);
        this.myBranch.setText(settings.BRANCH);
        this.updateDate(settings.getDate());
        this.refreshEnabling();
    }

    public void saveTo(DateOrRevisionSettings settings) {
        settings.USE_BRANCH = this.myUseBranch.isSelected();
        settings.USE_DATE = this.myUseDate.isSelected();
        settings.BRANCH = this.getBranchText();
        settings.setDate(this.getDateString());
    }

    private String getBranchText() {
        return this.myBranch.getText().trim();
    }

    private String getDateString() {
        Date date = this.myDatePicker.getDate();
        if (date == null) {
            return EMPTY_DATE;
        }
        return CVS_FORMAT.format(date);
    }

    private void refreshEnabling() {
        boolean useBranch = this.myUseBranch.isSelected();
        this.myBranch.setEnabled(useBranch);
        this.myBranch.setEditable(useBranch);
        this.myDatePicker.setEnabled(this.myUseDate.isSelected());
    }

    private void updateDate(String dateString) {
        Date date;
        try {
            date = CVS_FORMAT.parse(dateString);
        }
        catch (ParseException e) {
            return;
        }
        try {
            this.myDatePicker.setDate(date);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void setHeadCaption(String text) {
        this.myUseHead.setText(text);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        DatePicker datePicker;
        JRadioButton jRadioButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(5, 0, 5, 5), 10, 0, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("border.title.configure.branch.or.date.use.version"), (int)0, (int)0, null, null));
        this.myUseBranch = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.select.tag.by.tag"));
        jPanel.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(20, -1), null, new Dimension(20, -1)));
        this.myBranch = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUseDate = jRadioButton2 = new JRadioButton();
        jRadioButton2.setMargin(new Insets(8, 2, 2, 2));
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.select.tag.by.date"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(20, -1), null, new Dimension(20, -1)));
        this.myDatePicker = datePicker = new DatePicker();
        jPanel4.add((Component)datePicker, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myUseHead = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("radio.select.tag.head.revision"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

