/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Iterator;

public class JavaGenericsUtil {
    public static boolean isReifiableType(PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            return JavaGenericsUtil.isReifiableType(((PsiArrayType)type2).getComponentType());
        }
        if (type2 instanceof PsiPrimitiveType) {
            return true;
        }
        if (PsiUtil.resolveClassInType(type2) instanceof PsiTypeParameter) {
            return false;
        }
        if (type2 instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)PsiUtil.convertAnonymousToBaseType(type2);
            if (classType.isRaw()) {
                return true;
            }
            PsiType[] parameters2 = classType.getParameters();
            if (parameters2.length > 0) {
                for (PsiType parameter : parameters2) {
                    if (parameter instanceof PsiWildcardType && ((PsiWildcardType)parameter).getBound() == null) continue;
                    return false;
                }
                return true;
            }
            assert (parameters2.length == 0);
            PsiClassType.ClassResolveResult resolved = classType.resolveGenerics();
            PsiClass aClass2 = resolved.getElement();
            if (aClass2 instanceof PsiTypeParameter) {
                return false;
            }
            if (aClass2 != null && !aClass2.hasModifierProperty("static")) {
                PsiClass stopClassLevel = PsiUtil.isLocalClass(aClass2) ? null : aClass2.getContainingClass();
                PsiModifierListOwner enclosingStaticElement = PsiUtil.getEnclosingStaticElement(aClass2, stopClassLevel);
                PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)aClass2, PsiClass.class, true);
                if (containingClass != null && (enclosingStaticElement == null || PsiTreeUtil.isAncestor(enclosingStaticElement, containingClass, false))) {
                    while (containingClass instanceof PsiAnonymousClass) {
                        containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class, true);
                    }
                    if (containingClass == null || enclosingStaticElement != null && !PsiTreeUtil.isAncestor(enclosingStaticElement, containingClass, false)) {
                        return true;
                    }
                    return JavaGenericsUtil.isReifiableType(JavaPsiFacade.getElementFactory(aClass2.getProject()).createType(containingClass, resolved.getSubstitutor()));
                }
            }
            return true;
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.isReifiableType(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        return false;
    }

    public static boolean isRawToGeneric(PsiType lType, PsiType rType) {
        if (lType instanceof PsiPrimitiveType || rType instanceof PsiPrimitiveType) {
            return false;
        }
        if (lType.equals(rType)) {
            return false;
        }
        if (lType instanceof PsiArrayType && rType instanceof PsiArrayType) {
            return JavaGenericsUtil.isRawToGeneric(((PsiArrayType)lType).getComponentType(), ((PsiArrayType)rType).getComponentType());
        }
        if (lType instanceof PsiArrayType || rType instanceof PsiArrayType) {
            return false;
        }
        if (rType instanceof PsiIntersectionType) {
            for (PsiType type2 : ((PsiIntersectionType)rType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(lType, type2)) continue;
                return true;
            }
            return false;
        }
        if (lType instanceof PsiIntersectionType) {
            for (PsiType type3 : ((PsiIntersectionType)lType).getConjuncts()) {
                if (!JavaGenericsUtil.isRawToGeneric(type3, rType)) continue;
                return true;
            }
            return false;
        }
        if (rType instanceof PsiCapturedWildcardType) {
            return JavaGenericsUtil.isRawToGeneric(lType, ((PsiCapturedWildcardType)rType).getUpperBound());
        }
        if (!(lType instanceof PsiClassType) || !(rType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult lResolveResult = ((PsiClassType)lType).resolveGenerics();
        PsiClassType.ClassResolveResult rResolveResult = ((PsiClassType)rType).resolveGenerics();
        PsiClass lClass = lResolveResult.getElement();
        PsiClass rClass = rResolveResult.getElement();
        if (rClass instanceof PsiAnonymousClass) {
            return JavaGenericsUtil.isRawToGeneric(lType, ((PsiAnonymousClass)rClass).getBaseClassType());
        }
        PsiSubstitutor lSubstitutor = lResolveResult.getSubstitutor();
        PsiSubstitutor rSubstitutor = rResolveResult.getSubstitutor();
        if (lClass == null || rClass == null) {
            return false;
        }
        if (lClass instanceof PsiTypeParameter && !InheritanceUtil.isInheritorOrSelf(rClass, lClass, true)) {
            return true;
        }
        if (!lClass.getManager().areElementsEquivalent(lClass, rClass)) {
            if (lClass.isInheritor(rClass, true)) {
                lSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(rClass, lClass, lSubstitutor);
                lClass = rClass;
            } else if (rClass.isInheritor(lClass, true)) {
                rSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(lClass, rClass, rSubstitutor);
                rClass = lClass;
            } else {
                return false;
            }
        }
        Iterator<PsiTypeParameter> lIterator = PsiUtil.typeParametersIterator(lClass);
        Iterator<PsiTypeParameter> rIterator = PsiUtil.typeParametersIterator(rClass);
        while (lIterator.hasNext()) {
            if (!rIterator.hasNext()) {
                return false;
            }
            PsiTypeParameter lParameter = lIterator.next();
            PsiTypeParameter rParameter = rIterator.next();
            PsiType lTypeArg = lSubstitutor.substitute(lParameter);
            PsiType rTypeArg = rSubstitutor.substituteWithBoundsPromotion(rParameter);
            if (lTypeArg == null) continue;
            if (rTypeArg == null) {
                if (lTypeArg instanceof PsiWildcardType && ((PsiWildcardType)lTypeArg).getBound() == null) continue;
                return true;
            }
            if (TypeConversionUtil.typesAgree(lTypeArg, rTypeArg, true)) continue;
            return true;
        }
        return false;
    }
}

