/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class LiteralFormatUtil {
    private static final CharFilter UNDERSCORES_FILTER = new CharFilter(){

        @Override
        public boolean accept(char ch) {
            return ch != '_';
        }
    };

    @NotNull
    public static String removeUnderscores(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/LiteralFormatUtil", "removeUnderscores"));
        }
        String string = StringUtil.strip(text2, UNDERSCORES_FILTER);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/LiteralFormatUtil", "removeUnderscores"));
        }
        return string;
    }
}

