/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.DummyAccessorInvocationTransformer;
import org.jetbrains.kotlin.js.inline.ExpressionDecomposer;
import org.jetbrains.kotlin.js.inline.FunctionInlineMutator;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.clean.FunctionPostProcessor;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedFunctionDefinitionsKt;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedLocalFunctionDeclarationsKt;
import org.jetbrains.kotlin.js.inline.context.FunctionContext;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

public class JsInliner
extends JsVisitorWithContextImpl {
    private final Map<JsName, JsFunction> functions;
    private final Map<String, JsFunction> accessors;
    private final Stack<JsInliningContext> inliningContexts;
    private final Set<JsFunction> processedFunctions;
    private final Set<JsFunction> inProcessFunctions;
    private final FunctionReader functionReader;
    private final DiagnosticSink trace;
    private final Stack<JsFunction> namedFunctionsStack;
    private final LinkedList<JsCallInfo> inlineCallInfos;
    private final Function1<JsNode, Boolean> canBeExtractedByInliner;

    public static void process(@NotNull JsConfig config, @NotNull DiagnosticSink trace, @NotNull JsName currentModuleName, @NotNull List<JsProgramFragment> fragments2, @NotNull List<JsProgramFragment> fragmentsToProcess) {
        if (config == null) {
            JsInliner.$$$reportNull$$$0(0);
        }
        if (trace == null) {
            JsInliner.$$$reportNull$$$0(1);
        }
        if (currentModuleName == null) {
            JsInliner.$$$reportNull$$$0(2);
        }
        if (fragments2 == null) {
            JsInliner.$$$reportNull$$$0(3);
        }
        if (fragmentsToProcess == null) {
            JsInliner.$$$reportNull$$$0(4);
        }
        Map<JsName, JsFunction> functions2 = CollectUtilsKt.collectNamedFunctions(fragments2);
        Map<String, JsFunction> accessors = CollectUtilsKt.collectAccessors(fragments2);
        DummyAccessorInvocationTransformer accessorInvocationTransformer = new DummyAccessorInvocationTransformer();
        for (JsProgramFragment fragment : fragmentsToProcess) {
            accessorInvocationTransformer.accept(fragment.getDeclarationBlock());
            accessorInvocationTransformer.accept(fragment.getInitializerBlock());
        }
        FunctionReader functionReader = new FunctionReader(config, currentModuleName, fragments2);
        JsInliner inliner = new JsInliner(functions2, accessors, functionReader, trace);
        ArrayList<JsBlock> nodesToPostProcess = new ArrayList<JsBlock>();
        for (JsProgramFragment fragment : fragmentsToProcess) {
            inliner.inliningContexts.push(inliner.new JsInliningContext());
            inliner.accept(fragment.getDeclarationBlock());
            JsFunction fakeInitFunction = new JsFunction((JsScope)JsDynamicScope.INSTANCE, fragment.getInitializerBlock(), "");
            inliner.accept(fakeInitFunction);
            inliner.inliningContexts.pop();
            JsBlock block = new JsBlock(fragment.getDeclarationBlock(), fragment.getInitializerBlock(), fragment.getExportBlock());
            nodesToPostProcess.add(block);
        }
        RemoveUnusedFunctionDefinitionsKt.removeUnusedFunctionDefinitions(nodesToPostProcess, functions2);
    }

    private JsInliner(@NotNull Map<JsName, JsFunction> functions2, @NotNull Map<String, JsFunction> accessors, @NotNull FunctionReader functionReader, @NotNull DiagnosticSink trace) {
        if (functions2 == null) {
            JsInliner.$$$reportNull$$$0(5);
        }
        if (accessors == null) {
            JsInliner.$$$reportNull$$$0(6);
        }
        if (functionReader == null) {
            JsInliner.$$$reportNull$$$0(7);
        }
        if (trace == null) {
            JsInliner.$$$reportNull$$$0(8);
        }
        this.inliningContexts = new Stack();
        this.processedFunctions = CollectionUtilsKt.IdentitySet();
        this.inProcessFunctions = CollectionUtilsKt.IdentitySet();
        this.namedFunctionsStack = new Stack();
        this.inlineCallInfos = new LinkedList();
        this.canBeExtractedByInliner = node -> node instanceof JsInvocation && this.hasToBeInlined((JsInvocation)node);
        this.functions = functions2;
        this.accessors = accessors;
        this.functionReader = functionReader;
        this.trace = trace;
    }

    @Override
    public boolean visit(@NotNull JsFunction function2, @NotNull JsContext context) {
        if (function2 == null) {
            JsInliner.$$$reportNull$$$0(9);
        }
        if (context == null) {
            JsInliner.$$$reportNull$$$0(10);
        }
        this.inliningContexts.push(new JsInliningContext());
        assert (!this.inProcessFunctions.contains(function2)) : "Inliner has revisited function";
        this.inProcessFunctions.add(function2);
        if (this.functions.containsValue(function2)) {
            this.namedFunctionsStack.push(function2);
        }
        return super.visit(function2, context);
    }

    @Override
    public void endVisit(@NotNull JsFunction function2, @NotNull JsContext context) {
        if (function2 == null) {
            JsInliner.$$$reportNull$$$0(11);
        }
        if (context == null) {
            JsInliner.$$$reportNull$$$0(12);
        }
        super.endVisit(function2, context);
        NamingUtilsKt.refreshLabelNames(function2.getBody(), function2.getScope());
        RemoveUnusedLocalFunctionDeclarationsKt.removeUnusedLocalFunctionDeclarations(function2);
        this.processedFunctions.add(function2);
        new FunctionPostProcessor(function2).apply();
        assert (this.inProcessFunctions.contains(function2));
        this.inProcessFunctions.remove(function2);
        this.inliningContexts.pop();
        if (!this.namedFunctionsStack.empty() && this.namedFunctionsStack.peek() == function2) {
            this.namedFunctionsStack.pop();
        }
    }

    @Override
    public boolean visit(@NotNull JsInvocation call2, @NotNull JsContext context) {
        JsFunction definition;
        if (call2 == null) {
            JsInliner.$$$reportNull$$$0(13);
        }
        if (context == null) {
            JsInliner.$$$reportNull$$$0(14);
        }
        if (!this.hasToBeInlined(call2)) {
            return true;
        }
        JsFunction containingFunction = this.getCurrentNamedFunction();
        if (containingFunction != null) {
            this.inlineCallInfos.add(new JsCallInfo(call2, containingFunction));
        }
        if (this.inProcessFunctions.contains(definition = this.getFunctionContext().getFunctionDefinition(call2))) {
            this.reportInlineCycle(call2, definition);
        } else if (!this.processedFunctions.contains(definition)) {
            this.accept(definition);
        }
        return true;
    }

    @Override
    public void endVisit(@NotNull JsInvocation x, @NotNull JsContext ctx) {
        if (x == null) {
            JsInliner.$$$reportNull$$$0(15);
        }
        if (ctx == null) {
            JsInliner.$$$reportNull$$$0(16);
        }
        if (this.hasToBeInlined(x)) {
            this.inline(x, ctx);
        }
        JsCallInfo lastCallInfo = null;
        if (!this.inlineCallInfos.isEmpty()) {
            lastCallInfo = this.inlineCallInfos.getLast();
        }
        if (lastCallInfo != null && lastCallInfo.call == x) {
            this.inlineCallInfos.removeLast();
        }
    }

    @Override
    protected void doAcceptStatementList(List<JsStatement> statements) {
        if (!this.inliningContexts.isEmpty()) {
            List<JsStatement> additionalStatements;
            for (int i = 0; i < statements.size(); i += additionalStatements.size() + 1) {
                additionalStatements = ExpressionDecomposer.preserveEvaluationOrder(statements.get(i), this.canBeExtractedByInliner);
                statements.addAll(i, additionalStatements);
            }
        }
        super.doAcceptStatementList(statements);
    }

    private void inline(@NotNull JsInvocation call2, @NotNull JsContext context) {
        CallableDescriptor callDescriptor;
        if (call2 == null) {
            JsInliner.$$$reportNull$$$0(17);
        }
        if (context == null) {
            JsInliner.$$$reportNull$$$0(18);
        }
        if (JsInliner.isSuspendWithCurrentContinuation(callDescriptor = MetadataProperties.getDescriptor(call2))) {
            this.inlineSuspendWithCurrentContinuation(call2, context);
            return;
        }
        JsInliningContext inliningContext = this.getInliningContext();
        InlineableResult inlineableResult = FunctionInlineMutator.getInlineableCallReplacement(call2, inliningContext);
        JsStatement inlineableBody = inlineableResult.getInlineableBody();
        JsExpression resultExpression = inlineableResult.getResultExpression();
        JsContext<JsStatement> statementContext = inliningContext.getStatementContext();
        JsStatement inlineableBodyWithLambdasInlined = this.accept(inlineableBody);
        assert (inlineableBody == inlineableBodyWithLambdasInlined);
        statementContext.addPrevious(JsAstUtils.flattenStatement(inlineableBody));
        if (resultExpression == null) {
            statementContext.removeMe();
            return;
        }
        resultExpression = this.accept(resultExpression);
        MetadataProperties.setSynthetic(resultExpression, true);
        context.replaceMe(resultExpression);
    }

    private static boolean isSuspendWithCurrentContinuation(@Nullable DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        return CommonCoroutineCodegenUtilKt.isBuiltInSuspendCoroutineOrReturn((FunctionDescriptor)descriptor2.getOriginal());
    }

    private void inlineSuspendWithCurrentContinuation(@NotNull JsInvocation call2, @NotNull JsContext context) {
        if (call2 == null) {
            JsInliner.$$$reportNull$$$0(19);
        }
        if (context == null) {
            JsInliner.$$$reportNull$$$0(20);
        }
        JsExpression lambda2 = call2.getArguments().get(0);
        JsExpression continuationArg = call2.getArguments().get(call2.getArguments().size() - 1);
        JsInvocation invocation = new JsInvocation(lambda2, continuationArg);
        MetadataProperties.setSuspend(invocation, true);
        context.replaceMe(this.accept(invocation));
    }

    @NotNull
    private JsInliningContext getInliningContext() {
        JsInliningContext jsInliningContext = this.inliningContexts.peek();
        if (jsInliningContext == null) {
            JsInliner.$$$reportNull$$$0(21);
        }
        return jsInliningContext;
    }

    @NotNull
    private FunctionContext getFunctionContext() {
        FunctionContext functionContext = this.getInliningContext().getFunctionContext();
        if (functionContext == null) {
            JsInliner.$$$reportNull$$$0(22);
        }
        return functionContext;
    }

    @Nullable
    private JsFunction getCurrentNamedFunction() {
        if (this.namedFunctionsStack.empty()) {
            return null;
        }
        return this.namedFunctionsStack.peek();
    }

    private void reportInlineCycle(@NotNull JsInvocation call2, @NotNull JsFunction calledFunction) {
        if (call2 == null) {
            JsInliner.$$$reportNull$$$0(23);
        }
        if (calledFunction == null) {
            JsInliner.$$$reportNull$$$0(24);
        }
        MetadataProperties.setInlineStrategy(call2, InlineStrategy.NOT_INLINE);
        Iterator<JsCallInfo> it = this.inlineCallInfos.descendingIterator();
        while (it.hasNext()) {
            JsCallInfo callInfo = it.next();
            PsiElement psiElement = MetadataProperties.getPsiElement(callInfo.call);
            CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(callInfo.call);
            if (psiElement != null && descriptor2 != null) {
                this.trace.report(Errors.INLINE_CALL_CYCLE.on(psiElement, descriptor2));
            }
            if (callInfo.containingFunction != calledFunction) continue;
            break;
        }
    }

    private boolean hasToBeInlined(@NotNull JsInvocation call2) {
        InlineStrategy strategy;
        if (call2 == null) {
            JsInliner.$$$reportNull$$$0(25);
        }
        if ((strategy = MetadataProperties.getInlineStrategy(call2)) == null || !strategy.isInline()) {
            return false;
        }
        return this.getFunctionContext().hasFunctionDefinition(call2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentModuleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentsToProcess";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReader";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/inline/JsInliner";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/inline/JsInliner";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInliningContext";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "endVisit";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "inline";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inlineSuspendWithCurrentContinuation";
                break;
            }
            case 21: 
            case 22: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "reportInlineCycle";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasToBeInlined";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JsCallInfo {
        @NotNull
        public final JsInvocation call;
        @NotNull
        public final JsFunction containingFunction;

        private JsCallInfo(@NotNull JsInvocation call2, @NotNull JsFunction function2) {
            if (call2 == null) {
                JsCallInfo.$$$reportNull$$$0(0);
            }
            if (function2 == null) {
                JsCallInfo.$$$reportNull$$$0(1);
            }
            this.call = call2;
            this.containingFunction = function2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "call";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "function";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/js/inline/JsInliner$JsCallInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class JsInliningContext
    implements InliningContext {
        private final FunctionContext functionContext;

        JsInliningContext() {
            this.functionContext = new FunctionContext(JsInliner.this.functionReader){

                @Override
                @Nullable
                protected JsFunction lookUpStaticFunction(@Nullable JsName functionName) {
                    return (JsFunction)JsInliner.this.functions.get(functionName);
                }

                @Override
                @Nullable
                protected JsFunction lookUpStaticFunctionByTag(@NotNull String functionTag) {
                    if (functionTag == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (JsFunction)JsInliner.this.accessors.get(functionTag);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionTag", "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext$1", "lookUpStaticFunctionByTag"));
                }
            };
        }

        @Override
        @NotNull
        public NamingContext newNamingContext() {
            NamingContext namingContext = new NamingContext(this.getStatementContext());
            if (namingContext == null) {
                JsInliningContext.$$$reportNull$$$0(0);
            }
            return namingContext;
        }

        @Override
        @NotNull
        public JsContext<JsStatement> getStatementContext() {
            JsContext jsContext = JsInliner.this.getLastStatementLevelContext();
            if (jsContext == null) {
                JsInliningContext.$$$reportNull$$$0(1);
            }
            return jsContext;
        }

        @Override
        @NotNull
        public FunctionContext getFunctionContext() {
            FunctionContext functionContext = this.functionContext;
            if (functionContext == null) {
                JsInliningContext.$$$reportNull$$$0(2);
            }
            return functionContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/kotlin/js/inline/JsInliner$JsInliningContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newNamingContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatementContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunctionContext";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

