/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\u000e\u001a\u00020\u000f*\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\"\u0010\u0015\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\b\u001a\"\u0010\u0018\u001a\u00020\u000f*\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0012\u0010\u001c\u001a\u00020\u001b*\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u001aH\u0010\u001d\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\u001e\u0012\u0004\u0012\u0002H!0\u001f0\u001e\"\u0004\b\u0000\u0010 \"\u0004\b\u0001\u0010!*\b\u0012\u0004\u0012\u0002H 0\u001e2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u0002H!0#\u00a8\u0006$"}, d2={"generateDelegateCall", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fromDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "toDescriptor", "thisObject", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "getReferenceToJsClass", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "addAccessorsToPrototype", "", "containingClass", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "literal", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "addFunctionToPrototype", "descriptor", "function", "fillCoroutineMetadata", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "hasController", "", "requiresStateMachineTransformation", "splitToRanges", "", "Lkotlin/Pair;", "T", "S", "classifier", "Lkotlin/Function1;", "kotlin-compiler"})
public final class UtilsKt {
    @NotNull
    public static final JsStatement generateDelegateCall(@NotNull ClassDescriptor classDescriptor, @NotNull FunctionDescriptor fromDescriptor, @NotNull FunctionDescriptor toDescriptor, @NotNull JsExpression thisObject, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(fromDescriptor, "fromDescriptor");
        Intrinsics.checkParameterIsNotNull(toDescriptor, "toDescriptor");
        Intrinsics.checkParameterIsNotNull(thisObject, "thisObject");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsName overriddenMemberFunctionName = context.getNameForDescriptor(toDescriptor);
        JsNameRef overriddenMemberFunctionRef = new JsNameRef(overriddenMemberFunctionName, thisObject);
        SmartList<JsParameter> parameters2 = new SmartList<JsParameter>();
        SmartList<JsNameRef> args = new SmartList<JsNameRef>();
        if (DescriptorUtils.isExtension(fromDescriptor)) {
            JsName extensionFunctionReceiverName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            parameters2.add(new JsParameter(extensionFunctionReceiverName));
            args.add(new JsNameRef(extensionFunctionReceiverName));
        }
        for (ValueParameterDescriptor param : fromDescriptor.getValueParameters()) {
            String paramName = param.getName().asString();
            JsName jsParamName = JsScope.declareTemporaryName(paramName);
            parameters2.add(new JsParameter(jsParamName));
            args.add(new JsNameRef(jsParamName));
        }
        FunctionIntrinsic intrinsic = context.intrinsics().getFunctionIntrinsic(toDescriptor);
        JsExpression invocation = intrinsic.exists() && intrinsic instanceof FunctionIntrinsicWithReceiverComputed ? ((FunctionIntrinsicWithReceiverComputed)intrinsic).apply(thisObject, (List<? extends JsExpression>)args, context) : (JsExpression)new JsInvocation((JsExpression)overriddenMemberFunctionRef, (List<? extends JsExpression>)args);
        JsFunction functionObject = TranslationUtils.simpleReturnFunction(context.getScopeForDescriptor(fromDescriptor), invocation);
        functionObject.getParameters().addAll((Collection<JsParameter>)parameters2);
        JsFunction jsFunction = functionObject;
        Intrinsics.checkExpressionValueIsNotNull(jsFunction, "functionObject");
        return UtilsKt.addFunctionToPrototype(context, classDescriptor, fromDescriptor, jsFunction);
    }

    @NotNull
    public static final <T, S> List<Pair<List<T>, S>> splitToRanges(@NotNull List<? extends T> $receiver, @NotNull Function1<? super T, ? extends S> classifier) {
        Object object;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(classifier, "classifier");
        if ($receiver.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int lastIndex = 0;
        S lastClass = classifier.invoke($receiver.get(0));
        List result2 = new ArrayList();
        Object object2 = SequencesKt.drop(SequencesKt.withIndex(CollectionsKt.asSequence((Iterable)$receiver)), 1).iterator();
        while (object2.hasNext()) {
            object = object2.next();
            int index2 = ((IndexedValue)object).component1();
            Object e = ((IndexedValue)object).component2();
            S cls = classifier.invoke(e);
            if (!(Intrinsics.areEqual(cls, lastClass) ^ true)) continue;
            Collection collection = result2;
            Pair<List<? extends T>, S> pair = new Pair<List<? extends T>, S>($receiver.subList(lastIndex, index2), lastClass);
            collection.add(pair);
            lastClass = cls;
            lastIndex = index2;
        }
        object = result2;
        object2 = new Pair<List<? extends T>, S>($receiver.subList(lastIndex, $receiver.size()), lastClass);
        object.add(object2);
        return result2;
    }

    @NotNull
    public static final JsExpression getReferenceToJsClass(@NotNull KotlinType type2, @NotNull TranslationContext context) {
        JsExpression jsExpression;
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor2 instanceof ClassDescriptor) {
            JsExpression jsExpression2 = ReferenceTranslator.translateAsTypeReference((ClassDescriptor)classifierDescriptor, context);
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "ReferenceTranslator.tran\u2026ifierDescriptor, context)");
        } else if (classifierDescriptor2 instanceof TypeParameterDescriptor) {
            boolean bl = ((TypeParameterDescriptor)classifierDescriptor).isReified();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            UsageTracker usageTracker = context.usageTracker();
            if (usageTracker != null) {
                usageTracker.used(classifierDescriptor);
            }
            JsNameRef jsNameRef = context.getNameForDescriptor(classifierDescriptor).makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getNameForDescri\u2026fierDescriptor).makeRef()");
            jsExpression = jsNameRef;
        } else {
            throw (Throwable)new IllegalStateException("Can't get reference for " + type2);
        }
        JsExpression referenceToJsClass = jsExpression;
        return referenceToJsClass;
    }

    @NotNull
    public static final JsStatement addFunctionToPrototype(@NotNull TranslationContext $receiver, @NotNull ClassDescriptor classDescriptor, @NotNull FunctionDescriptor descriptor2, @NotNull JsExpression function2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        JsExpression prototypeRef = JsAstUtils.prototypeOf($receiver.getInnerReference(classDescriptor));
        JsNameRef functionRef = new JsNameRef($receiver.getNameForDescriptor(descriptor2), prototypeRef);
        JsStatement jsStatement = JsAstUtils.assignment(functionRef, function2).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull(jsStatement, "JsAstUtils.assignment(fu\u2026Ref, function).makeStmt()");
        return jsStatement;
    }

    public static final void addAccessorsToPrototype(@NotNull TranslationContext $receiver, @NotNull ClassDescriptor containingClass, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JsObjectLiteral literal) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(containingClass, "containingClass");
        Intrinsics.checkParameterIsNotNull(propertyDescriptor, "propertyDescriptor");
        Intrinsics.checkParameterIsNotNull(literal, "literal");
        JsExpression prototypeRef = JsAstUtils.prototypeOf($receiver.getInnerReference(containingClass));
        JsName propertyName = $receiver.getNameForDescriptor(propertyDescriptor);
        JsInvocation defineProperty = JsAstUtils.defineProperty(prototypeRef, propertyName.getIdent(), literal, $receiver.program());
        $receiver.addDeclarationStatement(defineProperty.makeStmt());
    }

    public static final boolean requiresStateMachineTransformation(@NotNull FunctionDescriptor $receiver, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return $receiver instanceof AnonymousFunctionDescriptor || Intrinsics.areEqual((Boolean)context.bindingContext().get(BindingContext.CONTAINS_NON_TAIL_SUSPEND_CALLS, $receiver), true);
    }

    public static final void fillCoroutineMetadata(@NotNull JsFunction $receiver, @NotNull TranslationContext context, @NotNull FunctionDescriptor descriptor2, boolean hasController) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (!UtilsKt.requiresStateMachineTransformation(descriptor2, context)) {
            return;
        }
        ModuleDescriptor moduleDescriptor = context.getCurrentModule();
        FqName fqName2 = CommonCoroutineCodegenUtilKt.getCOROUTINES_INTRINSICS_PACKAGE_FQ_NAME();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "COROUTINES_INTRINSICS_PACKAGE_FQ_NAME");
        MemberScope memberScope2 = moduleDescriptor.getPackage(fqName2).getMemberScope();
        Name name = CommonCoroutineCodegenUtilKt.getCOROUTINE_SUSPENDED_NAME();
        Intrinsics.checkExpressionValueIsNotNull(name, "COROUTINE_SUSPENDED_NAME");
        PropertyDescriptor suspendPropertyDescriptor = (PropertyDescriptor)CollectionsKt.first((Iterable)memberScope2.getContributedVariables(name, NoLookupLocation.FROM_BACKEND));
        JsExpression coroutineBaseClassRef = ReferenceTranslator.translateAsTypeReference(TranslationUtils.getCoroutineBaseClass(context), context);
        Function1<String, JsName> getCoroutinePropertyName$ = new Function1<String, JsName>(context){
            final /* synthetic */ TranslationContext $context;

            @NotNull
            public final JsName invoke(@NotNull String id) {
                Intrinsics.checkParameterIsNotNull(id, "id");
                return this.$context.getNameForDescriptor(TranslationUtils.getCoroutineProperty(this.$context, id));
            }
            {
                this.$context = translationContext;
                super(1);
            }
        };
        JsName jsName = context.getNameForDescriptor(TranslationUtils.getCoroutineDoResumeFunction(context));
        Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForDescri\u2026oResumeFunction(context))");
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(suspendPropertyDescriptor, context);
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "ReferenceTranslator.tran\u2026pertyDescriptor, context)");
        JsExpression jsExpression2 = coroutineBaseClassRef;
        Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "coroutineBaseClassRef");
        JsName jsName2 = getCoroutinePropertyName$.invoke("state");
        Intrinsics.checkExpressionValueIsNotNull(jsName2, "getCoroutinePropertyName(\"state\")");
        JsName jsName3 = getCoroutinePropertyName$.invoke("exceptionState");
        Intrinsics.checkExpressionValueIsNotNull(jsName3, "getCoroutinePropertyName(\"exceptionState\")");
        JsName jsName4 = getCoroutinePropertyName$.invoke("finallyPath");
        Intrinsics.checkExpressionValueIsNotNull(jsName4, "getCoroutinePropertyName(\"finallyPath\")");
        JsName jsName5 = getCoroutinePropertyName$.invoke("result");
        Intrinsics.checkExpressionValueIsNotNull(jsName5, "getCoroutinePropertyName(\"result\")");
        JsName jsName6 = getCoroutinePropertyName$.invoke("exception");
        Intrinsics.checkExpressionValueIsNotNull(jsName6, "getCoroutinePropertyName(\"exception\")");
        boolean bl = descriptor2.getDispatchReceiverParameter() != null;
        boolean bl2 = hasController;
        JsName jsName7 = jsName6;
        JsName jsName8 = jsName5;
        JsName jsName9 = jsName4;
        JsName jsName10 = jsName3;
        JsName jsName11 = jsName2;
        JsExpression jsExpression3 = jsExpression2;
        JsExpression jsExpression4 = jsExpression;
        MetadataProperties.setCoroutineMetadata($receiver, new CoroutineMetadata(jsName, jsName11, jsName10, jsName9, jsName8, jsName7, jsExpression3, jsExpression4, bl2, bl));
    }
}

