/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.Function;
import com.intellij.util.containers.SoftValueHashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenEmbeddersManager {
    public static final Key FOR_DEPENDENCIES_RESOLVE = Key.create((String)(MavenEmbeddersManager.class + ".FOR_DEPENDENCIES_RESOLVE"));
    public static final Key FOR_PLUGINS_RESOLVE = Key.create((String)(MavenEmbeddersManager.class + ".FOR_PLUGINS_RESOLVE"));
    public static final Key FOR_FOLDERS_RESOLVE = Key.create((String)(MavenEmbeddersManager.class + ".FOR_FOLDERS_RESOLVE"));
    public static final Key FOR_POST_PROCESSING = Key.create((String)(MavenEmbeddersManager.class + ".FOR_POST_PROCESSING"));
    public static final Key FOR_GET_VERSIONS = Key.create((String)(MavenEmbeddersManager.class + ".FOR_GET_VERSIONS"));
    public static final Key FOR_MODEL_READ = Key.create((String)(MavenEmbeddersManager.class + ".FOR_MODEL_READ"));
    public static final Key FOR_DOWNLOAD = Key.create((String)(MavenEmbeddersManager.class + ".FOR_DOWNLOAD"));
    private final Project myProject;
    private final Map<Trinity<Key, String, String>, MavenEmbedderWrapper> myPool = new SoftValueHashMap();
    private final Set<MavenEmbedderWrapper> myEmbeddersInUse = new THashSet();
    private final Set<MavenEmbedderWrapper> myEmbeddersToClear = new THashSet();

    public MavenEmbeddersManager(Project project) {
        this.myProject = project;
    }

    public synchronized void reset() {
        this.releasePooledEmbedders(false);
    }

    public synchronized void clearCaches() {
        this.forEachPooled(false, each -> {
            each.clearCaches();
            return null;
        });
        this.myEmbeddersToClear.addAll(this.myEmbeddersInUse);
    }

    @NotNull
    public synchronized MavenEmbedderWrapper getEmbedder(@NotNull MavenProject mavenProject, Key kind) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenEmbeddersManager", "getEmbedder"));
        }
        File baseDir = MavenUtil.getBaseDir(mavenProject.getDirectoryFile());
        MavenEmbedderWrapper mavenEmbedderWrapper = this.getEmbedder(kind, baseDir.getPath(), baseDir.getPath());
        if (mavenEmbedderWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenEmbeddersManager", "getEmbedder"));
        }
        return mavenEmbedderWrapper;
    }

    @NotNull
    public synchronized MavenEmbedderWrapper getEmbedder(Key kind, String workingDirectory, String multiModuleProjectDirectory) {
        boolean alwaysOnline;
        Trinity key = Trinity.create((Object)kind, (Object)workingDirectory, (Object)multiModuleProjectDirectory);
        MavenEmbedderWrapper result = this.myPool.get(key);
        boolean bl = alwaysOnline = kind == FOR_DOWNLOAD;
        if (result == null) {
            result = MavenServerManager.getInstance().createEmbedder(this.myProject, alwaysOnline, workingDirectory, multiModuleProjectDirectory);
            this.myPool.put((Trinity<Key, String, String>)key, result);
        }
        if (this.myEmbeddersInUse.contains(result)) {
            MavenLog.LOG.warn("embedder " + key + " is already used");
            MavenEmbedderWrapper mavenEmbedderWrapper = MavenServerManager.getInstance().createEmbedder(this.myProject, alwaysOnline, workingDirectory, multiModuleProjectDirectory);
            if (mavenEmbedderWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenEmbeddersManager", "getEmbedder"));
            }
            return mavenEmbedderWrapper;
        }
        this.myEmbeddersInUse.add(result);
        MavenEmbedderWrapper mavenEmbedderWrapper = result;
        if (mavenEmbedderWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenEmbeddersManager", "getEmbedder"));
        }
        return mavenEmbedderWrapper;
    }

    public synchronized void release(@NotNull MavenEmbedderWrapper embedder) {
        if (embedder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embedder", "org/jetbrains/idea/maven/project/MavenEmbeddersManager", "release"));
        }
        if (!this.myEmbeddersInUse.contains(embedder)) {
            embedder.release();
            this.myEmbeddersToClear.remove(embedder);
            return;
        }
        embedder.reset();
        this.myEmbeddersInUse.remove(embedder);
        if (this.myEmbeddersToClear.contains(embedder)) {
            embedder.clearCaches();
            this.myEmbeddersToClear.remove(embedder);
        }
    }

    public synchronized void releaseInTests() {
        if (!this.myEmbeddersInUse.isEmpty()) {
            MavenLog.LOG.warn("embedders should be release first");
        }
        this.releasePooledEmbedders(false);
    }

    public synchronized void releaseForcefullyInTests() {
        this.releasePooledEmbedders(true);
    }

    private synchronized void releasePooledEmbedders(boolean force) {
        this.forEachPooled(force, each -> {
            each.release();
            return null;
        });
        this.myPool.clear();
        this.myEmbeddersInUse.clear();
        this.myEmbeddersToClear.clear();
    }

    private void forEachPooled(boolean includeInUse, Function<MavenEmbedderWrapper, ?> func) {
        for (Trinity<Key, String, String> each : this.myPool.keySet()) {
            MavenEmbedderWrapper embedder = this.myPool.get(each);
            if (embedder == null || !includeInUse && this.myEmbeddersInUse.contains(embedder)) continue;
            func.fun((Object)embedder);
        }
    }
}

