/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalPlugin;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceSet;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.ExternalPlugin;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectPreview;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;

public class DefaultExternalProject
implements ExternalProject,
ExternalProjectPreview {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String myId;
    @NotNull
    private String myName;
    @NotNull
    private String myQName;
    @Nullable
    private String myDescription;
    @NotNull
    private String myGroup;
    @NotNull
    private String myVersion;
    @NotNull
    private Map<String, ExternalProject> myChildProjects;
    @NotNull
    private File myProjectDir;
    @NotNull
    private File myBuildDir;
    @Nullable
    private File myBuildFile;
    @NotNull
    private Map<String, ExternalTask> myTasks;
    @NotNull
    private Map<String, ?> myProperties;
    @NotNull
    private Map<String, ExternalSourceSet> mySourceSets;
    @NotNull
    private String myExternalSystemId;
    @NotNull
    private Map<String, ExternalPlugin> myPlugins;
    @NotNull
    private List<File> myArtifacts;
    @NotNull
    private Map<String, Set<File>> myArtifactsByConfiguration;

    public DefaultExternalProject() {
        this.myChildProjects = new HashMap<String, ExternalProject>();
        this.myTasks = new HashMap<String, ExternalTask>();
        this.myProperties = new HashMap();
        this.mySourceSets = new HashMap<String, ExternalSourceSet>();
        this.myPlugins = new HashMap<String, ExternalPlugin>();
        this.myArtifacts = new ArrayList<File>();
        this.myArtifactsByConfiguration = new HashMap<String, Set<File>>();
    }

    public DefaultExternalProject(@NotNull ExternalProject externalProject) {
        if (externalProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProject", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "<init>"));
        }
        this();
        this.myId = externalProject.getId();
        this.myName = externalProject.getName();
        this.myQName = externalProject.getQName();
        this.myVersion = externalProject.getVersion();
        this.myGroup = externalProject.getGroup();
        this.myDescription = externalProject.getDescription();
        this.myProjectDir = externalProject.getProjectDir();
        this.myBuildDir = externalProject.getBuildDir();
        this.myBuildFile = externalProject.getBuildFile();
        this.myExternalSystemId = externalProject.getExternalSystemId();
        for (Map.Entry entry : externalProject.getChildProjects().entrySet()) {
            this.myChildProjects.put((String)entry.getKey(), new DefaultExternalProject((ExternalProject)entry.getValue()));
        }
        for (Map.Entry entry : externalProject.getTasks().entrySet()) {
            this.myTasks.put((String)entry.getKey(), new DefaultExternalTask((ExternalTask)entry.getValue()));
        }
        for (Map.Entry entry : externalProject.getSourceSets().entrySet()) {
            this.mySourceSets.put((String)entry.getKey(), new DefaultExternalSourceSet((ExternalSourceSet)entry.getValue()));
        }
        for (Map.Entry entry : externalProject.getPlugins().entrySet()) {
            this.myPlugins.put((String)entry.getKey(), new DefaultExternalPlugin((ExternalPlugin)entry.getValue()));
        }
        this.myArtifacts.addAll(externalProject.getArtifacts());
        this.myArtifactsByConfiguration.putAll(externalProject.getArtifactsByConfiguration());
    }

    @NotNull
    public String getExternalSystemId() {
        String string = this.myExternalSystemId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getExternalSystemId"));
        }
        return string;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getId"));
        }
        return string;
    }

    public void setId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setId"));
        }
        this.myId = id;
    }

    public void setExternalSystemId(@NotNull String externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setExternalSystemId"));
        }
        this.myExternalSystemId = externalSystemId;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setName"));
        }
        this.myName = name;
    }

    @NotNull
    public String getQName() {
        String string = this.myQName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getQName"));
        }
        return string;
    }

    public void setQName(@NotNull String QName) {
        if (QName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "QName", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setQName"));
        }
        this.myQName = QName;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }

    @NotNull
    public String getGroup() {
        String string = this.myGroup;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getGroup"));
        }
        return string;
    }

    public void setGroup(@NotNull String group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setGroup"));
        }
        this.myGroup = group;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getVersion"));
        }
        return string;
    }

    public void setVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setVersion"));
        }
        this.myVersion = version;
    }

    @NotNull
    public Map<String, ExternalProject> getChildProjects() {
        Map<String, ExternalProject> map = this.myChildProjects;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getChildProjects"));
        }
        return map;
    }

    public void setChildProjects(@NotNull Map<String, ExternalProject> childProjects) {
        if (childProjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childProjects", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setChildProjects"));
        }
        this.myChildProjects = childProjects;
    }

    @NotNull
    public File getProjectDir() {
        File file = this.myProjectDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getProjectDir"));
        }
        return file;
    }

    public void setProjectDir(@NotNull File projectDir) {
        if (projectDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDir", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setProjectDir"));
        }
        this.myProjectDir = projectDir;
    }

    @NotNull
    public File getBuildDir() {
        File file = this.myBuildDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getBuildDir"));
        }
        return file;
    }

    public void setBuildDir(@NotNull File buildDir) {
        if (buildDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDir", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setBuildDir"));
        }
        this.myBuildDir = buildDir;
    }

    @Nullable
    public File getBuildFile() {
        return this.myBuildFile;
    }

    public void setBuildFile(@Nullable File buildFile) {
        this.myBuildFile = buildFile;
    }

    @NotNull
    public Map<String, ExternalTask> getTasks() {
        Map<String, ExternalTask> map = this.myTasks;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getTasks"));
        }
        return map;
    }

    public void setTasks(@NotNull Map<String, ExternalTask> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setTasks"));
        }
        this.myTasks = tasks;
    }

    @NotNull
    public Map<String, ExternalPlugin> getPlugins() {
        Map<String, ExternalPlugin> map = this.myPlugins;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getPlugins"));
        }
        return map;
    }

    public void setPlugins(@NotNull Map<String, ExternalPlugin> plugins) {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setPlugins"));
        }
        this.myPlugins = plugins;
    }

    @NotNull
    public Map<String, ?> getProperties() {
        Map<String, ?> map = this.myProperties;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getProperties"));
        }
        return map;
    }

    public void setProperties(@NotNull Map<String, ?> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setProperties"));
        }
        this.myProperties = properties;
    }

    @Nullable
    public Object getProperty(String name) {
        return this.myProperties.get(name);
    }

    @NotNull
    public Map<String, ExternalSourceSet> getSourceSets() {
        Map<String, ExternalSourceSet> map = this.mySourceSets;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getSourceSets"));
        }
        return map;
    }

    public void setSourceSets(@NotNull Map<String, ExternalSourceSet> sourceSets) {
        if (sourceSets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSets", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setSourceSets"));
        }
        this.mySourceSets = sourceSets;
    }

    @NotNull
    public List<File> getArtifacts() {
        List<File> list = this.myArtifacts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getArtifacts"));
        }
        return list;
    }

    public void setArtifacts(@NotNull List<File> artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setArtifacts"));
        }
        this.myArtifacts = artifacts;
    }

    public void setArtifactsByConfiguration(@NotNull Map<String, Set<File>> artifactsByConfiguration) {
        if (artifactsByConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactsByConfiguration", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "setArtifactsByConfiguration"));
        }
        this.myArtifactsByConfiguration = artifactsByConfiguration;
    }

    @NotNull
    public Map<String, Set<File>> getArtifactsByConfiguration() {
        Map<String, Set<File>> map = this.myArtifactsByConfiguration;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/DefaultExternalProject", "getArtifactsByConfiguration"));
        }
        return map;
    }

    public String toString() {
        return "project '" + this.myId + "'";
    }
}

