/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(value=API.Usage.Experimental)
public abstract class AbstractTestDescriptor
implements TestDescriptor {
    private final UniqueId uniqueId;
    private final String displayName;
    private TestDescriptor parent;
    private TestSource source;
    private final Set<TestDescriptor> children = Collections.synchronizedSet(new LinkedHashSet(16));

    protected AbstractTestDescriptor(UniqueId uniqueId, String displayName) {
        this.uniqueId = (UniqueId)Preconditions.notNull((Object)uniqueId, (String)"UniqueId must not be null");
        this.displayName = Preconditions.notBlank((String)displayName, (String)"displayName must not be null or blank");
    }

    @Override
    public final UniqueId getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Optional<TestDescriptor> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public final void setParent(TestDescriptor parent) {
        this.parent = parent;
    }

    @Override
    public void removeChild(TestDescriptor child) {
        Preconditions.notNull((Object)child, (String)"child must not be null");
        this.children.remove(child);
        child.setParent(null);
    }

    @Override
    public void removeFromHierarchy() {
        if (this.isRoot()) {
            throw new JUnitException("You cannot remove the root of a hierarchy.");
        }
        this.parent.removeChild(this);
        this.children.clear();
    }

    @Override
    public Optional<? extends TestDescriptor> findByUniqueId(UniqueId uniqueId) {
        Preconditions.notNull((Object)uniqueId, (String)"UniqueId must not be null");
        if (this.getUniqueId().equals(uniqueId)) {
            return Optional.of(this);
        }
        return this.children.stream().map(child -> child.findByUniqueId(uniqueId)).filter(Optional::isPresent).findAny().orElse(Optional.empty());
    }

    @Override
    public void addChild(TestDescriptor child) {
        Preconditions.notNull((Object)child, (String)"child must not be null");
        child.setParent(this);
        this.children.add(child);
    }

    @Override
    public final Set<? extends TestDescriptor> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    protected final void setSource(TestSource source) {
        this.source = (TestSource)Preconditions.notNull((Object)source, (String)"TestSource must not be null");
    }

    @Override
    public Set<TestTag> getTags() {
        return Collections.emptySet();
    }

    @Override
    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    public final int hashCode() {
        return this.uniqueId.hashCode();
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TestDescriptor that = (TestDescriptor)other;
        return this.getUniqueId().equals(that.getUniqueId());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getUniqueId();
    }
}

