/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.codeStyle.CommenterForm;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.JavaVisibilityPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBInsets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CodeStyleGenerationConfigurable
implements CodeStyleConfigurable {
    private final JavaVisibilityPanel myJavaVisibilityPanel;
    JPanel myPanel;
    private JTextField myFieldPrefixField;
    private JTextField myStaticFieldPrefixField;
    private JTextField myParameterPrefixField;
    private JTextField myLocalVariablePrefixField;
    private JTextField myFieldSuffixField;
    private JTextField myStaticFieldSuffixField;
    private JTextField myParameterSuffixField;
    private JTextField myLocalVariableSuffixField;
    private JCheckBox myCbPreferLongerNames;
    private final CodeStyleSettings mySettings;
    private JCheckBox myCbGenerateFinalParameters;
    private JCheckBox myCbGenerateFinalLocals;
    private JCheckBox myCbUseExternalAnnotations;
    private JCheckBox myInsertOverrideAnnotationCheckBox;
    private JCheckBox myRepeatSynchronizedCheckBox;
    private JPanel myVisibilityPanel;
    private JPanel myCommenterPanel;
    private JPanel myOverridePanel;
    private JBCheckBox myReplaceInstanceOfCb;
    private JBCheckBox myReplaceCastCb;
    private JBCheckBox myReplaceNullCheckCb;
    private CommenterForm myCommenterForm;
    private SortedListModel<String> myRepeatAnnotationsModel;

    public CodeStyleGenerationConfigurable(CodeStyleSettings settings) {
        this.mySettings = settings;
        this.$$$setupUI$$$();
        this.myPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2));
        this.myJavaVisibilityPanel = new JavaVisibilityPanel(false, true, RefactoringBundle.message((String)"default.visibility.border.title"));
    }

    public JComponent createComponent() {
        this.myVisibilityPanel.add((Component)this.myJavaVisibilityPanel, "Center");
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 12, 1, (Insets)new JBInsets(0, 0, 0, 0), 0, 0);
        Condition isApplicable = aClass -> aClass.isAnnotationType();
        this.myRepeatAnnotationsModel = new SortedListModel(Comparator.naturalOrder());
        this.myOverridePanel.add((Component)SpecialAnnotationsUtil.createSpecialAnnotationsListControl("Annotations to Copy", false, (Condition<PsiClass>)isApplicable, this.myRepeatAnnotationsModel), gc);
        return this.myPanel;
    }

    public void disposeUIResources() {
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.code.generation", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.globalcodestyle.codegen";
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/CodeStyleGenerationConfigurable", "reset"));
        }
        this.myCbPreferLongerNames.setSelected(settings.PREFER_LONGER_NAMES);
        this.myFieldPrefixField.setText(settings.FIELD_NAME_PREFIX);
        this.myStaticFieldPrefixField.setText(settings.STATIC_FIELD_NAME_PREFIX);
        this.myParameterPrefixField.setText(settings.PARAMETER_NAME_PREFIX);
        this.myLocalVariablePrefixField.setText(settings.LOCAL_VARIABLE_NAME_PREFIX);
        this.myFieldSuffixField.setText(settings.FIELD_NAME_SUFFIX);
        this.myStaticFieldSuffixField.setText(settings.STATIC_FIELD_NAME_SUFFIX);
        this.myParameterSuffixField.setText(settings.PARAMETER_NAME_SUFFIX);
        this.myLocalVariableSuffixField.setText(settings.LOCAL_VARIABLE_NAME_SUFFIX);
        this.myCbGenerateFinalLocals.setSelected(settings.GENERATE_FINAL_LOCALS);
        this.myCbGenerateFinalParameters.setSelected(settings.GENERATE_FINAL_PARAMETERS);
        this.myCbUseExternalAnnotations.setSelected(settings.USE_EXTERNAL_ANNOTATIONS);
        this.myInsertOverrideAnnotationCheckBox.setSelected(settings.INSERT_OVERRIDE_ANNOTATION);
        this.myRepeatSynchronizedCheckBox.setSelected(settings.REPEAT_SYNCHRONIZED);
        this.myJavaVisibilityPanel.setVisibility(settings.VISIBILITY);
        this.myReplaceCastCb.setSelected(settings.REPLACE_CAST);
        this.myReplaceInstanceOfCb.setSelected(settings.REPLACE_INSTANCEOF);
        this.myReplaceNullCheckCb.setSelected(settings.REPLACE_NULL_CHECK);
        this.myRepeatAnnotationsModel.clear();
        this.myRepeatAnnotationsModel.addAll((Collection)settings.getRepeatAnnotations());
        this.myCommenterForm.reset(settings);
    }

    public void reset() {
        this.reset(this.mySettings);
    }

    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/CodeStyleGenerationConfigurable", "apply"));
        }
        settings.PREFER_LONGER_NAMES = this.myCbPreferLongerNames.isSelected();
        settings.FIELD_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myFieldPrefixField.getText(), true);
        settings.STATIC_FIELD_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myStaticFieldPrefixField.getText(), true);
        settings.PARAMETER_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myParameterPrefixField.getText(), true);
        settings.LOCAL_VARIABLE_NAME_PREFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myLocalVariablePrefixField.getText(), true);
        settings.FIELD_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myFieldSuffixField.getText(), false);
        settings.STATIC_FIELD_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myStaticFieldSuffixField.getText(), false);
        settings.PARAMETER_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myParameterSuffixField.getText(), false);
        settings.LOCAL_VARIABLE_NAME_SUFFIX = CodeStyleGenerationConfigurable.setPrefixSuffix(this.myLocalVariableSuffixField.getText(), false);
        settings.GENERATE_FINAL_LOCALS = this.myCbGenerateFinalLocals.isSelected();
        settings.GENERATE_FINAL_PARAMETERS = this.myCbGenerateFinalParameters.isSelected();
        settings.USE_EXTERNAL_ANNOTATIONS = this.myCbUseExternalAnnotations.isSelected();
        settings.INSERT_OVERRIDE_ANNOTATION = this.myInsertOverrideAnnotationCheckBox.isSelected();
        settings.REPEAT_SYNCHRONIZED = this.myRepeatSynchronizedCheckBox.isSelected();
        settings.VISIBILITY = this.myJavaVisibilityPanel.getVisibility();
        settings.REPLACE_CAST = this.myReplaceCastCb.isSelected();
        settings.REPLACE_INSTANCEOF = this.myReplaceInstanceOfCb.isSelected();
        settings.REPLACE_NULL_CHECK = this.myReplaceNullCheckCb.isSelected();
        this.myCommenterForm.apply(settings);
        settings.setRepeatAnnotations(this.myRepeatAnnotationsModel.getItems());
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project2).settingsChanged();
        }
    }

    private static String setPrefixSuffix(String text2, boolean prefix) throws ConfigurationException {
        if ((text2 = text2.trim()).isEmpty()) {
            return text2;
        }
        if (!StringUtil.isJavaIdentifier((String)text2)) {
            throw new ConfigurationException("Not a valid java identifier part in " + (prefix ? "prefix" : "suffix") + " '" + text2 + "'");
        }
        return text2;
    }

    public void apply() throws ConfigurationException {
        this.apply(this.mySettings);
    }

    public boolean isModified(CodeStyleSettings settings) {
        boolean isModified = this.isModified(this.myCbPreferLongerNames, settings.PREFER_LONGER_NAMES);
        isModified |= this.isModified(this.myFieldPrefixField, settings.FIELD_NAME_PREFIX);
        isModified |= this.isModified(this.myStaticFieldPrefixField, settings.STATIC_FIELD_NAME_PREFIX);
        isModified |= this.isModified(this.myParameterPrefixField, settings.PARAMETER_NAME_PREFIX);
        isModified |= this.isModified(this.myLocalVariablePrefixField, settings.LOCAL_VARIABLE_NAME_PREFIX);
        isModified |= this.isModified(this.myFieldSuffixField, settings.FIELD_NAME_SUFFIX);
        isModified |= this.isModified(this.myStaticFieldSuffixField, settings.STATIC_FIELD_NAME_SUFFIX);
        isModified |= this.isModified(this.myParameterSuffixField, settings.PARAMETER_NAME_SUFFIX);
        isModified |= this.isModified(this.myLocalVariableSuffixField, settings.LOCAL_VARIABLE_NAME_SUFFIX);
        isModified |= this.isModified(this.myCbGenerateFinalLocals, settings.GENERATE_FINAL_LOCALS);
        isModified |= this.isModified(this.myCbGenerateFinalParameters, settings.GENERATE_FINAL_PARAMETERS);
        isModified |= this.isModified(this.myCbUseExternalAnnotations, settings.USE_EXTERNAL_ANNOTATIONS);
        isModified |= this.isModified(this.myInsertOverrideAnnotationCheckBox, settings.INSERT_OVERRIDE_ANNOTATION);
        isModified |= this.isModified(this.myRepeatSynchronizedCheckBox, settings.REPEAT_SYNCHRONIZED);
        isModified |= this.isModified((JToggleButton)this.myReplaceCastCb, settings.REPLACE_CAST);
        isModified |= this.isModified((JToggleButton)this.myReplaceInstanceOfCb, settings.REPLACE_INSTANCEOF);
        isModified |= this.isModified((JToggleButton)this.myReplaceNullCheckCb, settings.REPLACE_NULL_CHECK);
        isModified |= !settings.VISIBILITY.equals(this.myJavaVisibilityPanel.getVisibility());
        isModified |= this.myCommenterForm.isModified(settings);
        return isModified |= !this.myRepeatAnnotationsModel.getItems().equals(settings.getRepeatAnnotations());
    }

    public boolean isModified() {
        return this.isModified(this.mySettings);
    }

    private void createUIComponents() {
        this.myCommenterForm = new CommenterForm((Language)JavaLanguage.INSTANCE);
        this.myCommenterPanel = this.myCommenterForm.getCommenterPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JTextField jTextField7;
        JTextField jTextField8;
        JCheckBox jCheckBox6;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 10, 15, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.naming"), (int)0, (int)0, null, null));
        this.myCbPreferLongerNames = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.prefer.longer.names"));
        jPanel5.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 1, 3, 0, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.parameter"));
        jPanel6.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.static.field"));
        jPanel6.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.field"));
        jPanel6.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.naming.local.variable"));
        jPanel6.add((Component)jLabel4, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myFieldPrefixField = jTextField8 = new JTextField();
        jTextField8.setText("");
        jPanel6.add((Component)jTextField8, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myStaticFieldPrefixField = jTextField7 = new JTextField();
        jPanel6.add((Component)jTextField7, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myParameterPrefixField = jTextField6 = new JTextField();
        jPanel6.add((Component)jTextField6, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myLocalVariablePrefixField = jTextField5 = new JTextField();
        jPanel6.add((Component)jTextField5, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myFieldSuffixField = jTextField4 = new JTextField();
        jPanel6.add((Component)jTextField4, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myStaticFieldSuffixField = jTextField3 = new JTextField();
        jPanel6.add((Component)jTextField3, new GridConstraints(2, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myParameterSuffixField = jTextField2 = new JTextField();
        jPanel6.add((Component)jTextField2, new GridConstraints(3, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        this.myLocalVariableSuffixField = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(4, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.name.suffix"));
        jPanel6.add((Component)jLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.name.prefix"));
        jPanel6.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.naming.final.modifier"), (int)0, (int)0, null, null));
        this.myCbGenerateFinalLocals = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.make.generated.local.variables.final"));
        jCheckBox5.setMargin(new Insets(5, 10, 2, 2));
        jPanel7.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbGenerateFinalParameters = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.make.generated.parameters.final"));
        jCheckBox4.setMargin(new Insets(5, 10, 2, 2));
        jPanel7.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCbUseExternalAnnotations = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("use.external.annotations"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOverridePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Override Method Signature", (int)0, (int)0, null, null));
        this.myInsertOverrideAnnotationCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("insert.override.annotation"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jCheckBox2, gridBagConstraints);
        this.myRepeatSynchronizedCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Repeat synchronized modifier");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(7);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        jPanel2.add((Component)jCheckBox, gridBagConstraints2);
        this.myVisibilityPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, "West");
        JPanel jPanel8 = this.myCommenterPanel;
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel8, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel9, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel9.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.naming.functional.expressions"), (int)0, (int)0, null, null));
        Spacer spacer4 = new Spacer();
        jPanel9.add((Component)spacer4, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myReplaceInstanceOfCb = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Replace instanceof with MyClass.class::isInstance");
        jPanel9.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myReplaceCastCb = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Replace cast with MyClass.class::cast");
        jPanel9.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myReplaceNullCheckCb = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Replace null-check with Objects::nonNull or Objects::isNull");
        jPanel9.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

