/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.ConfigurableFactory;
import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesPanel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsListener;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesConfigurable
extends SearchableConfigurable.Parent.Abstract
implements OptionsContainingConfigurable,
Configurable.NoMargin,
Configurable.NoScroll,
Configurable.VariableProjectAppLevel {
    private CodeStyleSchemesPanel myRootSchemesPanel;
    private CodeStyleSchemesModel myModel;
    private List<CodeStyleConfigurableWrapper> myPanels;
    private boolean myResetCompleted = false;
    private boolean myInitResetInvoked = false;
    private boolean myRevertCompleted = false;
    private final Project myProject;

    public CodeStyleSchemesConfigurable(Project project2) {
        this.myProject = project2;
    }

    public JComponent createComponent() {
        this.myModel = this.ensureModel();
        return this.myPanels == null || this.myPanels.isEmpty() ? null : this.myPanels.get(0).createComponent();
    }

    public boolean hasOwnContent() {
        return true;
    }

    public void disposeUIResources() {
        if (this.myPanels != null) {
            try {
                super.disposeUIResources();
                for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
                    panel2.disposeUIResources();
                }
            }
            finally {
                this.myPanels = null;
                this.myModel = null;
                this.myRootSchemesPanel = null;
                this.myResetCompleted = false;
                this.myRevertCompleted = false;
                this.myInitResetInvoked = false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reset() {
        if (!this.myInitResetInvoked) {
            try {
                if (this.myResetCompleted) return;
                try {
                    this.resetImpl();
                    return;
                }
                finally {
                    this.myResetCompleted = true;
                }
            }
            finally {
                this.myInitResetInvoked = true;
            }
        } else {
            this.revert();
        }
    }

    private void resetImpl() {
        if (this.myModel != null) {
            this.myModel.reset();
        }
        if (this.myPanels != null) {
            for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
                panel2.resetPanel();
            }
        }
    }

    public synchronized void resetFromChild() {
        if (!this.myResetCompleted) {
            try {
                this.resetImpl();
            }
            finally {
                this.myResetCompleted = true;
            }
        }
    }

    public void revert() {
        if (this.myModel.isSchemeListModified() || this.isSomeSchemeModified()) {
            this.myRevertCompleted = false;
        }
        if (!this.myRevertCompleted) {
            try {
                this.resetImpl();
            }
            finally {
                this.myRevertCompleted = true;
            }
        }
    }

    private boolean isSomeSchemeModified() {
        if (this.myPanels != null) {
            for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
                if (!panel2.isPanelModified()) continue;
                return true;
            }
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.myModel.apply();
        for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
            panel2.applyPanel();
        }
        EditorFactory.getInstance().refreshAllEditors();
    }

    protected Configurable[] buildConfigurables() {
        this.myPanels = new ArrayList<CodeStyleConfigurableWrapper>();
        List<Object> providers2 = Arrays.asList(Extensions.getExtensions((ExtensionPointName)CodeStyleSettingsProvider.EXTENSION_POINT_NAME));
        providers2.sort((p1, p2) -> {
            String name2;
            if (!p1.getPriority().equals((Object)p2.getPriority())) {
                return p1.getPriority().compareTo((Enum)p2.getPriority());
            }
            String name1 = p1.getConfigurableDisplayName();
            if (name1 == null) {
                name1 = "";
            }
            if ((name2 = p2.getConfigurableDisplayName()) == null) {
                name2 = "";
            }
            return name1.compareToIgnoreCase(name2);
        });
        for (CodeStyleSettingsProvider codeStyleSettingsProvider : providers2) {
            if (!codeStyleSettingsProvider.hasSettingsPage()) continue;
            CodeStyleConfigurableWrapper e = ConfigurableFactory.Companion.getInstance().createCodeStyleConfigurable(codeStyleSettingsProvider, this.ensureModel(), this);
            this.myPanels.add(e);
        }
        int size = this.myPanels.size();
        Configurable[] configurableArray = new Configurable[size > 0 ? size - 1 : 0];
        for (int i2 = 0; i2 < configurableArray.length; ++i2) {
            configurableArray[i2] = (Configurable)this.myPanels.get(i2 + 1);
        }
        return configurableArray;
    }

    void resetCompleted() {
        this.myRevertCompleted = false;
    }

    CodeStyleSchemesModel ensureModel() {
        if (this.myModel == null) {
            this.myModel = new CodeStyleSchemesModel(this.myProject);
            this.myRootSchemesPanel = new CodeStyleSchemesPanel(this.myModel, 0);
            this.myModel.addListener(new CodeStyleSettingsListener(){

                @Override
                public void currentSchemeChanged(Object source) {
                    if (source != CodeStyleSchemesConfigurable.this.myRootSchemesPanel) {
                        CodeStyleSchemesConfigurable.this.myRootSchemesPanel.onSelectedSchemeChanged();
                    }
                }

                @Override
                public void schemeListChanged() {
                    CodeStyleSchemesConfigurable.this.myRootSchemesPanel.resetSchemesCombo();
                }

                @Override
                public void schemeChanged(CodeStyleScheme scheme2) {
                    if (scheme2 == CodeStyleSchemesConfigurable.this.myModel.getSelectedScheme()) {
                        CodeStyleSchemesConfigurable.this.myRootSchemesPanel.onSelectedSchemeChanged();
                    }
                }
            });
        }
        return this.myModel;
    }

    public String getDisplayName() {
        return "Code Style";
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.globalcodestyle";
    }

    public boolean isModified() {
        if (this.myModel != null) {
            if (this.myModel.containsModifiedCodeStyleSettings()) {
                return true;
            }
            for (Configurable configurable : this.myPanels) {
                if (!configurable.isModified()) continue;
                return true;
            }
            boolean schemeListModified = this.myModel.isSchemeListModified();
            if (schemeListModified) {
                this.myRevertCompleted = false;
            }
            return schemeListModified;
        }
        return false;
    }

    @NotNull
    public String getId() {
        if ("preferences.sourceCode" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/CodeStyleSchemesConfigurable", "getId"));
        }
        return "preferences.sourceCode";
    }

    @Override
    public Set<String> processListOptions() {
        HashSet<String> result2 = new HashSet<String>();
        for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
            result2.addAll(panel2.processListOptions());
        }
        return result2;
    }

    public boolean isProjectLevel() {
        return this.myModel != null && this.myModel.isUsePerProjectSettings();
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(String name2) {
        if (this.myPanels == null) {
            this.buildConfigurables();
        }
        return this.myPanels.stream().filter(panel2 -> panel2.getDisplayName().equals(name2)).findFirst().orElse(null);
    }
}

