/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.QualifyJavadocOptions;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class FullyQualifiedNamesInJavadocOptionProvider {
    private JPanel myPanel;
    private ComboBox myComboBox;

    public FullyQualifiedNamesInJavadocOptionProvider() {
        this.composePanel();
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/FullyQualifiedNamesInJavadocOptionProvider", "reset"));
        }
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        QualifyJavadocOptions option = QualifyJavadocOptions.fromIntValue(javaSettings.CLASS_NAMES_IN_JAVADOC);
        this.myComboBox.setSelectedItem((Object)option);
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/FullyQualifiedNamesInJavadocOptionProvider", "apply"));
        }
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        javaSettings.CLASS_NAMES_IN_JAVADOC = this.getSelectedIntOptionValue();
    }

    public boolean isModified(CodeStyleSettings settings) {
        JavaCodeStyleSettings javaSettings = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        return javaSettings.CLASS_NAMES_IN_JAVADOC != this.getSelectedIntOptionValue();
    }

    private int getSelectedIntOptionValue() {
        QualifyJavadocOptions item = (QualifyJavadocOptions)((Object)this.myComboBox.getSelectedItem());
        return item.getIntOptionValue();
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/FullyQualifiedNamesInJavadocOptionProvider", "getPanel"));
        }
        return jPanel;
    }

    private void composePanel() {
        this.myPanel = new JPanel(new GridBagLayout());
        this.myComboBox = new ComboBox();
        for (QualifyJavadocOptions options : QualifyJavadocOptions.values()) {
            this.myComboBox.addItem((Object)options);
        }
        this.myComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

            public void customize(JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
                if (value2 instanceof QualifyJavadocOptions) {
                    this.setText(((QualifyJavadocOptions)((Object)value2)).getPresentableText());
                }
            }
        });
        JLabel title = new JLabel(ApplicationBundle.message((String)"radio.use.fully.qualified.class.names.in.javadoc", (Object[])new Object[0]));
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        GridBagConstraints left = new GridBagConstraints();
        left.anchor = 17;
        GridBagConstraints right = new GridBagConstraints();
        right.anchor = 17;
        right.weightx = 1.0;
        right.insets = JBUI.insetsLeft((int)5);
        this.myPanel.add((Component)title, left);
        this.myPanel.add((Component)this.myComboBox, right);
    }
}

