/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.group;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.group.ArrangementGroupingComponent;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementEditorAware;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementRepresentationAware;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.AbstractTableCellEditor;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementGroupingRulesControl
extends JBTable {
    @NotNull
    public static final DataKey<ArrangementGroupingRulesControl> KEY = DataKey.create((String)"Arrangement.Rule.Group.Control");
    @NotNull
    private final Map<ArrangementSettingsToken, ArrangementGroupingComponent> myComponents;
    @NotNull
    private final ArrangementStandardSettingsManager mySettingsManager;
    private int myRowUnderMouse;

    public ArrangementGroupingRulesControl(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider) {
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsManager", "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingRulesControl", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingRulesControl", "<init>"));
        }
        super((TableModel)new DefaultTableModel(0, 1));
        this.myComponents = ContainerUtilRt.newHashMap();
        this.myRowUnderMouse = -1;
        this.mySettingsManager = settingsManager;
        this.setDefaultRenderer(Object.class, new MyRenderer());
        this.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)((Object)new MyEditor()));
        this.setShowColumns(false);
        this.setShowGrid(false);
        this.setBorder(IdeBorderFactory.createBorder());
        this.setSelectionMode(0);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        List groupingTokens = settingsManager.getSupportedGroupingTokens();
        if (groupingTokens != null) {
            for (CompositeArrangementSettingsToken token : groupingTokens) {
                ArrangementGroupingComponent component = new ArrangementGroupingComponent(token, colorsProvider, settingsManager);
                this.myComponents.put(token.getToken(), component);
                this.getModel().addRow(new Object[]{component});
            }
        }
    }

    public DefaultTableModel getModel() {
        return (DefaultTableModel)super.getModel();
    }

    public void setRules(@Nullable List<ArrangementGroupingRule> rules) {
        for (ArrangementGroupingComponent component : this.myComponents.values()) {
            component.setSelected(false);
        }
        if (rules == null) {
            return;
        }
        DefaultTableModel model = this.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(model.getRowCount() - 1);
        }
        HashSet groupingTokens = ContainerUtilRt.newHashSet(this.myComponents.keySet());
        for (ArrangementGroupingRule rule : rules) {
            ArrangementSettingsToken groupingType = rule.getGroupingType();
            ArrangementGroupingComponent component = this.myComponents.get(groupingType);
            component.setSelected(true);
            component.setOrderType(rule.getOrderType());
            model.addRow(new Object[]{component});
            groupingTokens.remove(groupingType);
        }
        List types = ContainerUtilRt.newArrayList((Iterable)groupingTokens);
        types = this.mySettingsManager.sort((Collection)types);
        for (ArrangementSettingsToken type2 : types) {
            model.addRow(new Object[]{this.myComponents.get(type2)});
        }
    }

    @NotNull
    public List<ArrangementGroupingRule> getRules() {
        ArrayList<ArrangementGroupingRule> result2 = new ArrayList<ArrangementGroupingRule>();
        DefaultTableModel model = this.getModel();
        int max = model.getRowCount();
        for (int i2 = 0; i2 < max; ++i2) {
            ArrangementGroupingComponent component = (ArrangementGroupingComponent)model.getValueAt(i2, 0);
            if (!component.isSelected()) continue;
            ArrangementSettingsToken orderType = component.getOrderType();
            if (orderType == null) {
                result2.add(new ArrangementGroupingRule(component.getGroupingType()));
                continue;
            }
            result2.add(new ArrangementGroupingRule(component.getGroupingType(), orderType));
        }
        ArrayList<ArrangementGroupingRule> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingRulesControl", "getRules"));
        }
        return arrayList;
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 503) {
            int oldRow = this.myRowUnderMouse;
            this.myRowUnderMouse = this.rowAtPoint(e.getPoint());
            if (oldRow >= 0 && this.myRowUnderMouse != oldRow) {
                this.getModel().fireTableRowsUpdated(oldRow, oldRow);
            }
            if (this.myRowUnderMouse >= 0 && this.myRowUnderMouse != oldRow) {
                this.getModel().fireTableRowsUpdated(this.myRowUnderMouse, this.myRowUnderMouse);
            }
        }
        super.processMouseMotionEvent(e);
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 505 && this.myRowUnderMouse >= 0) {
            int row = this.myRowUnderMouse;
            this.myRowUnderMouse = -1;
            this.getModel().fireTableRowsUpdated(row, row);
        }
        super.processMouseEvent(e);
    }

    private static class MyEditor
    extends AbstractTableCellEditor {
        @Nullable
        Object myValue;

        private MyEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
            if (value2 instanceof ArrangementEditorAware) {
                this.myValue = value2;
                return ((ArrangementEditorAware)value2).getComponent();
            }
            return null;
        }

        public Object getCellEditorValue() {
            return this.myValue;
        }

        public boolean stopCellEditing() {
            super.stopCellEditing();
            this.myValue = null;
            return true;
        }
    }

    private class MyRenderer
    implements TableCellRenderer {
        private MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value2 instanceof ArrangementGroupingComponent) {
                ArrangementGroupingComponent component = (ArrangementGroupingComponent)value2;
                component.setRowIndex(row + 1);
                component.setHighlight(ArrangementGroupingRulesControl.this.myRowUnderMouse == row || table.isRowSelected(row));
                return component;
            }
            if (value2 instanceof ArrangementRepresentationAware) {
                return ((ArrangementRepresentationAware)value2).getComponent();
            }
            return null;
        }
    }
}

